/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeExportImageTasksRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeExportImageTasksRequestMarshaller
implements Marshaller<Request<DescribeExportImageTasksRequest>, DescribeExportImageTasksRequest> {
    public Request<DescribeExportImageTasksRequest> marshall(DescribeExportImageTasksRequest describeExportImageTasksRequest) {
        SdkInternalList describeExportImageTasksRequestExportImageTaskIdsList;
        if (describeExportImageTasksRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeExportImageTasksRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeExportImageTasks");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeExportImageTasksRequestFiltersList = (SdkInternalList)describeExportImageTasksRequest.getFilters();
        if (!describeExportImageTasksRequestFiltersList.isEmpty() || !describeExportImageTasksRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeExportImageTasksRequestFiltersListValue : describeExportImageTasksRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeExportImageTasksRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeExportImageTasksRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeExportImageTasksRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeExportImageTasksRequestExportImageTaskIdsList = (SdkInternalList)describeExportImageTasksRequest.getExportImageTaskIds()).isEmpty() || !describeExportImageTasksRequestExportImageTaskIdsList.isAutoConstruct()) {
            int exportImageTaskIdsListIndex = 1;
            for (String describeExportImageTasksRequestExportImageTaskIdsListValue : describeExportImageTasksRequestExportImageTaskIdsList) {
                if (describeExportImageTasksRequestExportImageTaskIdsListValue != null) {
                    request.addParameter("ExportImageTaskId." + exportImageTaskIdsListIndex, StringUtils.fromString((String)describeExportImageTasksRequestExportImageTaskIdsListValue));
                }
                ++exportImageTaskIdsListIndex;
            }
        }
        if (describeExportImageTasksRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeExportImageTasksRequest.getMaxResults()));
        }
        if (describeExportImageTasksRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeExportImageTasksRequest.getNextToken()));
        }
        return request;
    }
}

