/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.ModifyReplicationGroupRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyReplicationGroupRequestMarshaller
implements Marshaller<Request<ModifyReplicationGroupRequest>, ModifyReplicationGroupRequest> {
    public Request<ModifyReplicationGroupRequest> marshall(ModifyReplicationGroupRequest modifyReplicationGroupRequest) {
        SdkInternalList securityGroupIdsList;
        SdkInternalList cacheSecurityGroupNamesList;
        if (modifyReplicationGroupRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyReplicationGroupRequest, "AmazonElastiCache");
        request.addParameter("Action", "ModifyReplicationGroup");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyReplicationGroupRequest.getReplicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringUtils.fromString((String)modifyReplicationGroupRequest.getReplicationGroupId()));
        }
        if (modifyReplicationGroupRequest.getReplicationGroupDescription() != null) {
            request.addParameter("ReplicationGroupDescription", StringUtils.fromString((String)modifyReplicationGroupRequest.getReplicationGroupDescription()));
        }
        if (modifyReplicationGroupRequest.getPrimaryClusterId() != null) {
            request.addParameter("PrimaryClusterId", StringUtils.fromString((String)modifyReplicationGroupRequest.getPrimaryClusterId()));
        }
        if (modifyReplicationGroupRequest.getSnapshottingClusterId() != null) {
            request.addParameter("SnapshottingClusterId", StringUtils.fromString((String)modifyReplicationGroupRequest.getSnapshottingClusterId()));
        }
        if (modifyReplicationGroupRequest.getAutomaticFailoverEnabled() != null) {
            request.addParameter("AutomaticFailoverEnabled", StringUtils.fromBoolean((Boolean)modifyReplicationGroupRequest.getAutomaticFailoverEnabled()));
        }
        if (!(cacheSecurityGroupNamesList = (SdkInternalList)modifyReplicationGroupRequest.getCacheSecurityGroupNames()).isEmpty() || !cacheSecurityGroupNamesList.isAutoConstruct()) {
            int cacheSecurityGroupNamesListIndex = 1;
            for (String cacheSecurityGroupNamesListValue : cacheSecurityGroupNamesList) {
                if (cacheSecurityGroupNamesListValue != null) {
                    request.addParameter("CacheSecurityGroupNames.CacheSecurityGroupName." + cacheSecurityGroupNamesListIndex, StringUtils.fromString((String)cacheSecurityGroupNamesListValue));
                }
                ++cacheSecurityGroupNamesListIndex;
            }
        }
        if (!(securityGroupIdsList = (SdkInternalList)modifyReplicationGroupRequest.getSecurityGroupIds()).isEmpty() || !securityGroupIdsList.isAutoConstruct()) {
            int securityGroupIdsListIndex = 1;
            for (String securityGroupIdsListValue : securityGroupIdsList) {
                if (securityGroupIdsListValue != null) {
                    request.addParameter("SecurityGroupIds.SecurityGroupId." + securityGroupIdsListIndex, StringUtils.fromString((String)securityGroupIdsListValue));
                }
                ++securityGroupIdsListIndex;
            }
        }
        if (modifyReplicationGroupRequest.getPreferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)modifyReplicationGroupRequest.getPreferredMaintenanceWindow()));
        }
        if (modifyReplicationGroupRequest.getNotificationTopicArn() != null) {
            request.addParameter("NotificationTopicArn", StringUtils.fromString((String)modifyReplicationGroupRequest.getNotificationTopicArn()));
        }
        if (modifyReplicationGroupRequest.getCacheParameterGroupName() != null) {
            request.addParameter("CacheParameterGroupName", StringUtils.fromString((String)modifyReplicationGroupRequest.getCacheParameterGroupName()));
        }
        if (modifyReplicationGroupRequest.getNotificationTopicStatus() != null) {
            request.addParameter("NotificationTopicStatus", StringUtils.fromString((String)modifyReplicationGroupRequest.getNotificationTopicStatus()));
        }
        if (modifyReplicationGroupRequest.getApplyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringUtils.fromBoolean((Boolean)modifyReplicationGroupRequest.getApplyImmediately()));
        }
        if (modifyReplicationGroupRequest.getEngineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)modifyReplicationGroupRequest.getEngineVersion()));
        }
        if (modifyReplicationGroupRequest.getAutoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringUtils.fromBoolean((Boolean)modifyReplicationGroupRequest.getAutoMinorVersionUpgrade()));
        }
        if (modifyReplicationGroupRequest.getSnapshotRetentionLimit() != null) {
            request.addParameter("SnapshotRetentionLimit", StringUtils.fromInteger((Integer)modifyReplicationGroupRequest.getSnapshotRetentionLimit()));
        }
        if (modifyReplicationGroupRequest.getSnapshotWindow() != null) {
            request.addParameter("SnapshotWindow", StringUtils.fromString((String)modifyReplicationGroupRequest.getSnapshotWindow()));
        }
        if (modifyReplicationGroupRequest.getCacheNodeType() != null) {
            request.addParameter("CacheNodeType", StringUtils.fromString((String)modifyReplicationGroupRequest.getCacheNodeType()));
        }
        return request;
    }
}

