/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.generic;

import com.amazonaws.services.simpleworkflow.flow.StartWorkflowOptions;
import com.amazonaws.services.simpleworkflow.model.ChildPolicy;
import com.amazonaws.services.simpleworkflow.model.WorkflowType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StartWorkflowExecutionParameters {
    private String workflowId;
    private WorkflowType workflowType;
    private String taskList;
    private String input;
    private long executionStartToCloseTimeoutSeconds = -2L;
    private long taskStartToCloseTimeoutSeconds = -2L;
    private List<String> tagList;
    private int taskPriority;
    private String lambdaRole;
    private ChildPolicy childPolicy;

    public String getWorkflowId() {
        return this.workflowId;
    }

    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public StartWorkflowExecutionParameters withWorkflowId(String workflowId) {
        this.workflowId = workflowId;
        return this;
    }

    public WorkflowType getWorkflowType() {
        return this.workflowType;
    }

    public void setWorkflowType(WorkflowType workflowType) {
        this.workflowType = workflowType;
    }

    public StartWorkflowExecutionParameters withWorkflowType(WorkflowType workflowType) {
        this.workflowType = workflowType;
        return this;
    }

    public String getTaskList() {
        return this.taskList;
    }

    public void setTaskList(String taskList) {
        this.taskList = taskList;
    }

    public StartWorkflowExecutionParameters withTaskList(String taskList) {
        this.taskList = taskList;
        return this;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public StartWorkflowExecutionParameters withInput(String input) {
        this.input = input;
        return this;
    }

    public long getExecutionStartToCloseTimeout() {
        return this.executionStartToCloseTimeoutSeconds;
    }

    public void setExecutionStartToCloseTimeoutSeconds(long executionStartToCloseTimeoutSeconds) {
        this.executionStartToCloseTimeoutSeconds = executionStartToCloseTimeoutSeconds;
    }

    public StartWorkflowExecutionParameters withExecutionStartToCloseTimeoutSeconds(long executionStartToCloseTimeoutSeconds) {
        this.executionStartToCloseTimeoutSeconds = executionStartToCloseTimeoutSeconds;
        return this;
    }

    public long getTaskStartToCloseTimeoutSeconds() {
        return this.taskStartToCloseTimeoutSeconds;
    }

    public void setTaskStartToCloseTimeoutSeconds(long taskStartToCloseTimeoutSeconds) {
        this.taskStartToCloseTimeoutSeconds = taskStartToCloseTimeoutSeconds;
    }

    public StartWorkflowExecutionParameters withTaskStartToCloseTimeoutSeconds(long taskStartToCloseTimeoutSeconds) {
        this.taskStartToCloseTimeoutSeconds = taskStartToCloseTimeoutSeconds;
        return this;
    }

    public ChildPolicy getChildPolicy() {
        return this.childPolicy;
    }

    public void setChildPolicy(ChildPolicy childPolicy) {
        this.childPolicy = childPolicy;
    }

    public StartWorkflowExecutionParameters withChildPolicy(ChildPolicy childPolicy) {
        this.childPolicy = childPolicy;
        return this;
    }

    public List<String> getTagList() {
        if (this.tagList == null) {
            this.tagList = new ArrayList<String>();
        }
        return this.tagList;
    }

    public void setTagList(Collection<String> tagList) {
        ArrayList<String> tagListCopy = new ArrayList<String>();
        if (tagList != null) {
            tagListCopy.addAll(tagList);
        }
        this.tagList = tagListCopy;
    }

    public StartWorkflowExecutionParameters withTagList(String ... tagList) {
        String[] stringArray = tagList;
        int n = tagList.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            this.getTagList().add(value);
            ++n2;
        }
        return this;
    }

    public StartWorkflowExecutionParameters withTagList(Collection<String> tagList) {
        ArrayList<String> tagListCopy = new ArrayList<String>();
        if (tagList != null) {
            tagListCopy.addAll(tagList);
        }
        this.tagList = tagListCopy;
        return this;
    }

    public int getTaskPriority() {
        return this.taskPriority;
    }

    public void setTaskPriority(int taskPriority) {
        this.taskPriority = taskPriority;
    }

    public StartWorkflowExecutionParameters withTaskPriority(int taskPriority) {
        this.taskPriority = taskPriority;
        return this;
    }

    public String getLambdaRole() {
        return this.lambdaRole;
    }

    public void setLambdaRole(String lambdaRole) {
        this.lambdaRole = lambdaRole;
    }

    public StartWorkflowExecutionParameters withLambdaRole(String lambdaRole) {
        this.lambdaRole = lambdaRole;
        return this;
    }

    public StartWorkflowExecutionParameters createStartWorkflowExecutionParametersFromOptions(StartWorkflowOptions options, StartWorkflowOptions optionsOverride) {
        String lambdaRole;
        ChildPolicy childPolicy;
        Integer taskPriority;
        String taskList;
        List<String> tagList;
        Long taskStartToCloseTimeout;
        Long executionStartToCloseTimeout;
        StartWorkflowExecutionParameters parameters = this.clone();
        if (options != null) {
            executionStartToCloseTimeout = options.getExecutionStartToCloseTimeoutSeconds();
            if (executionStartToCloseTimeout != null) {
                parameters.setExecutionStartToCloseTimeoutSeconds(executionStartToCloseTimeout);
            }
            if ((taskStartToCloseTimeout = options.getTaskStartToCloseTimeoutSeconds()) != null) {
                parameters.setTaskStartToCloseTimeoutSeconds(taskStartToCloseTimeout);
            }
            if ((tagList = options.getTagList()) != null) {
                parameters.setTagList(tagList);
            }
            if ((taskList = options.getTaskList()) != null && !taskList.isEmpty()) {
                parameters.setTaskList(taskList);
            }
            if ((taskPriority = options.getTaskPriority()) != null) {
                parameters.setTaskPriority(taskPriority);
            }
            if ((childPolicy = options.getChildPolicy()) != null) {
                parameters.setChildPolicy(childPolicy);
            }
            if ((lambdaRole = options.getLambdaRole()) != null && !lambdaRole.isEmpty()) {
                parameters.setLambdaRole(lambdaRole);
            }
        }
        if (optionsOverride != null) {
            executionStartToCloseTimeout = optionsOverride.getExecutionStartToCloseTimeoutSeconds();
            if (executionStartToCloseTimeout != null) {
                parameters.setExecutionStartToCloseTimeoutSeconds(executionStartToCloseTimeout);
            }
            if ((taskStartToCloseTimeout = optionsOverride.getTaskStartToCloseTimeoutSeconds()) != null) {
                parameters.setTaskStartToCloseTimeoutSeconds(taskStartToCloseTimeout);
            }
            if ((tagList = optionsOverride.getTagList()) != null) {
                parameters.setTagList(tagList);
            }
            if ((taskList = optionsOverride.getTaskList()) != null && !taskList.isEmpty()) {
                parameters.setTaskList(taskList);
            }
            if ((taskPriority = optionsOverride.getTaskPriority()) != null) {
                parameters.setTaskPriority(taskPriority);
            }
            if ((childPolicy = optionsOverride.getChildPolicy()) != null) {
                parameters.setChildPolicy(childPolicy);
            }
            if ((lambdaRole = optionsOverride.getLambdaRole()) != null && !lambdaRole.isEmpty()) {
                parameters.setLambdaRole(lambdaRole);
            }
        }
        return parameters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("WorkflowId: " + this.workflowId + ", ");
        sb.append("WorkflowType: " + this.workflowType + ", ");
        sb.append("TaskList: " + this.taskList + ", ");
        sb.append("Input: " + this.input + ", ");
        sb.append("StartToCloseTimeout: " + this.executionStartToCloseTimeoutSeconds + ", ");
        sb.append("TagList: " + this.tagList + ", ");
        sb.append("TaskPriority: " + this.taskPriority + ", ");
        sb.append("ChildPolicy: " + this.childPolicy + ", ");
        sb.append("LambdaRole: " + this.lambdaRole + ", ");
        sb.append("}");
        return sb.toString();
    }

    public StartWorkflowExecutionParameters clone() {
        StartWorkflowExecutionParameters result = new StartWorkflowExecutionParameters();
        result.setInput(this.input);
        result.setExecutionStartToCloseTimeoutSeconds(this.executionStartToCloseTimeoutSeconds);
        result.setTaskStartToCloseTimeoutSeconds(this.taskStartToCloseTimeoutSeconds);
        result.setTagList(this.tagList);
        result.setTaskList(this.taskList);
        result.setWorkflowId(this.workflowId);
        result.setWorkflowType(this.workflowType);
        result.setTaskPriority(this.taskPriority);
        result.setChildPolicy(this.childPolicy);
        result.setLambdaRole(this.lambdaRole);
        return result;
    }
}

