/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transfer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.transfer.model.S3Tag;
import com.amazonaws.services.transfer.model.transform.TagStepDetailsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TagStepDetails
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private List<S3Tag> tags;
    private String sourceFileLocation;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public TagStepDetails withName(String name) {
        this.setName(name);
        return this;
    }

    public List<S3Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<S3Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<S3Tag>(tags);
    }

    public TagStepDetails withTags(S3Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<S3Tag>(tags.length));
        }
        for (S3Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public TagStepDetails withTags(Collection<S3Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setSourceFileLocation(String sourceFileLocation) {
        this.sourceFileLocation = sourceFileLocation;
    }

    public String getSourceFileLocation() {
        return this.sourceFileLocation;
    }

    public TagStepDetails withSourceFileLocation(String sourceFileLocation) {
        this.setSourceFileLocation(sourceFileLocation);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getSourceFileLocation() != null) {
            sb.append("SourceFileLocation: ").append(this.getSourceFileLocation());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagStepDetails)) {
            return false;
        }
        TagStepDetails other = (TagStepDetails)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getSourceFileLocation() == null ^ this.getSourceFileLocation() == null) {
            return false;
        }
        return other.getSourceFileLocation() == null || other.getSourceFileLocation().equals(this.getSourceFileLocation());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getSourceFileLocation() == null ? 0 : this.getSourceFileLocation().hashCode());
        return hashCode;
    }

    public TagStepDetails clone() {
        try {
            return (TagStepDetails)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TagStepDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

