/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Type;
import java.math.BigDecimal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberDeserializer
implements ObjectDeserializer {
    public static final NumberDeserializer instance = new NumberDeserializer();

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        JSONLexer lexer = parser.lexer;
        if (lexer.token() == 2) {
            if (clazz == Double.TYPE || clazz == Double.class) {
                String val2 = lexer.numberString();
                lexer.nextToken(16);
                return (T)Double.valueOf(Double.parseDouble(val2));
            }
            long val3 = lexer.longValue();
            lexer.nextToken(16);
            if (clazz == Short.TYPE || clazz == Short.class) {
                if (val3 > 32767L || val3 < -32768L) {
                    throw new JSONException("short overflow : " + val3);
                }
                return (T)Short.valueOf((short)val3);
            }
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                if (val3 > 127L || val3 < -128L) {
                    throw new JSONException("short overflow : " + val3);
                }
                return (T)Byte.valueOf((byte)val3);
            }
            if (val3 >= Integer.MIN_VALUE && val3 <= Integer.MAX_VALUE) {
                return (T)Integer.valueOf((int)val3);
            }
            return (T)Long.valueOf(val3);
        }
        if (lexer.token() == 3) {
            if (clazz == Double.TYPE || clazz == Double.class) {
                String val4 = lexer.numberString();
                lexer.nextToken(16);
                return (T)Double.valueOf(Double.parseDouble(val4));
            }
            if (clazz == Short.TYPE || clazz == Short.class) {
                BigDecimal val5 = lexer.decimalValue();
                lexer.nextToken(16);
                short shortValue = TypeUtils.shortValue(val5);
                return (T)Short.valueOf(shortValue);
            }
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                BigDecimal val6 = lexer.decimalValue();
                lexer.nextToken(16);
                byte byteValue = TypeUtils.byteValue(val6);
                return (T)Byte.valueOf(byteValue);
            }
            BigDecimal val7 = lexer.decimalValue();
            lexer.nextToken(16);
            if (lexer.isEnabled(Feature.UseBigDecimal)) {
                return (T)val7;
            }
            return (T)Double.valueOf(val7.doubleValue());
        }
        if (lexer.token() == 18 && "NaN".equals(lexer.stringVal())) {
            lexer.nextToken();
            Number nan = null;
            if (clazz == Double.class) {
                nan = Double.NaN;
            } else if (clazz == Float.class) {
                nan = Float.valueOf(Float.NaN);
            }
            return (T)nan;
        }
        Object value = parser.parse();
        if (value == null) {
            return null;
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            try {
                return (T)TypeUtils.castToDouble(value);
            }
            catch (Exception ex) {
                throw new JSONException("parseDouble error, field : " + fieldName, ex);
            }
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            try {
                return (T)TypeUtils.castToShort(value);
            }
            catch (Exception ex) {
                throw new JSONException("parseShort error, field : " + fieldName, ex);
            }
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            try {
                return (T)TypeUtils.castToByte(value);
            }
            catch (Exception ex) {
                throw new JSONException("parseByte error, field : " + fieldName, ex);
            }
        }
        return (T)TypeUtils.castToBigDecimal(value);
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

