/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.tugraph;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class CsvDesc
implements Comparable<CsvDesc> {
    private String path;
    private long size;
    private String dataFormat;
    private String label;
    private int nHeaderLine;
    private boolean isVertexFile;
    private String edgeSrcLabel;
    private String edgeDstLabel;
    private List<String> columns = new ArrayList<String>();

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getSize() {
        return this.size;
    }

    public void setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public int getHeaderLine() {
        return this.nHeaderLine;
    }

    public void setHeaderLine(int nHeaderLine) {
        this.nHeaderLine = nHeaderLine;
    }

    public void setFileType(boolean isVertexFile) {
        this.isVertexFile = isVertexFile;
    }

    public void setEdgeSrcLabel(String edgeSrcLabel) {
        this.edgeSrcLabel = edgeSrcLabel;
    }

    public void setEdgeDstLabel(String edgeDstLabel) {
        this.edgeDstLabel = edgeDstLabel;
    }

    public void addColumn(String column) {
        this.columns.add(column);
    }

    @Override
    public int compareTo(CsvDesc csv) {
        if (this.isVertexFile) {
            if (csv.isVertexFile) {
                return 0;
            }
            if (!csv.isVertexFile) {
                return -1;
            }
        } else {
            if (csv.isVertexFile) {
                return 1;
            }
            if (!csv.isVertexFile) {
                return 0;
            }
        }
        return 0;
    }

    public byte[] dump(boolean hasPath) throws UnsupportedEncodingException {
        JSONObject jsonObject = new JSONObject();
        if (hasPath) {
            jsonObject.put("path", (Object)this.path);
        }
        jsonObject.put("header", (Object)this.nHeaderLine);
        jsonObject.put("format", (Object)this.dataFormat);
        jsonObject.put("label", (Object)this.label);
        JSONArray tmp = new JSONArray();
        for (String column : this.columns) {
            tmp.add(column);
        }
        jsonObject.put("columns", (Object)tmp);
        if (!this.isVertexFile) {
            jsonObject.put("SRC_ID", (Object)this.edgeSrcLabel);
            jsonObject.put("DST_ID", (Object)this.edgeDstLabel);
        }
        JSONArray array = new JSONArray();
        array.add(jsonObject);
        JSONObject obj = new JSONObject();
        obj.put("files", (Object)array);
        String desc = obj.toJSONString();
        byte[] textByteDesc = new byte[]{};
        textByteDesc = desc.getBytes("UTF-8");
        return textByteDesc;
    }
}

