/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.client;

import com.baidu.brpc.JprotobufRpcMethodInfo;
import com.baidu.brpc.ProtobufRpcMethodInfo;
import com.baidu.brpc.RpcContext;
import com.baidu.brpc.RpcMethodInfo;
import com.baidu.brpc.client.RpcCallback;
import com.baidu.brpc.client.RpcClient;
import com.baidu.brpc.client.RpcFuture;
import com.baidu.brpc.exceptions.RpcException;
import com.baidu.brpc.interceptor.DefaultInterceptorChain;
import com.baidu.brpc.interceptor.Interceptor;
import com.baidu.brpc.naming.NamingOptions;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import com.baidu.brpc.protocol.nshead.NSHead;
import com.baidu.brpc.protocol.nshead.NSHeadMeta;
import com.baidu.brpc.protocol.push.SPHead;
import com.baidu.brpc.protocol.push.ServerPushProtocol;
import com.baidu.brpc.utils.ProtobufUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrpcProxy
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(BrpcProxy.class);
    private static final Set<String> notProxyMethodSet = new HashSet<String>();
    private RpcClient rpcClient;
    private Map<String, RpcMethodInfo> rpcMethodMap = new HashMap<String, RpcMethodInfo>();

    protected BrpcProxy(RpcClient rpcClient, Class clazz) {
        Method[] methods;
        this.rpcClient = rpcClient;
        for (Method method : methods = clazz.getMethods()) {
            ProtobufUtils.MessageType messageType;
            if (notProxyMethodSet.contains(method.getName())) {
                log.debug("{}:{} does not need to proxy", (Object)method.getDeclaringClass().getName(), (Object)method.getName());
                continue;
            }
            Class<?>[] parameterTypes = method.getParameterTypes();
            int paramLength = parameterTypes.length;
            if (paramLength >= 1 && Future.class.isAssignableFrom(method.getReturnType()) && !RpcCallback.class.isAssignableFrom(parameterTypes[paramLength - 1])) {
                throw new IllegalArgumentException("returnType is Future, but last argument is not RpcCallback");
            }
            Method syncMethod = method;
            if (paramLength > 1) {
                int startIndex = 0;
                int endIndex = paramLength - 1;
                if (RpcCallback.class.isAssignableFrom(parameterTypes[paramLength - 1])) {
                    --endIndex;
                    --paramLength;
                }
                Class[] actualParameterTypes = new Class[paramLength];
                int i = 0;
                while (startIndex <= endIndex) {
                    actualParameterTypes[i] = parameterTypes[startIndex++];
                    ++i;
                }
                try {
                    syncMethod = method.getDeclaringClass().getMethod(method.getName(), actualParameterTypes);
                }
                catch (NoSuchMethodException ex) {
                    throw new IllegalArgumentException("can not find sync method:" + method.getName());
                }
            }
            RpcMethodInfo methodInfo = (messageType = ProtobufUtils.getMessageType(syncMethod)) == ProtobufUtils.MessageType.PROTOBUF ? new ProtobufRpcMethodInfo(syncMethod) : (messageType == ProtobufUtils.MessageType.JPROTOBUF ? new JprotobufRpcMethodInfo(syncMethod) : new RpcMethodInfo(syncMethod));
            this.rpcMethodMap.put(method.getName(), methodInfo);
            log.debug("client serviceName={}, methodName={}", (Object)method.getDeclaringClass().getName(), (Object)method.getName());
        }
    }

    public static <T> T getProxy(RpcClient rpcClient, Class clazz) {
        return BrpcProxy.getProxy(rpcClient, clazz, null);
    }

    public static <T> T getProxy(RpcClient rpcClient, Class clazz, NamingOptions namingOptions) {
        rpcClient.setServiceInterface(clazz, namingOptions);
        rpcClient.getLoadBalanceInterceptor().setRpcClient(rpcClient);
        rpcClient.getInterceptors().add(rpcClient.getLoadBalanceInterceptor());
        Enhancer en = new Enhancer();
        en.setSuperclass(clazz);
        en.setCallback(new BrpcProxy(rpcClient, clazz));
        return (T)en.create();
    }

    @Override
    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        String methodName = method.getName();
        RpcMethodInfo rpcMethodInfo = this.rpcMethodMap.get(methodName);
        if (rpcMethodInfo == null) {
            log.debug("{}:{} does not need to proxy", (Object)method.getDeclaringClass().getName(), (Object)methodName);
            return proxy.invokeSuper(obj, args);
        }
        Request request = null;
        Response response = null;
        List<Interceptor> interceptors = null;
        int readTimeout = 10000;
        int writeTimeout = 10000;
        interceptors = this.rpcClient.getInterceptors();
        request = this.rpcClient.getProtocol().createRequest();
        response = this.rpcClient.getProtocol().getResponse();
        if (this.rpcClient.getProtocol() instanceof ServerPushProtocol) {
            SPHead spHead = ((ServerPushProtocol)this.rpcClient.getProtocol()).createSPHead();
            spHead.setType(0);
            request.setSpHead(spHead);
        }
        request.setCompressType(this.rpcClient.getRpcClientOptions().getCompressType().getNumber());
        request.setSubscribeInfo(this.rpcClient.getSubscribeInfo());
        readTimeout = this.rpcClient.getRpcClientOptions().getReadTimeoutMillis();
        writeTimeout = this.rpcClient.getRpcClientOptions().getWriteTimeoutMillis();
        try {
            request.setTarget(obj);
            request.setRpcMethodInfo(rpcMethodInfo);
            request.setTargetMethod(rpcMethodInfo.getMethod());
            request.setServiceName(rpcMethodInfo.getServiceName());
            request.setMethodName(rpcMethodInfo.getMethodName());
            NSHeadMeta nsHeadMeta = rpcMethodInfo.getNsHeadMeta();
            NSHead nsHead = nsHeadMeta == null ? new NSHead() : new NSHead(0, nsHeadMeta.id(), nsHeadMeta.version(), nsHeadMeta.provider(), 0);
            request.setNsHead(nsHead);
            RpcCallback callback = null;
            int argLength = args.length;
            if (argLength > 1) {
                int startIndex = 0;
                int endIndex = argLength - 1;
                if (args[endIndex] instanceof RpcCallback) {
                    callback = (RpcCallback)args[endIndex];
                    --endIndex;
                    --argLength;
                }
                if (argLength <= 0) {
                    throw new RpcException(0, "invalid params");
                }
                Object[] sendArgs = new Object[argLength];
                int i = 0;
                while (startIndex <= endIndex) {
                    sendArgs[i] = args[startIndex++];
                    ++i;
                }
                request.setArgs(sendArgs);
                request.setCallback(callback);
            } else {
                request.setArgs(args);
            }
            if (RpcContext.isSet()) {
                RpcContext rpcContext = RpcContext.getContext();
                if (rpcContext.getRequestKvAttachment() != null) {
                    request.setKvAttachment(rpcContext.getRequestKvAttachment());
                }
                if (rpcContext.getRequestBinaryAttachment() != null) {
                    request.setBinaryAttachment(rpcContext.getRequestBinaryAttachment());
                }
                if (rpcContext.getLogId() != null) {
                    request.getNsHead().logId = rpcContext.getLogId();
                    request.setLogId(rpcContext.getLogId().intValue());
                }
                if (rpcContext.getServiceTag() != null) {
                    request.setServiceTag(rpcContext.getServiceTag());
                }
                if (rpcContext.getReadTimeoutMillis() != null) {
                    request.setReadTimeoutMillis(rpcContext.getReadTimeoutMillis());
                }
                if (rpcContext.getWriteTimeoutMillis() != null) {
                    request.setWriteTimeoutMillis(rpcContext.getWriteTimeoutMillis());
                }
                rpcContext.reset();
            }
            if (request.getReadTimeoutMillis() == null) {
                request.setReadTimeoutMillis(readTimeout);
            }
            if (request.getWriteTimeoutMillis() == null) {
                request.setWriteTimeoutMillis(writeTimeout);
            }
            DefaultInterceptorChain interceptorChain = new DefaultInterceptorChain(interceptors);
            try {
                interceptorChain.intercept(request, response);
                if (response.getException() != null) {
                    throw new RpcException(response.getException());
                }
                if (request.getCallback() != null) {
                    RpcFuture endIndex = response.getRpcFuture();
                    return endIndex;
                }
                Object endIndex = response.getResult();
                return endIndex;
            }
            catch (Exception ex) {
                log.error("exception :", ex);
                throw new RpcException(response.getException());
            }
        }
        finally {
            if (request != null) {
                request.release();
            }
        }
    }

    public Map<String, RpcMethodInfo> getRpcMethodMap() {
        return this.rpcMethodMap;
    }

    static {
        notProxyMethodSet.add("getClass");
        notProxyMethodSet.add("hashCode");
        notProxyMethodSet.add("equals");
        notProxyMethodSet.add("clone");
        notProxyMethodSet.add("toString");
        notProxyMethodSet.add("notify");
        notProxyMethodSet.add("notifyAll");
        notProxyMethodSet.add("wait");
        notProxyMethodSet.add("finalize");
    }
}

