/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.client;

import com.baidu.brpc.ChannelInfo;
import com.baidu.brpc.client.RpcClient;
import com.baidu.brpc.client.RpcFuture;
import com.baidu.brpc.exceptions.RpcException;
import com.baidu.brpc.protocol.Response;
import com.baidu.brpc.server.RpcServer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcTimeoutTimer
implements TimerTask {
    private static final Logger LOG = LoggerFactory.getLogger(RpcTimeoutTimer.class);
    private ChannelInfo channelInfo;
    private long correlationId;
    private RpcClient rpcClient;
    private RpcServer rpcServer;

    public RpcTimeoutTimer(ChannelInfo channelInfo, long correlationId, RpcClient rpcClient) {
        this.channelInfo = channelInfo;
        this.correlationId = correlationId;
        this.rpcClient = rpcClient;
    }

    public RpcTimeoutTimer(ChannelInfo channelInfo, long correlationId, RpcServer rpcServer) {
        this.channelInfo = channelInfo;
        this.correlationId = correlationId;
        this.rpcServer = rpcServer;
    }

    @Override
    public void run(Timeout timeout) {
        RpcFuture future = this.channelInfo.removeRpcFuture(this.correlationId);
        if (future != null) {
            String ip = future.getChannelInfo().getChannelGroup().getServiceInstance().getIp();
            int port = future.getChannelInfo().getChannelGroup().getServiceInstance().getPort();
            long elapseTime = System.currentTimeMillis() - future.getStartTime();
            String errMsg = String.format("request timeout,correlationId=%d,ip=%s,port=%d,elapse=%dms", this.correlationId, ip, port, elapseTime);
            LOG.info(errMsg);
            Response response = this.rpcClient != null ? this.rpcClient.getProtocol().createResponse() : this.rpcServer.getProtocol().createResponse();
            response.setException(new RpcException(2, errMsg));
            response.setRpcFuture(future);
            future.handleResponse(response);
        }
    }
}

