/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.client.handler;

import com.baidu.brpc.ChannelInfo;
import com.baidu.brpc.client.RpcClient;
import com.baidu.brpc.client.handler.ClientWorkTask;
import com.baidu.brpc.exceptions.BadSchemaException;
import com.baidu.brpc.exceptions.NotEnoughDataException;
import com.baidu.brpc.exceptions.RpcException;
import com.baidu.brpc.exceptions.TooBigDataException;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class RpcClientHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Logger log = LoggerFactory.getLogger(RpcClientHandler.class);
    private RpcClient rpcClient;

    public RpcClientHandler(RpcClient rpcClient) {
        this.rpcClient = rpcClient;
    }

    @Override
    public void channelRead0(ChannelHandlerContext ctx, Object in) throws Exception {
        ChannelInfo channelInfo = ChannelInfo.getClientChannelInfo(ctx.channel());
        ByteBuf msg = (ByteBuf)in;
        int len = msg.readableBytes();
        if (len > 0) {
            channelInfo.getRecvBuf().addBuffer(msg.retain());
        }
        Runnable[] tasks = new ClientWorkTask[64];
        int i = 0;
        while (channelInfo.getRecvBuf().readableBytes() > 0) {
            try {
                Object packet = channelInfo.getProtocol().decode(ctx, channelInfo.getRecvBuf(), false);
                ClientWorkTask task = new ClientWorkTask(this.rpcClient, packet, channelInfo.getProtocol(), ctx);
                tasks[i++] = task;
                if (i != 64) continue;
                this.rpcClient.getWorkThreadPool().submit(tasks, 0, i);
                i = 0;
            }
            catch (NotEnoughDataException ex1) {
                break;
            }
            catch (TooBigDataException ex2) {
                throw new RpcException(5, (Throwable)ex2);
            }
            catch (BadSchemaException ex3) {
                throw new RpcException(5, (Throwable)ex3);
            }
        }
        if (i > 0) {
            this.rpcClient.getWorkThreadPool().submit(tasks, 0, i);
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        final ChannelInfo channelInfo = ChannelInfo.getClientChannelInfo(ctx.channel());
        if (channelInfo == null) {
            log.warn("clientChannelInfo is missing");
            return;
        }
        String ip = channelInfo.getChannelGroup().getServiceInstance().getIp();
        int port = channelInfo.getChannelGroup().getServiceInstance().getPort();
        final String errMsg = String.format("channel is non active, ip=%s,port=%d", ip, port);
        log.debug(errMsg);
        this.rpcClient.triggerCallback(new Runnable(){

            @Override
            public void run() {
                RpcException ex = new RpcException(1, errMsg);
                channelInfo.handleChannelException(ex);
            }
        });
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, final Throwable cause) throws Exception {
        log.info(cause.getMessage());
        final ChannelInfo channelInfo = ChannelInfo.getClientChannelInfo(ctx.channel());
        if (channelInfo != null) {
            this.rpcClient.triggerCallback(new Runnable(){

                @Override
                public void run() {
                    RpcException ex = new RpcException(5, cause);
                    channelInfo.handleChannelException(ex);
                }
            });
        }
    }
}

