/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.client.instance;

import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Endpoint {
    private String ip;
    private int port;

    public Endpoint() {
    }

    public Endpoint(String ip, int port) {
        this.ip = ip;
        this.port = port;
    }

    public Endpoint(String address) {
        Validate.notEmpty(address);
        String[] splits = address.split(":");
        Validate.isTrue(2 == splits.length);
        this.ip = splits[0];
        this.port = Integer.valueOf(splits[1]);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.ip).append(this.port).toHashCode();
    }

    public boolean equals(Object object) {
        boolean flag = false;
        if (object != null && Endpoint.class.isAssignableFrom(object.getClass())) {
            Endpoint rhs = (Endpoint)object;
            flag = new EqualsBuilder().append(this.ip, rhs.ip).append(this.port, rhs.port).isEquals();
        }
        return flag;
    }

    public String toString() {
        return String.format("EndPoint{'%s:%d'}", this.ip, this.port);
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

