/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.client.pool;

import com.baidu.brpc.ChannelInfo;
import com.baidu.brpc.client.channel.BrpcChannel;
import io.netty.channel.Channel;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelPooledObjectFactory
extends BasePooledObjectFactory<Channel> {
    private static final Logger log = LoggerFactory.getLogger(ChannelPooledObjectFactory.class);
    private BrpcChannel channelGroup;
    private String ip;
    private int port;

    public ChannelPooledObjectFactory(BrpcChannel channelGroup, String ip, int port) {
        this.channelGroup = channelGroup;
        this.ip = ip;
        this.port = port;
    }

    @Override
    public Channel create() throws Exception {
        Channel channel = this.channelGroup.connect(this.ip, this.port);
        ChannelInfo channelInfo = ChannelInfo.getOrCreateClientChannelInfo(channel);
        channelInfo.setChannelGroup(this.channelGroup);
        channelInfo.setProtocol(this.channelGroup.getProtocol());
        return channel;
    }

    @Override
    public PooledObject<Channel> wrap(Channel obj) {
        return new DefaultPooledObject<Channel>(obj);
    }

    @Override
    public void destroyObject(PooledObject<Channel> p) throws Exception {
        Channel channel = p.getObject();
        if (channel != null && channel.isOpen() && channel.isActive()) {
            channel.close();
        }
        channel = null;
    }

    @Override
    public boolean validateObject(PooledObject<Channel> p) {
        Channel channel = p.getObject();
        return channel != null && channel.isOpen() && channel.isActive();
    }
}

