/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.naming;

import com.baidu.brpc.client.instance.ServiceInstance;
import com.baidu.brpc.naming.BrpcURL;
import com.baidu.brpc.naming.NamingService;
import com.baidu.brpc.naming.NotifyListener;
import com.baidu.brpc.naming.RegisterInfo;
import com.baidu.brpc.naming.SubscribeInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class ListNamingService
implements NamingService {
    private List<ServiceInstance> instances;

    public ListNamingService(BrpcURL namingUrl) {
        Validate.notNull(namingUrl);
        Validate.notEmpty(namingUrl.getHostPorts());
        String hostPorts = namingUrl.getHostPorts();
        String[] hostPortSplits = hostPorts.split(",");
        this.instances = new ArrayList<ServiceInstance>(hostPortSplits.length);
        for (String hostPort : hostPortSplits) {
            String[] hostPortSplit = hostPort.split(":");
            String host = hostPortSplit[0];
            int port = hostPortSplit.length == 2 ? Integer.valueOf(hostPortSplit[1]) : 80;
            this.instances.add(new ServiceInstance(host, port));
        }
    }

    @Override
    public List<ServiceInstance> lookup(SubscribeInfo subscribeInfo) {
        return this.instances;
    }

    @Override
    public void subscribe(SubscribeInfo subscribeInfo, NotifyListener listener) {
    }

    @Override
    public void unsubscribe(SubscribeInfo subscribeInfo) {
    }

    @Override
    public void register(RegisterInfo registerInfo) {
    }

    @Override
    public void unregister(RegisterInfo registerInfo) {
    }

    @Override
    public void destroy() {
    }
}

