/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.protocol.hulu;

import com.baidu.brpc.ChannelInfo;
import com.baidu.brpc.RpcMethodInfo;
import com.baidu.brpc.buffer.DynamicCompositeByteBuf;
import com.baidu.brpc.client.RpcFuture;
import com.baidu.brpc.compress.Compress;
import com.baidu.brpc.compress.CompressManager;
import com.baidu.brpc.exceptions.BadSchemaException;
import com.baidu.brpc.exceptions.NotEnoughDataException;
import com.baidu.brpc.exceptions.RpcException;
import com.baidu.brpc.exceptions.TooBigDataException;
import com.baidu.brpc.protocol.AbstractProtocol;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import com.baidu.brpc.protocol.RpcResponse;
import com.baidu.brpc.protocol.hulu.HuluRpcDecodePacket;
import com.baidu.brpc.protocol.hulu.HuluRpcEncodePacket;
import com.baidu.brpc.protocol.hulu.HuluRpcProto;
import com.baidu.brpc.server.ServiceManager;
import com.baidu.brpc.utils.ProtobufUtils;
import com.baidu.brpc.utils.RpcMetaUtils;
import com.google.protobuf.Message;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HuluRpcProtocol
extends AbstractProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(HuluRpcProtocol.class);
    private static final byte[] MAGIC_HEAD = "HULU".getBytes();
    private static final int FIXED_LEN = 12;
    private static final HuluRpcProto.HuluRpcRequestMeta defaultRpcRequestMetaInstance = HuluRpcProto.HuluRpcRequestMeta.getDefaultInstance();
    private static final HuluRpcProto.HuluRpcResponseMeta defaultRpcResponseMetaInstance = HuluRpcProto.HuluRpcResponseMeta.getDefaultInstance();
    private static final CompressManager compressManager = CompressManager.getInstance();

    @Override
    public ByteBuf encodeRequest(Request request) throws Exception {
        HuluRpcEncodePacket requestPacket = new HuluRpcEncodePacket();
        HuluRpcProto.HuluRpcRequestMeta.Builder metaBuilder = HuluRpcProto.HuluRpcRequestMeta.newBuilder();
        metaBuilder.setCorrelationId(request.getCorrelationId());
        metaBuilder.setLogId(request.getLogId());
        int compressType = request.getCompressType();
        metaBuilder.setCompressType(compressType);
        RpcMetaUtils.RpcMetaInfo rpcMetaInfo = RpcMetaUtils.parseRpcMeta(request.getTargetMethod());
        metaBuilder.setServiceName(rpcMetaInfo.getServiceName());
        try {
            int methodIndex = Integer.valueOf(rpcMetaInfo.getMethodName());
            metaBuilder.setMethodIndex(methodIndex);
        }
        catch (NumberFormatException ex) {
            String errorMsg = "methodName must be integer when using hulu rpc, it is equal to proto method sequence from 0";
            LOG.warn(errorMsg);
            throw new RpcException(5, errorMsg, ex);
        }
        if (request.getTraceId() != null) {
            metaBuilder.setTraceId(request.getTraceId());
        }
        if (request.getSpanId() != null) {
            metaBuilder.setSpanId(request.getSpanId());
        }
        if (request.getParentSpanId() != null) {
            metaBuilder.setSpanId(request.getParentSpanId());
        }
        if (request.getKvAttachment() != null) {
            for (Map.Entry<String, Object> kv : request.getKvAttachment().entrySet()) {
                metaBuilder.addExtFieldsBuilder().setKey(kv.getKey()).setValue((String)kv.getValue());
            }
        }
        Object proto = request.getArgs()[0];
        Compress compress = compressManager.getCompress(compressType);
        ByteBuf protoBuf = compress.compressInput(proto, request.getRpcMethodInfo());
        requestPacket.setProto(protoBuf);
        if (request.getBinaryAttachment() != null && request.getBinaryAttachment().isReadable()) {
            requestPacket.setAttachment(request.getBinaryAttachment());
            metaBuilder.setUserMessageSize(protoBuf.readableBytes());
        }
        requestPacket.setRequestMeta(metaBuilder.build());
        return this.encode(requestPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response decodeResponse(Object packet, ChannelHandlerContext ctx) throws Exception {
        HuluRpcDecodePacket responsePacket = (HuluRpcDecodePacket)packet;
        ByteBuf metaBuf = responsePacket.getMetaBuf();
        ByteBuf protoAndAttachmentBuf = responsePacket.getProtoAndAttachmentBuf();
        ByteBuf protoBuf = null;
        try {
            RpcResponse rpcResponse = new RpcResponse();
            HuluRpcProto.HuluRpcResponseMeta responseMeta = (HuluRpcProto.HuluRpcResponseMeta)ProtobufUtils.parseFrom(metaBuf, (Message)defaultRpcResponseMetaInstance);
            Long correlationId = responseMeta.getCorrelationId();
            rpcResponse.setCorrelationId(correlationId);
            ChannelInfo channelInfo = ChannelInfo.getClientChannelInfo(ctx.channel());
            RpcFuture future = channelInfo.removeRpcFuture(rpcResponse.getCorrelationId());
            if (future == null) {
                RpcResponse rpcResponse2 = rpcResponse;
                return rpcResponse2;
            }
            rpcResponse.setRpcFuture(future);
            int compressType = responseMeta.getCompressType();
            rpcResponse.setCompressType(compressType);
            try {
                if (responseMeta != null && responseMeta.getErrorCode() == 0) {
                    Compress compress = compressManager.getCompress(compressType);
                    protoBuf = responseMeta.getUserMessageSize() > 0 ? protoAndAttachmentBuf.slice(protoAndAttachmentBuf.readerIndex(), responseMeta.getUserMessageSize()) : protoAndAttachmentBuf;
                    Object responseProto = compress.uncompressOutput(protoBuf, future.getRpcMethodInfo());
                    rpcResponse.setResult(responseProto);
                    if (responseMeta.getUserMessageSize() > 0) {
                        rpcResponse.setBinaryAttachment(protoAndAttachmentBuf);
                        responsePacket.setProtoAndAttachmentBuf(null);
                    }
                } else {
                    rpcResponse.setException(new RpcException(3, responseMeta.getErrorText()));
                }
            }
            catch (Exception ex) {
                throw new RpcException(5, "decode response failed", ex);
            }
            RpcResponse rpcResponse3 = rpcResponse;
            return rpcResponse3;
        }
        finally {
            if (responsePacket.getMetaBuf() != null) {
                responsePacket.getMetaBuf().release();
            }
            if (responsePacket.getProtoAndAttachmentBuf() != null) {
                responsePacket.getProtoAndAttachmentBuf().release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Request decodeRequest(Object packet) throws Exception {
        Request request = this.createRequest();
        HuluRpcDecodePacket requestPacket = (HuluRpcDecodePacket)packet;
        ByteBuf metaBuf = requestPacket.getMetaBuf();
        ByteBuf protoAndAttachmentBuf = requestPacket.getProtoAndAttachmentBuf();
        ByteBuf protoBuf = null;
        try {
            HuluRpcProto.HuluRpcRequestMeta requestMeta = (HuluRpcProto.HuluRpcRequestMeta)ProtobufUtils.parseFrom(metaBuf, (Message)defaultRpcRequestMetaInstance);
            request.setCorrelationId(requestMeta.getCorrelationId());
            request.setLogId(requestMeta.getLogId());
            int compressType = requestMeta.getCompressType();
            request.setCompressType(compressType);
            ServiceManager serviceManager = ServiceManager.getInstance();
            RpcMethodInfo rpcMethodInfo = serviceManager.getService(requestMeta.getServiceName(), String.valueOf(requestMeta.getMethodIndex()));
            if (rpcMethodInfo == null) {
                String errorMsg = String.format("Fail to find service=%s, methodIndex=%s", requestMeta.getServiceName(), requestMeta.getMethodIndex());
                request.setException(new RpcException(3, errorMsg));
                Request request2 = request;
                return request2;
            }
            if (requestMeta.hasTraceId()) {
                request.setTraceId(requestMeta.getTraceId());
            }
            if (requestMeta.hasSpanId()) {
                request.setSpanId(request.getSpanId());
            }
            if (requestMeta.hasParentSpanId()) {
                request.setParentSpanId(requestMeta.getParentSpanId());
            }
            if (requestMeta.getExtFieldsCount() > 0) {
                if (request.getKvAttachment() == null) {
                    request.setKvAttachment(new HashMap<String, Object>());
                }
                for (HuluRpcProto.HuluRpcRequestMetaExtField extField : requestMeta.getExtFieldsList()) {
                    request.getKvAttachment().put(extField.getKey(), extField.getValue());
                }
            }
            request.setServiceName(rpcMethodInfo.getServiceName());
            request.setMethodName(rpcMethodInfo.getMethodName());
            request.setRpcMethodInfo(rpcMethodInfo);
            request.setTargetMethod(rpcMethodInfo.getMethod());
            request.setTarget(rpcMethodInfo.getTarget());
            try {
                Compress compress = compressManager.getCompress(compressType);
                int userMessageSize = requestMeta.getUserMessageSize();
                protoBuf = userMessageSize > 0 ? protoAndAttachmentBuf.slice(protoAndAttachmentBuf.readerIndex(), userMessageSize) : protoAndAttachmentBuf;
                Object requestProto = compress.uncompressInput(protoBuf, rpcMethodInfo);
                request.setArgs(new Object[]{requestProto});
                if (userMessageSize > 0) {
                    request.setBinaryAttachment(protoAndAttachmentBuf);
                    protoAndAttachmentBuf = null;
                }
            }
            catch (Exception ex) {
                String errorMsg = String.format("decode failed, msg=%s", ex.getMessage());
                LOG.error(errorMsg);
                throw new RpcException(5, errorMsg, ex);
            }
            Request request3 = request;
            return request3;
        }
        finally {
            if (metaBuf != null) {
                metaBuf.release();
            }
            if (protoAndAttachmentBuf != null) {
                protoAndAttachmentBuf.release();
            }
        }
    }

    @Override
    public ByteBuf encodeResponse(Request request, Response response) throws Exception {
        HuluRpcEncodePacket responsePacket = new HuluRpcEncodePacket();
        HuluRpcProto.HuluRpcResponseMeta.Builder metaBuilder = HuluRpcProto.HuluRpcResponseMeta.newBuilder();
        metaBuilder.setCorrelationId(response.getCorrelationId());
        int compressType = response.getCompressType();
        metaBuilder.setCompressType(compressType);
        if (response.getException() != null) {
            metaBuilder.setErrorCode(2001);
            if (StringUtils.isNotBlank(response.getException().getMessage())) {
                metaBuilder.setErrorText(response.getException().getMessage());
            }
            responsePacket.setResponseMeta(metaBuilder.build());
        } else {
            metaBuilder.setErrorCode(0);
            Compress compress = compressManager.getCompress(compressType);
            ByteBuf responseProtoBuf = compress.compressOutput(response.getResult(), response.getRpcMethodInfo());
            responsePacket.setProto(responseProtoBuf);
            if (response.getBinaryAttachment() != null) {
                responsePacket.setAttachment(response.getBinaryAttachment());
                metaBuilder.setUserMessageSize(responseProtoBuf.readableBytes());
            }
            responsePacket.setResponseMeta(metaBuilder.build());
        }
        return this.encode(responsePacket);
    }

    protected ByteBuf encode(HuluRpcEncodePacket packet) throws IOException {
        ByteBuf attachmentBuf;
        ByteBuf metaBuf;
        int metaSize;
        byte[] metaBytes;
        HuluRpcProto.HuluRpcRequestMeta requestMeta = packet.getRequestMeta();
        if (requestMeta != null) {
            metaBytes = requestMeta.toByteArray();
            metaSize = metaBytes.length;
            metaBuf = Unpooled.wrappedBuffer(metaBytes);
        } else {
            metaBytes = packet.getResponseMeta().toByteArray();
            metaSize = metaBytes.length;
            metaBuf = Unpooled.wrappedBuffer(metaBytes);
        }
        ByteBuf headerBuf = Unpooled.buffer(12);
        headerBuf.writeBytes(MAGIC_HEAD);
        int bodySize = metaSize;
        ByteBuf protoBuf = packet.getProto();
        if (protoBuf != null) {
            bodySize += protoBuf.readableBytes();
        }
        if ((attachmentBuf = packet.getAttachment()) != null) {
            bodySize += attachmentBuf.readableBytes();
        }
        headerBuf.writeIntLE(bodySize);
        headerBuf.writeIntLE(metaSize);
        if (protoBuf != null && attachmentBuf != null) {
            return Unpooled.wrappedBuffer(headerBuf, metaBuf, protoBuf, attachmentBuf);
        }
        if (protoBuf != null) {
            return Unpooled.wrappedBuffer(headerBuf, metaBuf, protoBuf);
        }
        return Unpooled.wrappedBuffer(headerBuf, metaBuf);
    }

    @Override
    public HuluRpcDecodePacket decode(ChannelHandlerContext ctx, DynamicCompositeByteBuf in, boolean isDecodingRequest) throws BadSchemaException, TooBigDataException, NotEnoughDataException {
        if (in.readableBytes() < 12) {
            throw notEnoughDataException;
        }
        ByteBuf fixHeaderBuf = in.retainedSlice(12);
        try {
            byte[] magic = new byte[4];
            fixHeaderBuf.readBytes(magic);
            if (!Arrays.equals(magic, MAGIC_HEAD)) {
                throw new BadSchemaException("not valid magic head for hulu");
            }
            int bodySize = fixHeaderBuf.readIntLE();
            int metaSize = fixHeaderBuf.readIntLE();
            if (bodySize > 0x20000000) {
                throw new TooBigDataException("to big body size:" + bodySize);
            }
            if (in.readableBytes() < 12 + bodySize) {
                throw notEnoughDataException;
            }
            in.skipBytes(12);
            HuluRpcDecodePacket packet = new HuluRpcDecodePacket();
            try {
                ByteBuf metaBuf = in.readRetainedSlice(metaSize);
                packet.setMetaBuf(metaBuf);
                ByteBuf protoAndAttachmentBuf = in.readRetainedSlice(bodySize - metaSize);
                packet.setProtoAndAttachmentBuf(protoAndAttachmentBuf);
                HuluRpcDecodePacket huluRpcDecodePacket = packet;
                return huluRpcDecodePacket;
            }
            catch (Exception ex) {
                LOG.warn("decode failed, ex={}", (Object)ex.getMessage());
                throw new RpcException(5, (Throwable)ex);
            }
        }
        finally {
            fixHeaderBuf.release();
        }
    }

    @Override
    public boolean isCoexistence() {
        return true;
    }
}

