/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.protocol.sofa;

import com.baidu.brpc.ChannelInfo;
import com.baidu.brpc.RpcMethodInfo;
import com.baidu.brpc.buffer.DynamicCompositeByteBuf;
import com.baidu.brpc.client.RpcFuture;
import com.baidu.brpc.compress.Compress;
import com.baidu.brpc.compress.CompressManager;
import com.baidu.brpc.exceptions.BadSchemaException;
import com.baidu.brpc.exceptions.NotEnoughDataException;
import com.baidu.brpc.exceptions.RpcException;
import com.baidu.brpc.exceptions.TooBigDataException;
import com.baidu.brpc.protocol.AbstractProtocol;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import com.baidu.brpc.protocol.RpcResponse;
import com.baidu.brpc.protocol.sofa.SofaRpcDecodePacket;
import com.baidu.brpc.protocol.sofa.SofaRpcEncodePacket;
import com.baidu.brpc.protocol.sofa.SofaRpcProto;
import com.baidu.brpc.server.ServiceManager;
import com.baidu.brpc.utils.ProtobufUtils;
import com.baidu.brpc.utils.RpcMetaUtils;
import com.google.protobuf.Message;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SofaRpcProtocol
extends AbstractProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(SofaRpcProtocol.class);
    private static final byte[] MAGIC_HEAD = "SOFA".getBytes();
    private static final int FIXED_LEN = 24;
    private static final SofaRpcProto.SofaRpcMeta defaultRpcMetaInstance = SofaRpcProto.SofaRpcMeta.getDefaultInstance();
    private static final CompressManager compressManager = CompressManager.getInstance();

    @Override
    public SofaRpcDecodePacket decode(ChannelHandlerContext ctx, DynamicCompositeByteBuf in, boolean isDecodingRequest) throws BadSchemaException, TooBigDataException, NotEnoughDataException {
        if (in.readableBytes() < 24) {
            throw notEnoughDataException;
        }
        ByteBuf fixHeaderBuf = in.retainedSlice(24);
        try {
            byte[] magic = new byte[4];
            fixHeaderBuf.readBytes(magic);
            if (!Arrays.equals(magic, MAGIC_HEAD)) {
                throw new BadSchemaException("not valid magic head for sofa");
            }
            int metaSize = fixHeaderBuf.readIntLE();
            int bodySize = (int)fixHeaderBuf.readLongLE();
            int msgSize = (int)fixHeaderBuf.readLongLE();
            if (msgSize != metaSize + bodySize) {
                throw new BadSchemaException("msgSize != metaSize + bodySize");
            }
            if (in.readableBytes() < 24 + msgSize) {
                throw notEnoughDataException;
            }
            if (bodySize > 0x20000000) {
                throw new TooBigDataException("to big body size:" + bodySize);
            }
            in.skipBytes(24);
            SofaRpcDecodePacket packet = new SofaRpcDecodePacket();
            try {
                ByteBuf metaBuf = in.readRetainedSlice(metaSize);
                packet.setMetaBuf(metaBuf);
                ByteBuf protoBuf = in.readRetainedSlice(bodySize);
                packet.setProtoBuf(protoBuf);
                SofaRpcDecodePacket sofaRpcDecodePacket = packet;
                return sofaRpcDecodePacket;
            }
            catch (Exception ex) {
                LOG.debug("decode failed, ex={}", (Object)ex.getMessage());
                throw new RpcException(5, (Throwable)ex);
            }
        }
        finally {
            fixHeaderBuf.release();
        }
    }

    @Override
    public ByteBuf encodeRequest(Request request) throws Exception {
        SofaRpcEncodePacket requestPacket = new SofaRpcEncodePacket();
        SofaRpcProto.SofaRpcMeta.Builder metaBuilder = SofaRpcProto.SofaRpcMeta.newBuilder();
        metaBuilder.setType(SofaRpcProto.SofaRpcMeta.Type.REQUEST);
        metaBuilder.setSequenceId(request.getCorrelationId());
        int compressType = request.getCompressType();
        metaBuilder.setCompressType(this.getSofaCompressType(compressType));
        RpcMetaUtils.RpcMetaInfo rpcMetaInfo = RpcMetaUtils.parseRpcMeta(request.getTargetMethod());
        metaBuilder.setMethod(rpcMetaInfo.getServiceName() + "." + rpcMetaInfo.getMethodName());
        requestPacket.setRpcMeta(metaBuilder.build());
        Object proto = request.getArgs()[0];
        Compress compress = compressManager.getCompress(compressType);
        ByteBuf protoBuf = compress.compressInput(proto, request.getRpcMethodInfo());
        requestPacket.setProto(protoBuf);
        return this.encode(requestPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RpcResponse decodeResponse(Object packet, ChannelHandlerContext ctx) throws Exception {
        SofaRpcDecodePacket responsePacket = (SofaRpcDecodePacket)packet;
        ByteBuf metaBuf = responsePacket.getMetaBuf();
        ByteBuf protoBuf = responsePacket.getProtoBuf();
        try {
            RpcResponse rpcResponse = new RpcResponse();
            SofaRpcProto.SofaRpcMeta responseMeta = (SofaRpcProto.SofaRpcMeta)ProtobufUtils.parseFrom(metaBuf, (Message)defaultRpcMetaInstance);
            Long correlationId = responseMeta.getSequenceId();
            rpcResponse.setCorrelationId(correlationId);
            ChannelInfo channelInfo = ChannelInfo.getClientChannelInfo(ctx.channel());
            RpcFuture future = channelInfo.removeRpcFuture(rpcResponse.getCorrelationId());
            if (future == null) {
                RpcResponse rpcResponse2 = rpcResponse;
                return rpcResponse2;
            }
            rpcResponse.setRpcFuture(future);
            int compressType = this.getStandardCompressType(responseMeta.getCompressType());
            rpcResponse.setCompressType(compressType);
            try {
                if (responseMeta != null && responseMeta.getErrorCode() == 0) {
                    Compress compress = compressManager.getCompress(compressType);
                    Object result = compress.uncompressOutput(protoBuf, future.getRpcMethodInfo());
                    rpcResponse.setResult(result);
                } else {
                    rpcResponse.setException(new RpcException(3, responseMeta.getReason()));
                }
            }
            catch (Exception ex) {
                LOG.warn("decode response failed");
                throw new RpcException(5, "decode response failed", ex);
            }
            RpcResponse rpcResponse3 = rpcResponse;
            return rpcResponse3;
        }
        finally {
            if (metaBuf != null) {
                metaBuf.release();
            }
            if (protoBuf != null) {
                protoBuf.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Request decodeRequest(Object packet) throws Exception {
        Request request = this.createRequest();
        SofaRpcDecodePacket requestPacket = (SofaRpcDecodePacket)packet;
        ByteBuf metaBuf = requestPacket.getMetaBuf();
        ByteBuf protoBuf = requestPacket.getProtoBuf();
        try {
            SofaRpcProto.SofaRpcMeta requestMeta = (SofaRpcProto.SofaRpcMeta)ProtobufUtils.parseFrom(metaBuf, (Message)defaultRpcMetaInstance);
            request.setCorrelationId(requestMeta.getSequenceId());
            if (StringUtils.isBlank(requestMeta.getMethod())) {
                String errorMsg = "method is null";
                LOG.error(errorMsg);
                request.setException(new RpcException(3, errorMsg));
                Request request2 = request;
                return request2;
            }
            ServiceManager serviceManager = ServiceManager.getInstance();
            RpcMethodInfo rpcMethodInfo = serviceManager.getService(requestMeta.getMethod().toLowerCase());
            if (rpcMethodInfo == null) {
                String errorMsg = String.format("Fail to find method=%s", requestMeta.getMethod());
                LOG.error(errorMsg);
                request.setException(new RpcException(3, errorMsg));
                Request request3 = request;
                return request3;
            }
            request.setServiceName(rpcMethodInfo.getServiceName());
            request.setMethodName(rpcMethodInfo.getMethodName());
            request.setRpcMethodInfo(rpcMethodInfo);
            request.setTargetMethod(rpcMethodInfo.getMethod());
            request.setTarget(rpcMethodInfo.getTarget());
            int compressType = this.getStandardCompressType(requestMeta.getCompressType());
            request.setCompressType(compressType);
            Compress compress = compressManager.getCompress(compressType);
            try {
                Object requestProto = compress.uncompressInput(protoBuf, rpcMethodInfo);
                request.setArgs(new Object[]{requestProto});
            }
            catch (Exception ex) {
                String errorMsg = String.format("decode request failed, msg=%s", ex.getMessage());
                LOG.error(errorMsg);
                throw new RpcException(5, errorMsg);
            }
            Request request4 = request;
            return request4;
        }
        finally {
            if (metaBuf != null) {
                metaBuf.release();
            }
            if (protoBuf != null) {
                protoBuf.release();
            }
        }
    }

    @Override
    public ByteBuf encodeResponse(Request request, Response response) throws Exception {
        SofaRpcEncodePacket responsePacket = new SofaRpcEncodePacket();
        SofaRpcProto.SofaRpcMeta.Builder metaBuilder = SofaRpcProto.SofaRpcMeta.newBuilder();
        metaBuilder.setType(SofaRpcProto.SofaRpcMeta.Type.RESPONSE);
        metaBuilder.setSequenceId(response.getCorrelationId());
        int compressType = response.getCompressType();
        metaBuilder.setCompressType(this.getSofaCompressType(compressType));
        if (response.getException() != null) {
            metaBuilder.setErrorCode(2002);
            metaBuilder.setReason(response.getException().getMessage());
            responsePacket.setRpcMeta(metaBuilder.build());
        } else {
            Object responseBodyMessage = response.getResult();
            Compress compress = compressManager.getCompress(compressType);
            ByteBuf responseProtoBuf = compress.compressOutput(responseBodyMessage, response.getRpcMethodInfo());
            responsePacket.setProto(responseProtoBuf);
            metaBuilder.setErrorCode(0);
            responsePacket.setRpcMeta(metaBuilder.build());
        }
        return this.encode(responsePacket);
    }

    @Override
    public boolean isCoexistence() {
        return true;
    }

    protected ByteBuf encode(SofaRpcEncodePacket packet) throws Exception {
        byte[] metaBytes = packet.getRpcMeta().toByteArray();
        ByteBuf metaBuf = Unpooled.wrappedBuffer(metaBytes);
        int metaSize = metaBytes.length;
        ByteBuf headerBuf = Unpooled.buffer(24);
        headerBuf.writeBytes(MAGIC_HEAD);
        headerBuf.writeIntLE(metaSize);
        ByteBuf protoBuf = packet.getProto();
        if (protoBuf != null) {
            int protoSize = protoBuf.readableBytes();
            headerBuf.writeLongLE(protoSize);
            headerBuf.writeLongLE(metaSize + protoSize);
            return Unpooled.wrappedBuffer(headerBuf, metaBuf, protoBuf);
        }
        headerBuf.writeLongLE(0L);
        headerBuf.writeLongLE(metaSize);
        return Unpooled.wrappedBuffer(headerBuf, metaBuf);
    }

    protected SofaRpcProto.SofaCompressType getSofaCompressType(int compressType) {
        SofaRpcProto.SofaCompressType sofaCompressType;
        switch (compressType) {
            case 0: {
                sofaCompressType = SofaRpcProto.SofaCompressType.SOFA_COMPRESS_TYPE_NONE;
                break;
            }
            case 1: {
                sofaCompressType = SofaRpcProto.SofaCompressType.SOFA_COMPRESS_TYPE_SNAPPY;
                break;
            }
            case 2: {
                sofaCompressType = SofaRpcProto.SofaCompressType.SOFA_COMPRESS_TYPE_GZIP;
                break;
            }
            case 3: {
                sofaCompressType = SofaRpcProto.SofaCompressType.SOFA_COMPRESS_TYPE_ZLIB;
                break;
            }
            case 4: {
                sofaCompressType = SofaRpcProto.SofaCompressType.SOFA_COMPRESS_TYPE_LZ4;
                break;
            }
            default: {
                throw new RpcException(5, "not support compress type");
            }
        }
        return sofaCompressType;
    }

    protected int getStandardCompressType(SofaRpcProto.SofaCompressType sofaCompressType) {
        int standardCompressType;
        switch (sofaCompressType.getNumber()) {
            case 0: {
                standardCompressType = 0;
                break;
            }
            case 3: {
                standardCompressType = 1;
                break;
            }
            case 1: {
                standardCompressType = 2;
                break;
            }
            case 2: {
                standardCompressType = 3;
                break;
            }
            case 4: {
                standardCompressType = 4;
                break;
            }
            default: {
                throw new RpcException(5, "not support compress type");
            }
        }
        return standardCompressType;
    }
}

