/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.server;

import com.baidu.brpc.JprotobufRpcMethodInfo;
import com.baidu.brpc.ProtobufRpcMethodInfo;
import com.baidu.brpc.RpcMethodInfo;
import com.baidu.brpc.utils.ProtobufUtils;
import com.baidu.brpc.utils.ThreadPool;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceManager {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceManager.class);
    private static volatile ServiceManager instance;
    private Map<String, RpcMethodInfo> serviceMap = new HashMap<String, RpcMethodInfo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServiceManager getInstance() {
        if (instance != null) return instance;
        Class<ServiceManager> clazz = ServiceManager.class;
        synchronized (ServiceManager.class) {
            if (instance != null) return instance;
            instance = new ServiceManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ServiceManager() {
    }

    public void registerService(Object service, ThreadPool threadPool) {
        Class<?>[] interfaces = service.getClass().getInterfaces();
        if (interfaces.length != 1) {
            LOG.error("service must implement one interface only");
            throw new RuntimeException("service must implement one interface only");
        }
        Class<?> clazz = interfaces[0];
        Method[] methods = clazz.getDeclaredMethods();
        this.registerService(methods, service, threadPool);
    }

    public void registerService(Class targetClass, Object service, ThreadPool threadPool) {
        Class<?>[] interfaces = targetClass.getInterfaces();
        if (interfaces.length != 1) {
            LOG.error("service must implement one interface only");
            throw new RuntimeException("service must implement one interface only");
        }
        Class<?> clazz = interfaces[0];
        Method[] methods = clazz.getDeclaredMethods();
        this.registerService(methods, service, threadPool);
    }

    public void registerPushService(Object service) {
        this.registerService(service);
    }

    public void registerService(Object service) {
        Class<?>[] interfaces = service.getClass().getInterfaces();
        if (interfaces.length != 1) {
            LOG.error("service must implement one interface only");
            throw new RuntimeException("service must implement one interface only");
        }
        Class<?> clazz = interfaces[0];
        Method[] methods = clazz.getDeclaredMethods();
        ServiceManager serviceManager = ServiceManager.getInstance();
        for (Method method : methods) {
            RpcMethodInfo serviceInfo = new RpcMethodInfo(method);
            String serviceName = method.getDeclaringClass().getName();
            String methodName = method.getName();
            serviceInfo.setServiceName(serviceName);
            serviceInfo.setMethodName(methodName);
            serviceInfo.setTarget(service);
            serviceInfo.setMethod(method);
            serviceManager.registerService(serviceInfo);
            LOG.info("register service, serviceName={}, methodName={}", (Object)serviceInfo.getServiceName(), (Object)serviceInfo.getMethodName());
        }
    }

    protected void registerService(Method[] methods, Object service, ThreadPool threadPool) {
        for (Method method : methods) {
            ProtobufUtils.MessageType messageType = ProtobufUtils.getMessageType(method);
            RpcMethodInfo methodInfo = messageType == ProtobufUtils.MessageType.PROTOBUF ? new ProtobufRpcMethodInfo(method) : (messageType == ProtobufUtils.MessageType.JPROTOBUF ? new JprotobufRpcMethodInfo(method) : new RpcMethodInfo(method));
            methodInfo.setTarget(service);
            methodInfo.setThreadPool(threadPool);
            this.registerService(methodInfo);
            LOG.info("register service, serviceName={}, methodName={}", (Object)methodInfo.getServiceName(), (Object)methodInfo.getMethodName());
        }
    }

    protected void registerService(RpcMethodInfo methodInfo) {
        String key = this.buildServiceKey(methodInfo.getServiceName(), methodInfo.getMethodName());
        this.serviceMap.put(key, methodInfo);
    }

    public RpcMethodInfo getService(String serviceName, String methodName) {
        String key = this.buildServiceKey(serviceName, methodName);
        return this.serviceMap.get(key);
    }

    public RpcMethodInfo getService(String serviceMethodName) {
        return this.serviceMap.get(serviceMethodName);
    }

    public Map<String, RpcMethodInfo> getServiceMap() {
        return this.serviceMap;
    }

    private String buildServiceKey(String serviceName, String methodName) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(serviceName.toLowerCase()).append(".").append(methodName.toLowerCase());
        return stringBuilder.toString();
    }
}

