/*
 * Decompiled with CFR 0.152.
 */
package javassist;

import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import javassist.ClassPath;
import javassist.ModuleClassPath;
import javassist.NotFoundException;
import javassist.bytecode.ClassFile;

public class LoaderClassPath
implements ClassPath {
    private WeakReference clref;
    public static boolean fallbackOnModuleClassPath = ClassFile.MAJOR_VERSION >= 53;
    private static ModuleClassPath moduleClassPath = null;
    private boolean doFallback;

    public LoaderClassPath(ClassLoader cl) {
        this(cl, fallbackOnModuleClassPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    LoaderClassPath(ClassLoader cl, boolean fallback) {
        this.clref = new WeakReference<ClassLoader>(cl);
        this.doFallback = fallback;
        if (!fallback) return;
        Class<LoaderClassPath> clazz = LoaderClassPath.class;
        synchronized (LoaderClassPath.class) {
            if (moduleClassPath != null) return;
            moduleClassPath = new ModuleClassPath();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public String toString() {
        Object cl = null;
        if (this.clref != null) {
            cl = this.clref.get();
        }
        return cl == null ? "<null>" : cl.toString();
    }

    @Override
    public InputStream openClassfile(String classname) throws NotFoundException {
        String cname = classname.replace('.', '/') + ".class";
        ClassLoader cl = (ClassLoader)this.clref.get();
        if (cl == null) {
            return null;
        }
        InputStream is = cl.getResourceAsStream(cname);
        if (is == null && this.doFallback) {
            return moduleClassPath.openClassfile(classname);
        }
        return is;
    }

    @Override
    public URL find(String classname) {
        String cname = classname.replace('.', '/') + ".class";
        ClassLoader cl = (ClassLoader)this.clref.get();
        if (cl == null) {
            return null;
        }
        URL url = cl.getResource(cname);
        if (url == null && this.doFallback) {
            return moduleClassPath.find(classname);
        }
        return url;
    }

    @Override
    public void close() {
        this.clref = null;
    }
}

