/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.compiler;

import com.apollographql.apollo.api.OperationName;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ScalarTypeAdapters;
import com.apollographql.apollo.api.internal.OperationRequestBodyComposer;
import com.apollographql.apollo.api.internal.QueryDocumentMinifier;
import com.apollographql.apollo.api.internal.ResponseFieldMapper;
import com.apollographql.apollo.api.internal.SimpleOperationResponseParser;
import com.apollographql.apollo.compiler.Annotations;
import com.apollographql.apollo.compiler.BuilderTypeSpecBuilder;
import com.apollographql.apollo.compiler.ClassNames;
import com.apollographql.apollo.compiler.JavaTypeResolver;
import com.apollographql.apollo.compiler.NullableValueType;
import com.apollographql.apollo.compiler.SchemaTypeSpecBuilder;
import com.apollographql.apollo.compiler.TestUtilsKt;
import com.apollographql.apollo.compiler.VariablesTypeSpecBuilder;
import com.apollographql.apollo.compiler.codegen.kotlin.OkioJavaTypeName;
import com.apollographql.apollo.compiler.ir.CodeGenerationContext;
import com.apollographql.apollo.compiler.ir.CodeGenerator;
import com.apollographql.apollo.compiler.ir.Fragment;
import com.apollographql.apollo.compiler.ir.Operation;
import com.apollographql.apollo.compiler.ir.Variable;
import com.apollographql.apollo.compiler.operationoutput.OperationOutputKt;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 /2\u00020\u0001:\u0001/B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\b\u0010\u0016\u001a\u00020\u0014H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\bH\u0016J\u0010\u0010\"\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bH\u0002J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010$\u001a\n \f*\u0004\u0018\u00010\u00180\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0014\u0010%\u001a\u00020&*\u00020&2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0014\u0010'\u001a\u00020&*\u00020&2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001c\u0010(\u001a\u00020&*\u00020&2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\f\u0010)\u001a\u00020&*\u00020&H\u0002J\f\u0010*\u001a\u00020&*\u00020&H\u0002J\f\u0010+\u001a\u00020&*\u00020&H\u0002J\"\u0010,\u001a\u00020&*\u00020&2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/apollographql/apollo/compiler/OperationTypeSpecBuilder;", "Lcom/apollographql/apollo/compiler/ir/CodeGenerator;", "operation", "Lcom/apollographql/apollo/compiler/ir/Operation;", "fragments", "", "Lcom/apollographql/apollo/compiler/ir/Fragment;", "useSemanticNaming", "", "(Lcom/apollographql/apollo/compiler/ir/Operation;Ljava/util/List;Z)V", "dataVarType", "Lcom/squareup/javapoet/ClassName;", "kotlin.jvm.PlatformType", "getFragments", "()Ljava/util/List;", "getOperation", "()Lcom/apollographql/apollo/compiler/ir/Operation;", "operationTypeName", "", "composeRequestBody", "Lcom/squareup/javapoet/MethodSpec;", "composeRequestBodyForQuery", "composeRequestBodyWithDefaultScalarTypeAdapters", "operationSuperInterface", "Lcom/squareup/javapoet/TypeName;", "context", "Lcom/apollographql/apollo/compiler/ir/CodeGenerationContext;", "parseByteStringMethod", "parseByteStringMethodWithDefaultScalarTypeAdapters", "parseMethod", "parseMethodWithDefaultScalarTypeAdapters", "toTypeSpec", "Lcom/squareup/javapoet/TypeSpec;", "abstract", "variablesType", "wrapDataMethod", "wrapperType", "addBuilder", "Lcom/squareup/javapoet/TypeSpec$Builder;", "addConstructor", "addOperationId", "addOperationName", "addQueryDocumentDefinition", "addResponseFieldMapperMethod", "addVariablesDefinition", "variables", "Lcom/apollographql/apollo/compiler/ir/Variable;", "Companion", "apollo-compiler"})
public final class OperationTypeSpecBuilder
implements CodeGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Operation operation;
    @NotNull
    private final List<Fragment> fragments;
    @NotNull
    private final String operationTypeName;
    private final ClassName dataVarType;
    @NotNull
    private static final String QUERY_DOCUMENT_FIELD_NAME = "QUERY_DOCUMENT";
    @NotNull
    private static final String OPERATION_ID_FIELD_NAME = "OPERATION_ID";
    @NotNull
    private static final String QUERY_DOCUMENT_ACCESSOR_NAME = "queryDocument";
    @NotNull
    private static final String OPERATION_ID_ACCESSOR_NAME = "operationId";
    @NotNull
    private static final String VARIABLES_VAR = "variables";

    public OperationTypeSpecBuilder(@NotNull Operation operation, @NotNull List<Fragment> fragments, boolean useSemanticNaming) {
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        Intrinsics.checkParameterIsNotNull(fragments, (String)"fragments");
        this.operation = operation;
        this.fragments = fragments;
        this.operationTypeName = this.operation.normalizedOperationName(useSemanticNaming);
        this.dataVarType = ClassName.get((String)"", (String)Intrinsics.stringPlus((String)this.operationTypeName, (Object)".Data"), (String[])new String[0]);
    }

    @NotNull
    public final Operation getOperation() {
        return this.operation;
    }

    @NotNull
    public final List<Fragment> getFragments() {
        return this.fragments;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public TypeSpec toTypeSpec(@NotNull CodeGenerationContext context, boolean bl) {
        void v7;
        void $this$applyIf$iv;
        void condition$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        CodeGenerationContext newContext = CodeGenerationContext.copy$default(context, CollectionsKt.plus((Collection)context.getReservedTypeNames(), (Object)this.operationTypeName), null, null, null, null, null, false, false, false, false, false, 2046, null);
        OperationTypeSpecBuilder operationTypeSpecBuilder = this;
        OperationTypeSpecBuilder operationTypeSpecBuilder2 = this;
        OperationTypeSpecBuilder operationTypeSpecBuilder3 = this;
        OperationTypeSpecBuilder operationTypeSpecBuilder4 = this;
        OperationTypeSpecBuilder operationTypeSpecBuilder5 = this;
        OperationTypeSpecBuilder operationTypeSpecBuilder6 = this;
        OperationTypeSpecBuilder operationTypeSpecBuilder7 = this;
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC, Modifier.FINAL};
        modifierArray = TypeSpec.classBuilder((String)this.operationTypeName).addModifiers(modifierArray).addSuperinterface(this.operationSuperInterface(context));
        CharSequence charSequence = this.operation.getDescription();
        boolean bl2 = false;
        boolean bl3 = !StringsKt.isBlank((CharSequence)charSequence);
        boolean $i$f$applyIf = false;
        if (condition$iv != false) {
            void $this$toTypeSpec_u24lambda_u2d0;
            void var11_8 = $this$applyIf$iv;
            boolean bl4 = false;
            boolean bl5 = false;
            void var14_11 = var11_8;
            OperationTypeSpecBuilder operationTypeSpecBuilder8 = operationTypeSpecBuilder7;
            OperationTypeSpecBuilder operationTypeSpecBuilder9 = operationTypeSpecBuilder6;
            OperationTypeSpecBuilder operationTypeSpecBuilder10 = operationTypeSpecBuilder5;
            OperationTypeSpecBuilder operationTypeSpecBuilder11 = operationTypeSpecBuilder4;
            OperationTypeSpecBuilder operationTypeSpecBuilder12 = operationTypeSpecBuilder3;
            OperationTypeSpecBuilder operationTypeSpecBuilder13 = operationTypeSpecBuilder2;
            OperationTypeSpecBuilder operationTypeSpecBuilder14 = operationTypeSpecBuilder;
            boolean bl6 = false;
            Object[] objectArray = new Object[]{this.getOperation().getDescription()};
            $this$toTypeSpec_u24lambda_u2d0.addJavadoc("$L\n", objectArray);
            Unit unit = Unit.INSTANCE;
            operationTypeSpecBuilder = operationTypeSpecBuilder14;
            operationTypeSpecBuilder2 = operationTypeSpecBuilder13;
            operationTypeSpecBuilder3 = operationTypeSpecBuilder12;
            operationTypeSpecBuilder4 = operationTypeSpecBuilder11;
            operationTypeSpecBuilder5 = operationTypeSpecBuilder10;
            operationTypeSpecBuilder6 = operationTypeSpecBuilder9;
            operationTypeSpecBuilder7 = operationTypeSpecBuilder8;
            v7 = var11_8;
        } else {
            v7 = $this$applyIf$iv;
        }
        void var7_22 = v7;
        Intrinsics.checkExpressionValueIsNotNull((Object)var7_22, (String)"classBuilder(operationTy\u2026 operation.description) }");
        TypeSpec.Builder builder = operationTypeSpecBuilder5.addConstructor(operationTypeSpecBuilder6.addQueryDocumentDefinition(operationTypeSpecBuilder7.addOperationId((TypeSpec.Builder)var7_22, this.operation, newContext)), context).addMethod(this.wrapDataMethod(context));
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"classBuilder(operationTy\u2026(wrapDataMethod(context))");
        TypeSpec.Builder builder2 = operationTypeSpecBuilder2.addBuilder(operationTypeSpecBuilder3.addResponseFieldMapperMethod(operationTypeSpecBuilder4.addVariablesDefinition(builder, this.operation.getVariables(), newContext)), context).addType(this.operation.toTypeSpec(newContext, bl));
        Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"classBuilder(operationTy\u2026ec(newContext, abstract))");
        Object[] objectArray = operationTypeSpecBuilder.addOperationName(builder2).addMethod(this.parseMethod(context)).addMethod(this.parseByteStringMethod(context)).addMethod(this.parseMethodWithDefaultScalarTypeAdapters(context)).addMethod(this.parseByteStringMethodWithDefaultScalarTypeAdapters(context)).addMethod(this.composeRequestBody()).addMethod(this.composeRequestBodyWithDefaultScalarTypeAdapters()).addMethod(this.composeRequestBodyForQuery()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"classBuilder(operationTy\u2026Query())\n        .build()");
        Object[] objectArray2 = objectArray;
        objectArray = new String[4];
        objectArray[0] = "Visitor";
        objectArray[1] = "Mapper";
        builder2 = SchemaTypeSpecBuilder.Companion.getFRAGMENTS_FIELD().type;
        if (builder2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
        }
        objectArray[2] = ((ClassName)builder2).simpleName();
        objectArray[3] = ClassNames.INSTANCE.getBUILDER().simpleName();
        return TestUtilsKt.flatten((TypeSpec)objectArray2, CollectionsKt.listOf((Object[])objectArray));
    }

    private final TypeName operationSuperInterface(CodeGenerationContext context) {
        TypeName typeName;
        ClassName className;
        if (this.operation.isQuery()) {
            className = ClassNames.INSTANCE.getGRAPHQL_QUERY();
        } else if (this.operation.isMutation()) {
            className = ClassNames.INSTANCE.getGRAPHQL_MUTATION();
        } else if (this.operation.isSubscription()) {
            className = ClassNames.INSTANCE.getGRAPHQL_SUBSCRIPTION();
        } else {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Unknown operation type ", (Object)this.operation.getOperationType()));
        }
        ClassName superInterfaceClassName = className;
        Collection collection = this.operation.getVariables();
        boolean bl = false;
        if (!collection.isEmpty()) {
            TypeName[] typeNameArray = new TypeName[]{(TypeName)this.dataVarType, this.wrapperType(context), (TypeName)this.variablesType()};
            collection = ParameterizedTypeName.get((ClassName)superInterfaceClassName, (TypeName[])typeNameArray);
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"{\n      ParameterizedTyp\u2026), variablesType())\n    }");
            typeName = (TypeName)collection;
        } else {
            TypeName[] typeNameArray = new TypeName[]{(TypeName)this.dataVarType, this.wrapperType(context), (TypeName)ClassNames.INSTANCE.getGRAPHQL_OPERATION_VARIABLES()};
            collection = ParameterizedTypeName.get((ClassName)superInterfaceClassName, (TypeName[])typeNameArray);
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"{\n      ParameterizedTyp\u2026PERATION_VARIABLES)\n    }");
            typeName = (TypeName)collection;
        }
        return typeName;
    }

    private final TypeSpec.Builder addOperationId(TypeSpec.Builder $this$addOperationId, Operation operation, CodeGenerationContext context) {
        String id = OperationOutputKt.findOperationId(context.getOperationOutput(), operation.getOperationName(), operation.getPackageName());
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL};
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)((TypeName)ClassNames.INSTANCE.getSTRING()), (String)OPERATION_ID_FIELD_NAME, (Modifier[])new Modifier[0]).addModifiers(objectArray);
        objectArray = new Object[]{id};
        $this$addOperationId.addField(builder.initializer("$S", objectArray).build());
        objectArray = new Modifier[]{Modifier.PUBLIC};
        $this$addOperationId.addMethod(MethodSpec.methodBuilder((String)OPERATION_ID_ACCESSOR_NAME).addAnnotation(Annotations.INSTANCE.getOVERRIDE()).addModifiers(objectArray).returns((TypeName)ClassNames.INSTANCE.getSTRING()).addStatement("return OPERATION_ID", new Object[0]).build());
        return $this$addOperationId;
    }

    private final TypeSpec.Builder addQueryDocumentDefinition(TypeSpec.Builder $this$addQueryDocumentDefinition) {
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL};
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)((TypeName)ClassNames.INSTANCE.getSTRING()), (String)QUERY_DOCUMENT_FIELD_NAME, (Modifier[])new Modifier[0]).addModifiers(objectArray);
        objectArray = new Object[]{QueryDocumentMinifier.class};
        CodeBlock.Builder builder2 = CodeBlock.builder().add("$T.minify(\n", objectArray).indent();
        objectArray = new Object[]{this.operation.getSourceWithFragments()};
        $this$addQueryDocumentDefinition.addField(builder.initializer(builder2.add("$S\n", objectArray).unindent().add(")", new Object[0]).build()).build());
        objectArray = new Modifier[]{Modifier.PUBLIC};
        MethodSpec.Builder builder3 = MethodSpec.methodBuilder((String)QUERY_DOCUMENT_ACCESSOR_NAME).addAnnotation(Annotations.INSTANCE.getOVERRIDE()).addModifiers(objectArray).returns((TypeName)ClassNames.INSTANCE.getSTRING());
        objectArray = new Object[]{QUERY_DOCUMENT_FIELD_NAME};
        $this$addQueryDocumentDefinition.addMethod(builder3.addStatement("return $L", objectArray).build());
        return $this$addQueryDocumentDefinition;
    }

    private final MethodSpec wrapDataMethod(CodeGenerationContext context) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        MethodSpec methodSpec = MethodSpec.methodBuilder((String)"wrapData").addModifiers(modifierArray).addAnnotation(Override.class).addParameter(ParameterSpec.builder((TypeName)((TypeName)this.dataVarType), (String)"data", (Modifier[])new Modifier[0]).build()).returns(this.wrapperType(context)).addStatement(context.getNullableValueType() == NullableValueType.JAVA_OPTIONAL ? "return Optional.ofNullable(data)" : (context.getNullableValueType() != NullableValueType.ANNOTATED ? "return Optional.fromNullable(data)" : "return data"), new Object[0]).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"methodBuilder(\"wrapData\"\u2026      })\n        .build()");
        return methodSpec;
    }

    private final TypeSpec.Builder addVariablesDefinition(TypeSpec.Builder $this$addVariablesDefinition, List<Variable> variables, CodeGenerationContext context) {
        Object object = new Modifier[]{Modifier.PRIVATE, Modifier.FINAL};
        $this$addVariablesDefinition.addField(FieldSpec.builder((TypeName)((TypeName)this.variablesType()), (String)VARIABLES_VAR, (Modifier[])new Modifier[0]).addModifiers((Modifier[])object).build());
        object = new Modifier[]{Modifier.PUBLIC};
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)VARIABLES_VAR).addAnnotation(Annotations.INSTANCE.getOVERRIDE()).addModifiers((Modifier[])object).returns((TypeName)this.variablesType());
        object = new Object[]{VARIABLES_VAR};
        $this$addVariablesDefinition.addMethod(builder.addStatement("return $L", (Object[])object).build());
        object = variables;
        boolean bl = false;
        if (!object.isEmpty()) {
            $this$addVariablesDefinition.addType(new VariablesTypeSpecBuilder(variables, context).build());
        }
        return $this$addVariablesDefinition;
    }

    private final TypeSpec.Builder addResponseFieldMapperMethod(TypeSpec.Builder $this$addResponseFieldMapperMethod) {
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC};
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"responseFieldMapper").addAnnotation(Annotations.INSTANCE.getOVERRIDE()).addModifiers(objectArray);
        objectArray = new TypeName[]{(TypeName)this.dataVarType};
        MethodSpec.Builder builder2 = builder.returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(ResponseFieldMapper.class), (TypeName[])objectArray));
        objectArray = new Object[]{"Data", "Mapper"};
        TypeSpec.Builder builder3 = $this$addResponseFieldMapperMethod.addMethod(builder2.addStatement("return new $L.$L()", objectArray).build());
        Intrinsics.checkExpressionValueIsNotNull((Object)builder3, (String)"addMethod(MethodSpec.met\u2026E_NAME)\n        .build())");
        return builder3;
    }

    private final TypeName wrapperType(CodeGenerationContext context) {
        TypeName typeName;
        NullableValueType nullableValueType = context.getNullableValueType();
        int n = WhenMappings.$EnumSwitchMapping$0[nullableValueType.ordinal()];
        switch (n) {
            case 1: {
                ClassName className = this.dataVarType;
                Intrinsics.checkExpressionValueIsNotNull((Object)className, (String)"dataVarType");
                typeName = ClassNames.INSTANCE.parameterizedGuavaOptional((TypeName)className);
                break;
            }
            case 2: {
                ClassName className = this.dataVarType;
                Intrinsics.checkExpressionValueIsNotNull((Object)className, (String)"dataVarType");
                typeName = ClassNames.INSTANCE.parameterizedOptional((TypeName)className);
                break;
            }
            case 3: {
                ClassName className = this.dataVarType;
                Intrinsics.checkExpressionValueIsNotNull((Object)className, (String)"dataVarType");
                typeName = ClassNames.INSTANCE.parameterizedJavaOptional((TypeName)className);
                break;
            }
            default: {
                typeName = (TypeName)this.dataVarType;
            }
        }
        return typeName;
    }

    private final TypeSpec.Builder addConstructor(TypeSpec.Builder $this$addConstructor, CodeGenerationContext context) {
        List<ParameterSpec> arguments = OperationTypeSpecBuilder.addConstructor$arguments(this, context);
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        modifierArray = MethodSpec.constructorBuilder().addModifiers(modifierArray).addParameters((Iterable)arguments).addCode(OperationTypeSpecBuilder.addConstructor$code(this, arguments)).build();
        boolean bl = false;
        boolean bl2 = false;
        Modifier[] it = modifierArray;
        boolean bl3 = false;
        TypeSpec.Builder builder = $this$addConstructor.addMethod((MethodSpec)it);
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"constructorBuilder()\n   \u2026   .let { addMethod(it) }");
        return builder;
    }

    private final TypeSpec.Builder addBuilder(TypeSpec.Builder $this$addBuilder, CodeGenerationContext context) {
        Pair pair;
        Pair it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        $this$addBuilder.addMethod(BuilderTypeSpecBuilder.Companion.builderFactoryMethod());
        if (this.operation.getVariables().isEmpty()) {
            ClassName className = ClassName.get((String)"", (String)this.operationTypeName, (String[])new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)className, (String)"get(\"\", operationTypeName)");
            TypeSpec.Builder builder = $this$addBuilder.addType(new BuilderTypeSpecBuilder(className, CollectionsKt.emptyList(), MapsKt.emptyMap(), MapsKt.emptyMap(), context.getTypeDeclarations(), null, 32, null).build());
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"addType(BuilderTypeSpecB\u2026arations\n      ).build())");
            return builder;
        }
        Iterable $this$map$iv = this.operation.getVariables();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Variable variable = (Variable)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            pair = TuplesKt.to((Object)StringsKt.decapitalize((String)it.getName()), (Object)it.getType());
            collection.add(pair);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            pair = TuplesKt.to((Object)it.getFirst(), (Object)JavaTypeResolver.resolve$default(new JavaTypeResolver(CodeGenerationContext.copy$default(context, null, null, null, null, NullableValueType.INPUT_TYPE, null, false, false, false, false, false, 2031, null), context.getIr().getTypesPackageName(), false, 4, null), (String)it.getSecond(), false, null, false, 14, null));
            collection.add(pair);
        }
        Object object = (List)destination$iv$iv;
        boolean bl = false;
        boolean bl2 = false;
        Object it2 = object;
        boolean bl3 = false;
        ClassName className = ClassName.get((String)"", (String)this.operationTypeName, (String[])new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)className, (String)"get(\"\", operationTypeName)");
        object = new BuilderTypeSpecBuilder(className, (List)it2, MapsKt.emptyMap(), MapsKt.emptyMap(), context.getTypeDeclarations(), null, 32, null);
        bl = false;
        bl2 = false;
        it2 = object;
        boolean bl4 = false;
        $this$addBuilder.addType(((BuilderTypeSpecBuilder)it2).build());
        return $this$addBuilder;
    }

    private final ClassName variablesType() {
        Collection collection = this.operation.getVariables();
        boolean bl = false;
        return !collection.isEmpty() ? ClassName.get((String)"", (String)Intrinsics.stringPlus((String)this.operationTypeName, (Object)".Variables"), (String[])new String[0]) : ClassNames.INSTANCE.getGRAPHQL_OPERATION_VARIABLES();
    }

    private final TypeSpec.Builder addOperationName(TypeSpec.Builder $this$addOperationName) {
        return OperationTypeSpecBuilder.addOperationName$addOperationNameAccessor(OperationTypeSpecBuilder.addOperationName$addOperationNameField($this$addOperationName, this));
    }

    private final MethodSpec parseMethod(CodeGenerationContext context) {
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC};
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"parse").addAnnotation(Annotations.INSTANCE.getOVERRIDE()).addAnnotation(Annotations.INSTANCE.getNONNULL()).addModifiers(objectArray);
        objectArray = new Modifier[]{Modifier.FINAL};
        MethodSpec.Builder builder2 = builder.addParameter(ParameterSpec.builder((TypeName)((TypeName)OkioJavaTypeName.INSTANCE.getBufferedSource()), (String)"source", (Modifier[])objectArray).addAnnotation(Annotations.INSTANCE.getNONNULL()).build());
        objectArray = new Modifier[]{Modifier.FINAL};
        MethodSpec.Builder builder3 = builder2.addParameter(ParameterSpec.builder((Type)((Type)((Object)ScalarTypeAdapters.class)), (String)"scalarTypeAdapters", (Modifier[])objectArray).addAnnotation(Annotations.INSTANCE.getNONNULL()).build()).addException((Type)((Object)IOException.class));
        objectArray = new TypeName[]{this.wrapperType(context)};
        MethodSpec.Builder builder4 = builder3.returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Response.class), (TypeName[])objectArray));
        objectArray = new Object[]{SimpleOperationResponseParser.class};
        MethodSpec methodSpec = builder4.addStatement("return $T.parse(source, this, scalarTypeAdapters)", objectArray).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"methodBuilder(\"parse\")\n \u2026ss.java)\n        .build()");
        return methodSpec;
    }

    private final MethodSpec parseMethodWithDefaultScalarTypeAdapters(CodeGenerationContext context) {
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC};
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"parse").addAnnotation(Annotations.INSTANCE.getOVERRIDE()).addAnnotation(Annotations.INSTANCE.getNONNULL()).addModifiers(objectArray);
        objectArray = new Modifier[]{Modifier.FINAL};
        MethodSpec.Builder builder2 = builder.addParameter(ParameterSpec.builder((TypeName)((TypeName)OkioJavaTypeName.INSTANCE.getBufferedSource()), (String)"source", (Modifier[])objectArray).addAnnotation(Annotations.INSTANCE.getNONNULL()).build()).addException((Type)((Object)IOException.class));
        objectArray = new TypeName[]{this.wrapperType(context)};
        MethodSpec.Builder builder3 = builder2.returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Response.class), (TypeName[])objectArray));
        objectArray = new Object[]{ScalarTypeAdapters.class};
        MethodSpec methodSpec = builder3.addStatement("return parse(source, $T.DEFAULT)", objectArray).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"methodBuilder(\"parse\")\n \u2026ss.java)\n        .build()");
        return methodSpec;
    }

    private final MethodSpec parseByteStringMethod(CodeGenerationContext context) {
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC};
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"parse").addAnnotation(Annotations.INSTANCE.getOVERRIDE()).addAnnotation(Annotations.INSTANCE.getNONNULL()).addModifiers(objectArray);
        objectArray = new Modifier[]{Modifier.FINAL};
        MethodSpec.Builder builder2 = builder.addParameter(ParameterSpec.builder((TypeName)((TypeName)OkioJavaTypeName.INSTANCE.getByteString()), (String)"byteString", (Modifier[])objectArray).addAnnotation(Annotations.INSTANCE.getNONNULL()).build());
        objectArray = new Modifier[]{Modifier.FINAL};
        MethodSpec.Builder builder3 = builder2.addParameter(ParameterSpec.builder((Type)((Type)((Object)ScalarTypeAdapters.class)), (String)"scalarTypeAdapters", (Modifier[])objectArray).addAnnotation(Annotations.INSTANCE.getNONNULL()).build()).addException((Type)((Object)IOException.class));
        objectArray = new TypeName[]{this.wrapperType(context)};
        MethodSpec.Builder builder4 = builder3.returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Response.class), (TypeName[])objectArray));
        objectArray = new Object[]{OkioJavaTypeName.INSTANCE.getBuffer()};
        MethodSpec methodSpec = builder4.addStatement("return parse(new $T().write(byteString), scalarTypeAdapters)", objectArray).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"methodBuilder(\"parse\")\n \u2026.Buffer)\n        .build()");
        return methodSpec;
    }

    private final MethodSpec parseByteStringMethodWithDefaultScalarTypeAdapters(CodeGenerationContext context) {
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC};
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"parse").addAnnotation(Annotations.INSTANCE.getOVERRIDE()).addAnnotation(Annotations.INSTANCE.getNONNULL()).addModifiers(objectArray);
        objectArray = new Modifier[]{Modifier.FINAL};
        MethodSpec.Builder builder2 = builder.addParameter(ParameterSpec.builder((TypeName)((TypeName)OkioJavaTypeName.INSTANCE.getByteString()), (String)"byteString", (Modifier[])objectArray).addAnnotation(Annotations.INSTANCE.getNONNULL()).build()).addException((Type)((Object)IOException.class));
        objectArray = new TypeName[]{this.wrapperType(context)};
        MethodSpec.Builder builder3 = builder2.returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Response.class), (TypeName[])objectArray));
        objectArray = new Object[]{ScalarTypeAdapters.class};
        MethodSpec methodSpec = builder3.addStatement("return parse(byteString, $T.DEFAULT)", objectArray).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"methodBuilder(\"parse\")\n \u2026ss.java)\n        .build()");
        return methodSpec;
    }

    private final MethodSpec composeRequestBody() {
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC};
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"composeRequestBody").addAnnotation(Annotations.INSTANCE.getOVERRIDE()).addAnnotation(Annotations.INSTANCE.getNONNULL()).addModifiers(objectArray);
        objectArray = new Modifier[]{Modifier.FINAL};
        MethodSpec.Builder builder2 = builder.addParameter(ParameterSpec.builder((Type)((Type)((Object)ScalarTypeAdapters.class)), (String)"scalarTypeAdapters", (Modifier[])objectArray).addAnnotation(Annotations.INSTANCE.getNONNULL()).build()).returns((TypeName)OkioJavaTypeName.INSTANCE.getByteString());
        objectArray = new Object[]{OperationRequestBodyComposer.class};
        MethodSpec methodSpec = builder2.addStatement("return $T.compose(this, false, true, scalarTypeAdapters)", objectArray).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"methodBuilder(\"composeRe\u2026ss.java)\n        .build()");
        return methodSpec;
    }

    private final MethodSpec composeRequestBodyWithDefaultScalarTypeAdapters() {
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC};
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"composeRequestBody").addAnnotation(Annotations.INSTANCE.getNONNULL()).addAnnotation(Annotations.INSTANCE.getOVERRIDE()).addModifiers(objectArray).returns((TypeName)OkioJavaTypeName.INSTANCE.getByteString());
        objectArray = new Object[]{OperationRequestBodyComposer.class, ScalarTypeAdapters.class};
        MethodSpec methodSpec = builder.addStatement("return $T.compose(this, false, true, $T.DEFAULT)", objectArray).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"methodBuilder(\"composeRe\u2026ss.java)\n        .build()");
        return methodSpec;
    }

    private final MethodSpec composeRequestBodyForQuery() {
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC};
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"composeRequestBody").addAnnotation(Annotations.INSTANCE.getOVERRIDE()).addAnnotation(Annotations.INSTANCE.getNONNULL()).addModifiers(objectArray);
        objectArray = new Modifier[]{Modifier.FINAL};
        MethodSpec.Builder builder2 = builder.addParameter(ParameterSpec.builder((TypeName)TypeName.BOOLEAN, (String)"autoPersistQueries", (Modifier[])objectArray).build());
        objectArray = new Modifier[]{Modifier.FINAL};
        MethodSpec.Builder builder3 = builder2.addParameter(ParameterSpec.builder((TypeName)TypeName.BOOLEAN, (String)"withQueryDocument", (Modifier[])objectArray).build());
        objectArray = new Modifier[]{Modifier.FINAL};
        MethodSpec.Builder builder4 = builder3.addParameter(ParameterSpec.builder((Type)((Type)((Object)ScalarTypeAdapters.class)), (String)"scalarTypeAdapters", (Modifier[])objectArray).addAnnotation(Annotations.INSTANCE.getNONNULL()).build()).returns((TypeName)OkioJavaTypeName.INSTANCE.getByteString());
        objectArray = new Object[]{OperationRequestBodyComposer.class};
        MethodSpec methodSpec = builder4.addStatement("return $T.compose(this, autoPersistQueries, withQueryDocument, scalarTypeAdapters)", objectArray).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"methodBuilder(\"composeRe\u2026ss.java)\n        .build()");
        return methodSpec;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ParameterSpec> addConstructor$arguments(OperationTypeSpecBuilder this$0, CodeGenerationContext $context) {
        Pair pair;
        Pair variable;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = this$0.operation.getVariables();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Variable variable2 = (Variable)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            pair = TuplesKt.to((Object)StringsKt.decapitalize((String)variable.getName()), (Object)JavaTypeResolver.resolve$default(new JavaTypeResolver(CodeGenerationContext.copy$default($context, null, null, null, null, NullableValueType.INPUT_TYPE, null, false, false, false, false, false, 2031, null), $context.getIr().getTypesPackageName(), false, 4, null), variable.getType(), false, null, false, 14, null));
            collection.add(pair);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $dstr$name$type;
            variable = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String name = (String)$dstr$name$type.component1();
            TypeName type = (TypeName)$dstr$name$type.component2();
            ParameterSpec.Builder builder = ParameterSpec.builder((TypeName)type, (String)name, (Modifier[])new Modifier[0]);
            boolean bl2 = false;
            boolean bl3 = false;
            ParameterSpec.Builder $this$addConstructor_u24arguments_u24lambda_u2d3_u24lambda_u2d2 = builder;
            boolean bl4 = false;
            if (!type.annotations.contains(Annotations.INSTANCE.getNONNULL()) && !type.isPrimitive()) {
                $this$addConstructor_u24arguments_u24lambda_u2d3_u24lambda_u2d2.addAnnotation(Annotations.INSTANCE.getNONNULL());
            }
            pair = builder.build();
            collection.add(pair);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final CodeBlock addConstructor$code(OperationTypeSpecBuilder this$0, List<ParameterSpec> arguments) {
        CodeBlock codeBlock;
        if (arguments.isEmpty()) {
            Object[] objectArray = new Object[]{VARIABLES_VAR, ClassNames.INSTANCE.getGRAPHQL_OPERATION()};
            CodeBlock codeBlock2 = CodeBlock.of((String)"this.$L = $T.EMPTY_VARIABLES;\n", (Object[])objectArray);
            Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock2, (String)"{\n        CodeBlock.of(\"\u2026RAPHQL_OPERATION)\n      }");
            codeBlock = codeBlock2;
        } else {
            Object[] $this$forEach$iv;
            ParameterSpec it;
            Iterator $this$filterTo$iv$iv;
            CodeBlock.Builder codeBuilder = CodeBlock.builder();
            Iterable $this$filter$iv = arguments;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection collection = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                it = (ParameterSpec)element$iv$iv;
                boolean bl = false;
                if (!(!it.type.isPrimitive())) continue;
                collection.add(element$iv$iv);
            }
            $this$filter$iv = (List)collection;
            boolean $i$f$forEach = false;
            for (Object t : $this$forEach$iv) {
                ParameterSpec it2 = (ParameterSpec)t;
                boolean bl = false;
                Object[] objectArray = new Object[]{ClassNames.INSTANCE.getAPI_UTILS(), it2.name, Intrinsics.stringPlus((String)it2.name, (Object)" == null")};
                codeBuilder.addStatement("$T.checkNotNull($L, $S)", objectArray);
            }
            $this$forEach$iv = new Object[]{VARIABLES_VAR, this$0.variablesType()};
            codeBuilder.add("$L = new $T(", $this$forEach$iv);
            Iterable $this$forEachIndexed$iv = arguments;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void argument;
                int n = index$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                it = (ParameterSpec)item$iv;
                int i = n;
                boolean bl2 = false;
                Object[] objectArray = new Object[]{i > 0 ? ", " : "", argument.name};
                codeBuilder.add("$L$L", objectArray);
            }
            CodeBlock codeBlock3 = codeBuilder.add(");\n", new Object[0]).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock3, (String)"{\n        val codeBuilde\u2026d(\");\\n\").build()\n      }");
            codeBlock = codeBlock3;
        }
        return codeBlock;
    }

    private static final TypeSpec addOperationName$operationNameTypeSpec(OperationTypeSpecBuilder this$0) {
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC};
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"name").addModifiers(objectArray).addAnnotation(Override.class).returns((Type)((Object)String.class));
        objectArray = new Object[]{this$0.operation.getOperationName()};
        return TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((Type)((Object)OperationName.class)).addMethod(builder.addStatement("return $S", objectArray).build()).build();
    }

    private static final TypeSpec.Builder addOperationName$addOperationNameField(TypeSpec.Builder $this$addOperationName_u24addOperationNameField, OperationTypeSpecBuilder this$0) {
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL};
        FieldSpec.Builder builder = FieldSpec.builder((Type)((Type)((Object)OperationName.class)), (String)"OPERATION_NAME", (Modifier[])objectArray);
        objectArray = new Object[]{OperationTypeSpecBuilder.addOperationName$operationNameTypeSpec(this$0)};
        TypeSpec.Builder builder2 = $this$addOperationName_u24addOperationNameField.addField(builder.initializer("$L", objectArray).build());
        Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"addField(FieldSpec.build\u2026())\n            .build())");
        return builder2;
    }

    private static final TypeSpec.Builder addOperationName$addOperationNameAccessor(TypeSpec.Builder $this$addOperationName_u24addOperationNameAccessor) {
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC};
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"name").addModifiers(objectArray).addAnnotation(Override.class).returns((Type)((Object)OperationName.class));
        objectArray = new Object[]{"OPERATION_NAME"};
        TypeSpec.Builder builder2 = $this$addOperationName_u24addOperationNameAccessor.addMethod(builder.addStatement("return $L", objectArray).build());
        Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"addMethod(MethodSpec.met\u2026E\")\n            .build())");
        return builder2;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/apollographql/apollo/compiler/OperationTypeSpecBuilder$Companion;", "", "()V", "OPERATION_ID_ACCESSOR_NAME", "", "OPERATION_ID_FIELD_NAME", "QUERY_DOCUMENT_ACCESSOR_NAME", "QUERY_DOCUMENT_FIELD_NAME", "VARIABLES_VAR", "apollo-compiler"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NullableValueType.values().length];
            nArray[NullableValueType.GUAVA_OPTIONAL.ordinal()] = 1;
            nArray[NullableValueType.APOLLO_OPTIONAL.ordinal()] = 2;
            nArray[NullableValueType.JAVA_OPTIONAL.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

