/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.compiler.parser.introspection;

import com.apollographql.apollo.compiler.parser.error.ParseException;
import com.apollographql.apollo.compiler.parser.introspection.IntrospectionSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u001c\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u001c\u0010\u0003\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\n*\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0014\u0010\u000b\u001a\u00020\u0005*\u00020\b2\u0006\u0010\f\u001a\u00020\u0002H\u0000\u001a\u0014\u0010\u000b\u001a\u00020\u0002*\u00020\b2\u0006\u0010\r\u001a\u00020\u0001H\u0000\u001a\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u0001*\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0001H\u0000\u00a8\u0006\u0010"}, d2={"asGraphQLType", "", "Lcom/apollographql/apollo/compiler/parser/introspection/IntrospectionSchema$TypeRef;", "isAssignableFrom", "", "Lcom/apollographql/apollo/compiler/parser/introspection/IntrospectionSchema$Type;", "other", "schema", "Lcom/apollographql/apollo/compiler/parser/introspection/IntrospectionSchema;", "possibleTypes", "", "resolveType", "typeRef", "graphqlType", "rootTypeForOperationType", "operationType", "apollo-compiler"})
public final class UtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<String> possibleTypes(@NotNull IntrospectionSchema.Type $this$possibleTypes, @NotNull IntrospectionSchema schema) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)$this$possibleTypes, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        IntrospectionSchema.Type type = $this$possibleTypes;
        if (type instanceof IntrospectionSchema.Type.Union) {
            void $this$flatMapTo$iv$iv;
            List<IntrospectionSchema.TypeRef> list = ((IntrospectionSchema.Type.Union)$this$possibleTypes).getPossibleTypes();
            Iterable $this$flatMap$iv = list == null ? CollectionsKt.emptyList() : list;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                String typeName;
                IntrospectionSchema.Type type2;
                IntrospectionSchema.TypeRef typeRef = (IntrospectionSchema.TypeRef)element$iv$iv;
                boolean bl = false;
                if (typeRef.getRawType().getName() == null) {
                    Intrinsics.throwNpe();
                }
                if ((type2 = (IntrospectionSchema.Type)schema.get((Object)typeName)) == null) {
                    throw new ParseException("Unknown possible type `" + typeName + "` for UNION `" + $this$possibleTypes.getName() + '`');
                }
                IntrospectionSchema.Type schemaType = type2;
                Iterable list$iv$iv = UtilsKt.possibleTypes(schemaType, schema);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        } else if (type instanceof IntrospectionSchema.Type.Interface) {
            Iterable<IntrospectionSchema.TypeRef> $this$flatMap$iv = ((IntrospectionSchema.Type.Interface)$this$possibleTypes).getPossibleTypes();
            $this$flatMap$iv = $this$flatMap$iv == null ? CollectionsKt.emptyList() : $this$flatMap$iv;
            boolean $i$f$flatMap = false;
            Iterable<IntrospectionSchema.TypeRef> $this$flatMapTo$iv$iv = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator<IntrospectionSchema.TypeRef> iterator = $this$flatMapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                String typeName;
                IntrospectionSchema.Type type3;
                IntrospectionSchema.TypeRef element$iv$iv;
                IntrospectionSchema.TypeRef typeRef = element$iv$iv = iterator.next();
                boolean bl = false;
                if (typeRef.getRawType().getName() == null) {
                    Intrinsics.throwNpe();
                }
                if ((type3 = (IntrospectionSchema.Type)schema.get((Object)typeName)) == null) {
                    throw new ParseException("Unknown possible type `" + typeName + "` for INTERFACE `" + $this$possibleTypes.getName() + '`');
                }
                IntrospectionSchema.Type schemaType = type3;
                Iterable list$iv$iv = UtilsKt.possibleTypes(schemaType, schema);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        } else {
            set = SetsKt.setOf((Object)$this$possibleTypes.getName());
        }
        return set;
    }

    public static final boolean isAssignableFrom(@NotNull IntrospectionSchema.Type $this$isAssignableFrom, @NotNull IntrospectionSchema.Type other, @NotNull IntrospectionSchema schema) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isAssignableFrom, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        return UtilsKt.isAssignableFrom(new IntrospectionSchema.TypeRef($this$isAssignableFrom.getKind(), $this$isAssignableFrom.getName(), null, 4, null), new IntrospectionSchema.TypeRef(other.getKind(), other.getName(), null, 4, null), schema);
    }

    @NotNull
    public static final String asGraphQLType(@NotNull IntrospectionSchema.TypeRef $this$asGraphQLType) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$this$asGraphQLType, (String)"<this>");
        IntrospectionSchema.Kind kind = $this$asGraphQLType.getKind();
        int n = WhenMappings.$EnumSwitchMapping$0[kind.ordinal()];
        switch (n) {
            case 1: {
                IntrospectionSchema.TypeRef typeRef = $this$asGraphQLType.getOfType();
                if (typeRef == null) {
                    Intrinsics.throwNpe();
                }
                string = Intrinsics.stringPlus((String)UtilsKt.asGraphQLType(typeRef), (Object)"!");
                break;
            }
            case 2: {
                StringBuilder stringBuilder = new StringBuilder().append('[');
                IntrospectionSchema.TypeRef typeRef = $this$asGraphQLType.getOfType();
                if (typeRef == null) {
                    Intrinsics.throwNpe();
                }
                string = stringBuilder.append(UtilsKt.asGraphQLType(typeRef)).append(']').toString();
                break;
            }
            default: {
                string = $this$asGraphQLType.getName();
                if (string != null) break;
                Intrinsics.throwNpe();
            }
        }
        return string;
    }

    public static final boolean isAssignableFrom(@NotNull IntrospectionSchema.TypeRef $this$isAssignableFrom, @NotNull IntrospectionSchema.TypeRef other, @NotNull IntrospectionSchema schema) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$this$isAssignableFrom, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        IntrospectionSchema.Kind kind = $this$isAssignableFrom.getKind();
        int n = WhenMappings.$EnumSwitchMapping$0[kind.ordinal()];
        switch (n) {
            case 1: {
                if (other.getKind() == IntrospectionSchema.Kind.NON_NULL) {
                    IntrospectionSchema.TypeRef typeRef = $this$isAssignableFrom.getOfType();
                    if (typeRef == null) {
                        Intrinsics.throwNpe();
                    }
                    IntrospectionSchema.TypeRef typeRef2 = other.getOfType();
                    if (typeRef2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (UtilsKt.isAssignableFrom(typeRef, typeRef2, schema)) {
                        bl = true;
                        break;
                    }
                }
                bl = false;
                break;
            }
            case 2: {
                if (other.getKind() == IntrospectionSchema.Kind.NON_NULL) {
                    IntrospectionSchema.TypeRef typeRef = other.getOfType();
                    if (typeRef == null) {
                        Intrinsics.throwNpe();
                    }
                    bl = UtilsKt.isAssignableFrom($this$isAssignableFrom, typeRef, schema);
                    break;
                }
                if (other.getKind() == IntrospectionSchema.Kind.LIST) {
                    IntrospectionSchema.TypeRef typeRef = $this$isAssignableFrom.getOfType();
                    if (typeRef == null) {
                        Intrinsics.throwNpe();
                    }
                    IntrospectionSchema.TypeRef typeRef3 = other.getOfType();
                    if (typeRef3 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (UtilsKt.isAssignableFrom(typeRef, typeRef3, schema)) {
                        bl = true;
                        break;
                    }
                }
                bl = false;
                break;
            }
            default: {
                if (other.getKind() == IntrospectionSchema.Kind.NON_NULL) {
                    IntrospectionSchema.TypeRef typeRef = other.getOfType();
                    if (typeRef == null) {
                        Intrinsics.throwNpe();
                    }
                    bl = UtilsKt.isAssignableFrom($this$isAssignableFrom, typeRef, schema);
                    break;
                }
                Set<String> possibleTypes = UtilsKt.possibleTypes(UtilsKt.resolveType(schema, $this$isAssignableFrom), schema);
                Set<String> otherPossibleTypes = UtilsKt.possibleTypes(UtilsKt.resolveType(schema, other), schema);
                Collection collection = CollectionsKt.intersect((Iterable)possibleTypes, (Iterable)otherPossibleTypes);
                boolean bl2 = false;
                bl = !collection.isEmpty();
            }
        }
        return bl;
    }

    @NotNull
    public static final IntrospectionSchema.TypeRef resolveType(@NotNull IntrospectionSchema $this$resolveType, @NotNull String graphqlType) {
        IntrospectionSchema.TypeRef typeRef;
        Intrinsics.checkParameterIsNotNull((Object)$this$resolveType, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)graphqlType, (String)"graphqlType");
        if (StringsKt.startsWith$default((String)graphqlType, (String)"[", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)graphqlType, (String)"]", (boolean)false, (int)2, null)) {
            typeRef = new IntrospectionSchema.TypeRef(IntrospectionSchema.Kind.LIST, null, UtilsKt.resolveType($this$resolveType, StringsKt.removeSurrounding((String)graphqlType, (CharSequence)"[", (CharSequence)"]")), 2, null);
        } else if (StringsKt.endsWith$default((String)graphqlType, (String)"!", (boolean)false, (int)2, null)) {
            typeRef = new IntrospectionSchema.TypeRef(IntrospectionSchema.Kind.NON_NULL, null, UtilsKt.resolveType($this$resolveType, StringsKt.removeSuffix((String)graphqlType, (CharSequence)"!")), 2, null);
        } else {
            IntrospectionSchema.Type type = (IntrospectionSchema.Type)$this$resolveType.get((Object)graphqlType);
            if (type == null) {
                typeRef = null;
            } else {
                IntrospectionSchema.Type type2 = type;
                boolean bl = false;
                boolean bl2 = false;
                IntrospectionSchema.Type it = type2;
                boolean bl3 = false;
                typeRef = new IntrospectionSchema.TypeRef(it.getKind(), it.getName(), null, 4, null);
            }
        }
        IntrospectionSchema.TypeRef typeRef2 = typeRef;
        if (typeRef2 == null) {
            throw new ParseException("Unknown type `" + graphqlType + '`');
        }
        return typeRef2;
    }

    @NotNull
    public static final IntrospectionSchema.Type resolveType(@NotNull IntrospectionSchema $this$resolveType, @NotNull IntrospectionSchema.TypeRef typeRef) {
        Intrinsics.checkParameterIsNotNull((Object)$this$resolveType, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)typeRef, (String)"typeRef");
        Map map = $this$resolveType;
        String string = typeRef.getName();
        boolean bl = false;
        IntrospectionSchema.Type type = (IntrospectionSchema.Type)map.get(string);
        if (type == null) {
            throw new ParseException("Unknown type `" + typeRef.getName() + '`');
        }
        return type;
    }

    @Nullable
    public static final String rootTypeForOperationType(@NotNull IntrospectionSchema $this$rootTypeForOperationType, @NotNull String operationType) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$this$rootTypeForOperationType, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)operationType, (String)"operationType");
        switch (operationType) {
            case "query": {
                string = $this$rootTypeForOperationType.getQueryType();
                break;
            }
            case "mutation": {
                string = $this$rootTypeForOperationType.getMutationType();
                break;
            }
            case "subscription": {
                string = $this$rootTypeForOperationType.getSubscriptionType();
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IntrospectionSchema.Kind.values().length];
            nArray[IntrospectionSchema.Kind.NON_NULL.ordinal()] = 1;
            nArray[IntrospectionSchema.Kind.LIST.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

