/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.api.http;

import com.apollographql.apollo3.api.ApolloRequest;
import com.apollographql.apollo3.api.CustomScalarAdapters;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.Subscription;
import com.apollographql.apollo3.api.Upload;
import com.apollographql.apollo3.api.http.HttpBody;
import com.apollographql.apollo3.api.http.HttpHeader;
import com.apollographql.apollo3.api.http.HttpMethod;
import com.apollographql.apollo3.api.http.HttpRequest;
import com.apollographql.apollo3.api.http.HttpRequestComposer;
import com.apollographql.apollo3.api.http.UploadsHttpBody;
import com.apollographql.apollo3.api.http.internal.UrlEncodeKt;
import com.apollographql.apollo3.api.json.BufferedSinkJsonWriter;
import com.apollographql.apollo3.api.json.JsonWriter;
import com.apollographql.apollo3.api.json.MapJsonWriter;
import com.apollographql.apollo3.api.json.internal.FileUploadAwareJsonWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u0006\"\b\b\u0000\u0010\u0007*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/apollographql/apollo3/api/http/DefaultHttpRequestComposer;", "Lcom/apollographql/apollo3/api/http/HttpRequestComposer;", "serverUrl", "", "(Ljava/lang/String;)V", "compose", "Lcom/apollographql/apollo3/api/http/HttpRequest;", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "apolloRequest", "Lcom/apollographql/apollo3/api/ApolloRequest;", "Companion", "apollo-api"})
public final class DefaultHttpRequestComposer
implements HttpRequestComposer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String serverUrl;
    @NotNull
    public static final String HEADER_APOLLO_OPERATION_ID = "X-APOLLO-OPERATION-ID";
    @NotNull
    public static final String HEADER_APOLLO_OPERATION_NAME = "X-APOLLO-OPERATION-NAME";
    @NotNull
    private static final String HEADER_ACCEPT_NAME = "Accept";
    @NotNull
    private static final String HEADER_ACCEPT_VALUE_DEFER = "multipart/mixed; deferSpec=20220824, application/json";
    @NotNull
    private static final String HEADER_ACCEPT_VALUE_MULTIPART = "multipart/mixed; boundary=\"graphql\"; subscriptionSpec=1.0, application/json";

    public DefaultHttpRequestComposer(@NotNull String serverUrl) {
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        this.serverUrl = serverUrl;
    }

    @Override
    @NotNull
    public <D extends Operation.Data> HttpRequest compose(@NotNull ApolloRequest<D> apolloRequest) {
        HttpRequest httpRequest;
        List list;
        Intrinsics.checkNotNullParameter(apolloRequest, (String)"apolloRequest");
        Operation<D> operation = apolloRequest.getOperation();
        CustomScalarAdapters customScalarAdapters = (CustomScalarAdapters)apolloRequest.getExecutionContext().get(CustomScalarAdapters.Key);
        if (customScalarAdapters == null) {
            customScalarAdapters = CustomScalarAdapters.Empty;
        }
        CustomScalarAdapters customScalarAdapters2 = customScalarAdapters;
        List $this$compose_u24lambda_u240 = list = (List)new ArrayList();
        boolean bl = false;
        $this$compose_u24lambda_u240.add(new HttpHeader(HEADER_APOLLO_OPERATION_ID, operation.id()));
        $this$compose_u24lambda_u240.add(new HttpHeader(HEADER_APOLLO_OPERATION_NAME, operation.name()));
        if (apolloRequest.getOperation() instanceof Subscription) {
            $this$compose_u24lambda_u240.add(new HttpHeader(HEADER_ACCEPT_NAME, HEADER_ACCEPT_VALUE_MULTIPART));
        } else {
            $this$compose_u24lambda_u240.add(new HttpHeader(HEADER_ACCEPT_NAME, HEADER_ACCEPT_VALUE_DEFER));
        }
        if (apolloRequest.getHttpHeaders() != null) {
            $this$compose_u24lambda_u240.addAll((Collection)apolloRequest.getHttpHeaders());
        }
        List requestHeaders = list;
        Boolean bl2 = apolloRequest.getSendApqExtensions();
        boolean sendApqExtensions = bl2 != null ? bl2 : false;
        Boolean bl3 = apolloRequest.getSendDocument();
        boolean sendDocument = bl3 != null ? bl3 : true;
        HttpMethod httpMethod = apolloRequest.getHttpMethod();
        if (httpMethod == null) {
            httpMethod = HttpMethod.Post;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[httpMethod.ordinal()]) {
            case 1: {
                httpRequest = new HttpRequest.Builder(HttpMethod.Get, DefaultHttpRequestComposer.Companion.buildGetUrl(this.serverUrl, operation, customScalarAdapters2, sendApqExtensions, sendDocument)).addHeaders(requestHeaders).build();
                break;
            }
            case 2: {
                String query = sendDocument ? operation.document() : null;
                httpRequest = new HttpRequest.Builder(HttpMethod.Post, this.serverUrl).addHeaders(requestHeaders).body(Companion.buildPostBody(operation, customScalarAdapters2, sendApqExtensions, query)).build();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return httpRequest;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\t\u001a\u00020\u0004\"\b\b\u0000\u0010\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\n0\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J6\u0010\u0014\u001a\u00020\u0015\"\b\b\u0000\u0010\n*\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\n0\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012J8\u0010\u0017\u001a\u00020\u0018\"\b\b\u0000\u0010\n*\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\n0\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00122\b\u0010\u0019\u001a\u0004\u0018\u00010\u0004JD\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001b\"\b\b\u0000\u0010\n*\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\n0\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J,\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001b\"\b\b\u0000\u0010\n*\u00020\u000b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\n0\u001eJN\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020 0\u001b\"\b\b\u0000\u0010\n*\u00020\u000b2\u0006\u0010!\u001a\u00020\"2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\n0\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0019\u001a\u0004\u0018\u00010\u0004H\u0002J\u001e\u0010#\u001a\u00020\u0004*\u00020\u00042\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/apollographql/apollo3/api/http/DefaultHttpRequestComposer$Companion;", "", "()V", "HEADER_ACCEPT_NAME", "", "HEADER_ACCEPT_VALUE_DEFER", "HEADER_ACCEPT_VALUE_MULTIPART", "HEADER_APOLLO_OPERATION_ID", "HEADER_APOLLO_OPERATION_NAME", "buildGetUrl", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "serverUrl", "operation", "Lcom/apollographql/apollo3/api/Operation;", "customScalarAdapters", "Lcom/apollographql/apollo3/api/CustomScalarAdapters;", "sendApqExtensions", "", "sendDocument", "buildParamsMap", "Lokio/ByteString;", "autoPersistQueries", "buildPostBody", "Lcom/apollographql/apollo3/api/http/HttpBody;", "query", "composeGetParams", "", "composePayload", "apolloRequest", "Lcom/apollographql/apollo3/api/ApolloRequest;", "composePostParams", "Lcom/apollographql/apollo3/api/Upload;", "writer", "Lcom/apollographql/apollo3/api/json/JsonWriter;", "appendQueryParameters", "parameters", "apollo-api"})
    @SourceDebugExtension(value={"SMAP\nDefaultHttpRequestComposer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultHttpRequestComposer.kt\ncom/apollographql/apollo3/api/http/DefaultHttpRequestComposer$Companion\n+ 2 JsonWriters.kt\ncom/apollographql/apollo3/api/json/-JsonWriters\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,354:1\n46#2,6:355\n46#2,8:361\n46#2,6:369\n46#2,8:375\n52#2,2:383\n52#2,2:385\n67#2,7:387\n46#2,8:394\n74#2:402\n67#2,7:403\n46#2,6:410\n46#2,8:416\n52#2,2:424\n74#2:426\n79#2,7:429\n78#2,8:436\n90#2,7:444\n1849#3,2:427\n*S KotlinDebug\n*F\n+ 1 DefaultHttpRequestComposer.kt\ncom/apollographql/apollo3/api/http/DefaultHttpRequestComposer$Companion\n*L\n118#1:355,6\n124#1:361,8\n136#1:369,6\n138#1:375,8\n136#1:383,2\n118#1:385,2\n164#1:387,7\n166#1:394,8\n164#1:402\n181#1:403,7\n182#1:410,6\n184#1:416,8\n182#1:424,2\n181#1:426\n223#1:429,7\n253#1:436,8\n269#1:444,7\n202#1:427,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final <D extends Operation.Data> String buildGetUrl(String serverUrl, Operation<D> operation, CustomScalarAdapters customScalarAdapters, boolean sendApqExtensions, boolean sendDocument) {
            return this.appendQueryParameters(serverUrl, this.composeGetParams(operation, customScalarAdapters, sendApqExtensions, sendDocument));
        }

        private final <D extends Operation.Data> Map<String, Upload> composePostParams(JsonWriter writer, Operation<D> operation, CustomScalarAdapters customScalarAdapters, boolean sendApqExtensions, String query) {
            Map<String, Upload> uploads = null;
            JsonWriter $this$writeObject$iv = writer;
            boolean $i$f$writeObject = false;
            $this$writeObject$iv.beginObject();
            JsonWriter $this$composePostParams_u24lambda_u243 = $this$writeObject$iv;
            boolean bl = false;
            $this$composePostParams_u24lambda_u243.name("operationName");
            $this$composePostParams_u24lambda_u243.value(operation.name());
            $this$composePostParams_u24lambda_u243.name("variables");
            FileUploadAwareJsonWriter uploadAwareWriter = new FileUploadAwareJsonWriter($this$composePostParams_u24lambda_u243);
            JsonWriter $this$writeObject$iv2 = uploadAwareWriter;
            boolean $i$f$writeObject2 = false;
            $this$writeObject$iv2.beginObject();
            JsonWriter $this$composePostParams_u24lambda_u243_u24lambda_u240 = $this$writeObject$iv2;
            boolean bl2 = false;
            operation.serializeVariables($this$composePostParams_u24lambda_u243_u24lambda_u240, customScalarAdapters);
            $this$writeObject$iv2.endObject();
            uploads = uploadAwareWriter.collectedUploads();
            if (query != null) {
                $this$composePostParams_u24lambda_u243.name("query");
                $this$composePostParams_u24lambda_u243.value(query);
            }
            if (sendApqExtensions) {
                $this$composePostParams_u24lambda_u243.name("extensions");
                $this$writeObject$iv2 = $this$composePostParams_u24lambda_u243;
                $i$f$writeObject2 = false;
                $this$writeObject$iv2.beginObject();
                JsonWriter $this$composePostParams_u24lambda_u243_u24lambda_u242 = $this$writeObject$iv2;
                boolean bl3 = false;
                $this$composePostParams_u24lambda_u243_u24lambda_u242.name("persistedQuery");
                JsonWriter $this$writeObject$iv3 = $this$composePostParams_u24lambda_u243_u24lambda_u242;
                boolean $i$f$writeObject3 = false;
                $this$writeObject$iv3.beginObject();
                JsonWriter $this$composePostParams_u24lambda_u243_u24lambda_u242_u24lambda_u241 = $this$writeObject$iv3;
                boolean bl4 = false;
                $this$composePostParams_u24lambda_u243_u24lambda_u242_u24lambda_u241.name("version").value(1);
                $this$composePostParams_u24lambda_u243_u24lambda_u242_u24lambda_u241.name("sha256Hash").value(operation.id());
                $this$writeObject$iv3.endObject();
                $this$writeObject$iv2.endObject();
            }
            $this$writeObject$iv.endObject();
            return uploads;
        }

        private final <D extends Operation.Data> Map<String, String> composeGetParams(Operation<D> operation, CustomScalarAdapters customScalarAdapters, boolean autoPersistQueries, boolean sendDocument) {
            Map queryParams = new LinkedHashMap();
            queryParams.put("operationName", operation.name());
            String indent$iv = null;
            boolean $i$f$buildJsonString = false;
            Buffer buffer$iv = new Buffer();
            JsonWriter $this$composeGetParams_u24lambda_u246 = new BufferedSinkJsonWriter((BufferedSink)buffer$iv, indent$iv);
            boolean bl = false;
            FileUploadAwareJsonWriter uploadAwareWriter = new FileUploadAwareJsonWriter($this$composeGetParams_u24lambda_u246);
            JsonWriter $this$writeObject$iv = uploadAwareWriter;
            boolean $i$f$writeObject = false;
            $this$writeObject$iv.beginObject();
            JsonWriter $this$composeGetParams_u24lambda_u246_u24lambda_u244 = $this$writeObject$iv;
            boolean bl2 = false;
            operation.serializeVariables($this$composeGetParams_u24lambda_u246_u24lambda_u244, customScalarAdapters);
            $this$writeObject$iv.endObject();
            if (!uploadAwareWriter.collectedUploads().isEmpty()) {
                boolean $i$a$-check-DefaultHttpRequestComposer$Companion$composeGetParams$variables$1$32 = false;
                String $i$a$-check-DefaultHttpRequestComposer$Companion$composeGetParams$variables$1$32 = "FileUpload and Http GET are not supported at the same time";
                throw new IllegalStateException($i$a$-check-DefaultHttpRequestComposer$Companion$composeGetParams$variables$1$32.toString());
            }
            String variables = buffer$iv.readUtf8();
            queryParams.put("variables", variables);
            if (sendDocument) {
                queryParams.put("query", operation.document());
            }
            if (autoPersistQueries) {
                String indent$iv2 = null;
                boolean $i$f$buildJsonString2 = false;
                Buffer buffer$iv2 = new Buffer();
                JsonWriter $this$composeGetParams_u24lambda_u249 = new BufferedSinkJsonWriter((BufferedSink)buffer$iv2, indent$iv2);
                boolean bl3 = false;
                $this$writeObject$iv = $this$composeGetParams_u24lambda_u249;
                $i$f$writeObject = false;
                $this$writeObject$iv.beginObject();
                JsonWriter $this$composeGetParams_u24lambda_u249_u24lambda_u248 = $this$writeObject$iv;
                boolean bl4 = false;
                $this$composeGetParams_u24lambda_u249_u24lambda_u248.name("persistedQuery");
                JsonWriter $this$writeObject$iv2 = $this$composeGetParams_u24lambda_u249_u24lambda_u248;
                boolean $i$f$writeObject2 = false;
                $this$writeObject$iv2.beginObject();
                JsonWriter $this$composeGetParams_u24lambda_u249_u24lambda_u248_u24lambda_u247 = $this$writeObject$iv2;
                boolean bl5 = false;
                $this$composeGetParams_u24lambda_u249_u24lambda_u248_u24lambda_u247.name("version").value(1);
                $this$composeGetParams_u24lambda_u249_u24lambda_u248_u24lambda_u247.name("sha256Hash").value(operation.id());
                $this$writeObject$iv2.endObject();
                $this$writeObject$iv.endObject();
                String extensions = buffer$iv2.readUtf8();
                queryParams.put("extensions", extensions);
            }
            return queryParams;
        }

        @NotNull
        public final String appendQueryParameters(@NotNull String $this$appendQueryParameters, @NotNull Map<String, String> parameters) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)$this$appendQueryParameters, (String)"<this>");
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            StringBuilder $this$appendQueryParameters_u24lambda_u2411 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$appendQueryParameters_u24lambda_u2411.append($this$appendQueryParameters);
            boolean hasQuestionMark = false;
            hasQuestionMark = StringsKt.contains$default((CharSequence)$this$appendQueryParameters, (CharSequence)"?", (boolean)false, (int)2, null);
            Iterable $this$forEach$iv = parameters.entrySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl2 = false;
                if (hasQuestionMark) {
                    $this$appendQueryParameters_u24lambda_u2411.append('&');
                } else {
                    hasQuestionMark = true;
                    $this$appendQueryParameters_u24lambda_u2411.append('?');
                }
                $this$appendQueryParameters_u24lambda_u2411.append(UrlEncodeKt.urlEncode((String)it.getKey()));
                $this$appendQueryParameters_u24lambda_u2411.append('=');
                $this$appendQueryParameters_u24lambda_u2411.append(UrlEncodeKt.urlEncode((String)it.getValue()));
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        @NotNull
        public final <D extends Operation.Data> HttpBody buildPostBody(@NotNull Operation<D> operation, @NotNull CustomScalarAdapters customScalarAdapters, boolean autoPersistQueries, @Nullable String query) {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
            Map uploads = null;
            String indent$iv = null;
            boolean $i$f$buildJsonByteString = false;
            Buffer buffer$iv = new Buffer();
            JsonWriter $this$buildPostBody_u24lambda_u2412 = new BufferedSinkJsonWriter((BufferedSink)buffer$iv, indent$iv);
            boolean bl = false;
            uploads = Companion.composePostParams($this$buildPostBody_u24lambda_u2412, operation, customScalarAdapters, autoPersistQueries, query);
            ByteString operationByteString = buffer$iv.readByteString();
            if (uploads.isEmpty()) {
                return new HttpBody(operationByteString){
                    @NotNull
                    private final String contentType;
                    private final long contentLength;
                    final /* synthetic */ ByteString $operationByteString;
                    {
                        this.$operationByteString = $operationByteString;
                        this.contentType = "application/json";
                        this.contentLength = $operationByteString.size();
                    }

                    @NotNull
                    public String getContentType() {
                        return this.contentType;
                    }

                    public long getContentLength() {
                        return this.contentLength;
                    }

                    public void writeTo(@NotNull BufferedSink bufferedSink) {
                        Intrinsics.checkNotNullParameter((Object)bufferedSink, (String)"bufferedSink");
                        bufferedSink.write(this.$operationByteString);
                    }
                };
            }
            return new UploadsHttpBody(uploads, operationByteString);
        }

        @NotNull
        public final <D extends Operation.Data> ByteString buildParamsMap(@NotNull Operation<D> operation, @NotNull CustomScalarAdapters customScalarAdapters, boolean autoPersistQueries, boolean sendDocument) {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
            String indent$iv = null;
            boolean $i$f$buildJsonByteString = false;
            Buffer buffer$iv = new Buffer();
            JsonWriter $this$buildParamsMap_u24lambda_u2413 = new BufferedSinkJsonWriter((BufferedSink)buffer$iv, indent$iv);
            boolean bl = false;
            String query = sendDocument ? operation.document() : null;
            Companion.composePostParams($this$buildParamsMap_u24lambda_u2413, operation, customScalarAdapters, autoPersistQueries, query);
            return buffer$iv.readByteString();
        }

        @NotNull
        public final <D extends Operation.Data> Map<String, Object> composePayload(@NotNull ApolloRequest<D> apolloRequest) {
            Intrinsics.checkNotNullParameter(apolloRequest, (String)"apolloRequest");
            Operation<D> operation = apolloRequest.getOperation();
            Boolean bl = apolloRequest.getSendApqExtensions();
            boolean sendApqExtensions = bl != null ? bl : false;
            Boolean bl2 = apolloRequest.getSendDocument();
            boolean sendDocument = bl2 != null ? bl2 : true;
            CustomScalarAdapters customScalarAdapters = (CustomScalarAdapters)apolloRequest.getExecutionContext().get(CustomScalarAdapters.Key);
            if (customScalarAdapters == null) {
                throw new IllegalStateException("Cannot find a ResponseAdapterCache".toString());
            }
            CustomScalarAdapters customScalarAdapters2 = customScalarAdapters;
            String query = sendDocument ? operation.document() : null;
            boolean $i$f$buildJsonMap = false;
            MapJsonWriter writer$iv = new MapJsonWriter();
            JsonWriter $this$composePayload_u24lambda_u2414 = writer$iv;
            boolean bl3 = false;
            Companion.composePostParams($this$composePayload_u24lambda_u2414, operation, customScalarAdapters2, sendApqExtensions, query);
            Object object = writer$iv.root();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            return (Map)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HttpMethod.values().length];
            try {
                nArray[HttpMethod.Get.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HttpMethod.Post.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

