/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.selenium.PathNodeValue;
import com.applitools.eyes.selenium.universal.dto.TargetPathLocatorDto;
import com.applitools.utils.GeneralUtils;
import java.lang.reflect.Field;
import org.openqa.selenium.By;
import org.openqa.selenium.support.pagefactory.ByAll;
import org.openqa.selenium.support.pagefactory.ByChained;

public class ElementSelector
extends TargetPathLocatorDto
implements PathNodeValue {
    private String type;
    private String selector;
    private ElementSelector fallback;
    private ElementSelector child;

    private ElementSelector() {
    }

    public ElementSelector(By by) {
        if (by instanceof ByAll) {
            this.populateFromByAll((ByAll)by);
        } else if (by instanceof ByChained) {
            this.populateFromByChained((ByChained)by);
        } else {
            ElementSelector clone = this.populateFromBy(by);
            this.selector = clone.getSelector();
            this.type = clone.getType();
        }
    }

    public ElementSelector(String selector) {
        this.type = "css selector";
        this.selector = selector;
    }

    private ElementSelector populateFromBy(By by) {
        String selector;
        ElementSelector es = new ElementSelector();
        es.selector = selector = GeneralUtils.getLastWordOfStringWithRegex((String)by.toString(), (String)":");
        if (by instanceof By.ById) {
            es.type = "css selector";
            es.selector = String.format("[id=\"%s\"]", selector);
        } else if (by instanceof By.ByXPath) {
            es.type = "xpath";
        } else if (by instanceof By.ByLinkText) {
            es.type = "link text";
        } else if (by instanceof By.ByPartialLinkText) {
            es.type = "partial link text";
        } else if (by instanceof By.ByName) {
            es.type = "css selector";
            es.selector = String.format("[name=\"%s\"]", selector);
        } else if (by instanceof By.ByTagName) {
            es.type = "css selector";
        } else if (by instanceof By.ByClassName) {
            es.type = "css selector";
            es.selector = ".".concat(selector);
        } else if (by instanceof By.ByCssSelector) {
            es.type = "css selector";
        }
        return es;
    }

    @Override
    public String getSelector() {
        return this.selector;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setSelector(String selector) {
        this.selector = selector;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    private void populateFromByAll(ByAll byAll) {
        try {
            Field bys_ = byAll.getClass().getDeclaredField("bys");
            bys_.setAccessible(true);
            By[] bys = (By[])bys_.get(byAll);
            ElementSelector fallback = null;
            for (int i = bys.length - 1; i >= 0; --i) {
                ElementSelector region = new ElementSelector(bys[i]);
                this.setSelector(region.getSelector());
                this.setType(region.getType());
                this.setFallback(fallback);
                fallback = region;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            System.out.println("Got a failure trying to find By[] using reflection! Error " + e.getMessage());
            throw new EyesException("Got a failure trying to find By[] using reflection! Error " + e.getMessage());
        }
    }

    @Override
    public ElementSelector getFallback() {
        return this.fallback;
    }

    public void setFallback(ElementSelector fallback) {
        this.fallback = fallback;
    }

    private void populateFromByChained(ByChained byChained) {
        try {
            Field bys_ = byChained.getClass().getDeclaredField("bys");
            bys_.setAccessible(true);
            By[] bys = (By[])bys_.get(byChained);
            ElementSelector child = null;
            for (int i = bys.length - 1; i >= 0; --i) {
                ElementSelector region = new ElementSelector(bys[i]);
                this.setSelector(region.getSelector());
                this.setType(region.getType());
                this.setChild(child);
                child = region;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            System.out.println("Got a failure trying to find By[] using reflection! Error " + e.getMessage());
            throw new EyesException("Got a failure trying to find By[] using reflection! Error " + e.getMessage());
        }
    }

    @Override
    public ElementSelector getChild() {
        return this.child;
    }

    public void setChild(ElementSelector child) {
        this.child = child;
    }
}

