/*
 * Decompiled with CFR 0.152.
 */
package com.apptasticsoftware.rssreader.filter;

import com.apptasticsoftware.rssreader.filter.FeedFilter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class InvalidXmlCharacterFilter
implements FeedFilter {
    @Override
    public InputStream filter(InputStream feedStream) {
        return new StreamingXmlFilterInputStream(feedStream);
    }

    private static class StreamingXmlFilterInputStream
    extends InputStream {
        private final Reader reader;
        private final Charset charset;
        private final ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream(1024);
        private byte[] buffer = new byte[0];
        private int bufferPos = 0;

        public StreamingXmlFilterInputStream(InputStream inputStream) {
            this(inputStream, StandardCharsets.UTF_8);
        }

        public StreamingXmlFilterInputStream(InputStream inputStream, Charset charset) {
            this.reader = new InputStreamReader(inputStream, charset);
            this.charset = charset;
        }

        @Override
        public int read() throws IOException {
            if (this.bufferPos >= this.buffer.length) {
                this.refillBuffer();
                if (this.buffer.length == 0) {
                    return -1;
                }
            }
            return this.buffer[this.bufferPos++] & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int bytesRead = 0;
            while (len > 0) {
                if (this.bufferPos >= this.buffer.length) {
                    this.refillBuffer();
                    if (this.buffer.length == 0) {
                        return bytesRead == 0 ? -1 : bytesRead;
                    }
                }
                int toCopy = Math.min(len, this.buffer.length - this.bufferPos);
                System.arraycopy(this.buffer, this.bufferPos, b, off, toCopy);
                this.bufferPos += toCopy;
                off += toCopy;
                len -= toCopy;
                bytesRead += toCopy;
            }
            return bytesRead;
        }

        private void refillBuffer() throws IOException {
            byte[] bytes;
            char ch;
            int c;
            this.byteBuffer.reset();
            while ((c = this.reader.read()) != -1) {
                ch = (char)c;
                if (!this.isValidXmlChar(ch)) continue;
                bytes = String.valueOf(ch).getBytes(this.charset);
                this.byteBuffer.write(bytes);
                break;
            }
            while ((c = this.reader.read()) != -1 && this.isValidXmlChar(ch = (char)c)) {
                bytes = String.valueOf(ch).getBytes(this.charset);
                this.byteBuffer.write(bytes);
            }
            this.buffer = this.byteBuffer.toByteArray();
            this.bufferPos = 0;
        }

        private boolean isValidXmlChar(char ch) {
            return ch == '\t' || ch == '\n' || ch == '\r' || ch >= ' ' && ch <= '\ud7ff' || ch >= '\ue000' && ch <= '\ufffd';
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }
}

