/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc.nonxa;

import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.StringHeuristicMessage;
import com.atomikos.jdbc.ConnectionPool;
import com.atomikos.jdbc.HeuristicDataSource;
import com.atomikos.jdbc.XPooledConnection;
import com.atomikos.jdbc.nonxa.NonXAConnectionFactory;
import com.atomikos.jdbc.nonxa.NonXADataSourceImpFactory;
import com.atomikos.jdbc.nonxa.NonXAPooledConnectionImp;
import com.atomikos.jdbc.nonxa.ThreadLocalConnection;
import java.io.PrintWriter;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.DataSource;

public class NonXADataSourceImp
implements HeuristicDataSource,
ConnectionEventListener,
Referenceable {
    private Map previousConnections;
    private ConnectionPool pool;
    private String jndiName;
    private static Map nameToDataSource_ = new HashMap();

    static NonXADataSourceImp getInstance(String name) {
        NonXADataSourceImp ret = (NonXADataSourceImp)nameToDataSource_.get(name);
        return ret;
    }

    private static synchronized void addToMap(String name, NonXADataSourceImp instance) throws SQLException {
        if (nameToDataSource_.get(name) != null) {
            throw new SQLException("DataSource for resource " + name + " already exists!");
        }
        nameToDataSource_.put(name, instance);
    }

    private static synchronized void removeFromMap(String name) {
        if (name != null && nameToDataSource_ != null) {
            nameToDataSource_.remove(name);
        }
    }

    public NonXADataSourceImp(DataSource driver, String jndiName, String user, String password, int poolSize, int connectionTimeout, String testQuery, boolean testOnBorrow) throws SQLException {
        this(driver, jndiName, user, password, poolSize, connectionTimeout, false, testQuery, testOnBorrow);
    }

    public NonXADataSourceImp(DataSource driver, String jndiName, String user, String password, int poolSize, int connectionTimeout, boolean validation, String testQuery, boolean testOnBorrow) throws SQLException {
        NonXAConnectionFactory factory = new NonXAConnectionFactory(driver, user, password);
        this.pool = new ConnectionPool(poolSize, factory, connectionTimeout, testQuery, testOnBorrow);
        this.previousConnections = new HashMap();
        this.jndiName = jndiName;
        if (!validation) {
            NonXADataSourceImp.addToMap(jndiName, this);
        }
    }

    public Connection getConnection(String msg) throws SQLException {
        StringHeuristicMessage hm = new StringHeuristicMessage(msg);
        return this.getConnection((HeuristicMessage)hm);
    }

    public Connection getConnection(String user, String passwd, String msg) throws SQLException {
        StringHeuristicMessage hm = new StringHeuristicMessage(msg);
        return this.getConnection(user, passwd, (HeuristicMessage)hm);
    }

    public synchronized Connection getConnection(HeuristicMessage msg) throws SQLException {
        Connection proxy = (Connection)this.previousConnections.get(Thread.currentThread());
        if (proxy == null) {
            NonXAPooledConnectionImp pc = (NonXAPooledConnectionImp)this.pool.getPooledConnection();
            pc.addConnectionEventListener(this);
            proxy = (Connection)ThreadLocalConnection.newInstance(pc);
            this.previousConnections.put(Thread.currentThread(), proxy);
        }
        ThreadLocalConnection previous = (ThreadLocalConnection)Proxy.getInvocationHandler(proxy);
        previous.incUseCount();
        previous.addHeuristicMessage(msg);
        return proxy;
    }

    public Connection getConnection(String user, String passwd, HeuristicMessage msg) throws SQLException {
        throw new SQLException("Not supported: getConnection with authentication.");
    }

    public Connection getConnection() throws SQLException {
        HeuristicMessage m = null;
        return this.getConnection(m);
    }

    public Connection getConnection(String user, String pw) throws SQLException {
        HeuristicMessage m = null;
        return this.getConnection(user, pw, m);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.pool.getLogWriter();
    }

    public void setLogWriter(PrintWriter pw) throws SQLException {
        this.pool.setLogWriter(pw);
    }

    public void setLoginTimeout(int val) throws SQLException {
        this.pool.setLoginTimeout(val);
    }

    public int getLoginTimeout() throws SQLException {
        return this.pool.getLoginTimeout();
    }

    public synchronized void connectionClosed(ConnectionEvent event) {
        XPooledConnection source = (XPooledConnection)event.getSource();
        Set values = this.previousConnections.entrySet();
        Iterator it = values.iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Connection c = (Connection)entry.getValue();
            ThreadLocalConnection tlc = (ThreadLocalConnection)Proxy.getInvocationHandler(c);
            if (!tlc.usesConnection(source)) continue;
            it.remove();
        }
        source.removeConnectionEventListener(this);
        this.pool.putBack(source);
    }

    public void connectionErrorOccurred(ConnectionEvent arg0) {
    }

    public void close() {
        this.pool.cleanup();
        NonXADataSourceImp.removeFromMap(this.jndiName);
    }

    public Reference getReference() throws NamingException {
        StringRefAddr ra = new StringRefAddr("ResourceName", this.jndiName);
        Reference ref = new Reference(this.getClass().getName(), new StringRefAddr("name", "NonXADataSourceImp"), NonXADataSourceImpFactory.class.getName(), null);
        ref.add(ra);
        return ref;
    }
}

