/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.reporter.configuration;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.reporter.ExtentSparkReporter;
import com.aventstack.extentreports.reporter.configuration.InteractiveReporterConfig;
import com.aventstack.extentreports.reporter.configuration.util.ResourceHelper;
import java.io.File;
import java.util.stream.Stream;
import lombok.Generated;

public class ExtentSparkReporterConfig
extends InteractiveReporterConfig {
    private static final String REPORTER_NAME = "spark";
    private static final String SEP = "/";
    private static final String COMMONS = "commons/";
    private static final String CSS = "css/";
    private static final String JS = "js/";
    private static final String ICONS = "icons/";
    private static final String IMG = "img/";
    private Boolean offlineMode;
    private Boolean thumbnailForBase64;
    private String resourceCDN;

    public void enableOfflineMode(Boolean offlineMode) {
        this.offlineMode = offlineMode;
        if (offlineMode.booleanValue() && this.reporter != null) {
            File f = Offline.getTargetDirectory(((ExtentSparkReporter)this.reporter).getFile());
            String resPackage = ExtentReports.class.getPackage().getName().replace(".", SEP);
            resPackage = resPackage + "/offline/";
            String[] resx = Offline.combineAll();
            ResourceHelper.saveOfflineResources(resPackage, resx, f.getAbsolutePath());
        }
    }

    @Generated
    private static Boolean $default$offlineMode() {
        return false;
    }

    @Generated
    private static Boolean $default$thumbnailForBase64() {
        return false;
    }

    @Generated
    private static String $default$resourceCDN() {
        return "github";
    }

    @Generated
    protected ExtentSparkReporterConfig(ExtentSparkReporterConfigBuilder<?, ?> b) {
        super((InteractiveReporterConfig.InteractiveReporterConfigBuilder<?, ?>)b);
        this.offlineMode = ((ExtentSparkReporterConfigBuilder)b).offlineMode$set ? ((ExtentSparkReporterConfigBuilder)b).offlineMode$value : ExtentSparkReporterConfig.$default$offlineMode();
        this.thumbnailForBase64 = ((ExtentSparkReporterConfigBuilder)b).thumbnailForBase64$set ? ((ExtentSparkReporterConfigBuilder)b).thumbnailForBase64$value : ExtentSparkReporterConfig.$default$thumbnailForBase64();
        this.resourceCDN = ((ExtentSparkReporterConfigBuilder)b).resourceCDN$set ? ((ExtentSparkReporterConfigBuilder)b).resourceCDN$value : ExtentSparkReporterConfig.$default$resourceCDN();
    }

    @Generated
    public static ExtentSparkReporterConfigBuilder<?, ?> builder() {
        return new ExtentSparkReporterConfigBuilderImpl();
    }

    @Generated
    public Boolean getOfflineMode() {
        return this.offlineMode;
    }

    @Generated
    public Boolean thumbnailForBase64() {
        return this.thumbnailForBase64;
    }

    @Generated
    public String getResourceCDN() {
        return this.resourceCDN;
    }

    @Generated
    public void setOfflineMode(Boolean offlineMode) {
        this.offlineMode = offlineMode;
    }

    @Generated
    public ExtentSparkReporterConfig thumbnailForBase64(Boolean thumbnailForBase64) {
        this.thumbnailForBase64 = thumbnailForBase64;
        return this;
    }

    @Generated
    public void setResourceCDN(String resourceCDN) {
        this.resourceCDN = resourceCDN;
    }

    @Generated
    private static final class ExtentSparkReporterConfigBuilderImpl
    extends ExtentSparkReporterConfigBuilder<ExtentSparkReporterConfig, ExtentSparkReporterConfigBuilderImpl> {
        @Generated
        private ExtentSparkReporterConfigBuilderImpl() {
        }

        @Override
        @Generated
        protected ExtentSparkReporterConfigBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ExtentSparkReporterConfig build() {
            return new ExtentSparkReporterConfig(this);
        }
    }

    @Generated
    public static abstract class ExtentSparkReporterConfigBuilder<C extends ExtentSparkReporterConfig, B extends ExtentSparkReporterConfigBuilder<C, B>>
    extends InteractiveReporterConfig.InteractiveReporterConfigBuilder<C, B> {
        @Generated
        private boolean offlineMode$set;
        @Generated
        private Boolean offlineMode$value;
        @Generated
        private boolean thumbnailForBase64$set;
        @Generated
        private Boolean thumbnailForBase64$value;
        @Generated
        private boolean resourceCDN$set;
        @Generated
        private String resourceCDN$value;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B offlineMode(Boolean offlineMode) {
            this.offlineMode$value = offlineMode;
            this.offlineMode$set = true;
            return (B)this.self();
        }

        @Generated
        public B thumbnailForBase64(Boolean thumbnailForBase64) {
            this.thumbnailForBase64$value = thumbnailForBase64;
            this.thumbnailForBase64$set = true;
            return (B)this.self();
        }

        @Generated
        public B resourceCDN(String resourceCDN) {
            this.resourceCDN$value = resourceCDN;
            this.resourceCDN$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "ExtentSparkReporterConfig.ExtentSparkReporterConfigBuilder(super=" + super.toString() + ", offlineMode$value=" + this.offlineMode$value + ", thumbnailForBase64$value=" + this.thumbnailForBase64$value + ", resourceCDN$value=" + this.resourceCDN$value + ")";
        }
    }

    private static class Offline {
        private Offline() {
        }

        private static File getTargetDirectory(File f) {
            String dir = f.getAbsolutePath().replace("\\", ExtentSparkReporterConfig.SEP);
            if (!f.isDirectory()) {
                dir = new File(dir).getParent();
            }
            dir = dir + "/spark";
            return new File(dir);
        }

        private static String[] combineAll() {
            return Offline.combine(Offline.getJSFiles(), Offline.getCSSFiles(), Offline.getIconFiles(), Offline.getImgFiles());
        }

        private static String[] combine(String[] ... array) {
            String[] result = new String[]{};
            for (String[] arr : array) {
                result = (String[])Stream.of(result, arr).flatMap(Stream::of).toArray(String[]::new);
            }
            return result;
        }

        private static String[] getJSFiles() {
            String commonsPath = "commons/js/";
            String reporterPath = "spark/js/";
            String[] files = new String[]{"spark/js/spark-script.js", "commons/js/jsontree.js"};
            return files;
        }

        private static String[] getCSSFiles() {
            String reporterPath = "spark/css/";
            String[] files = new String[]{"spark/css/spark-style.css"};
            return files;
        }

        private static String[] getIconFiles() {
            String path = "commons/css/icons/";
            String iconDirPath = "fontawesome/";
            String[] files = new String[]{"commons/css/icons/font-awesome.min.css", "commons/css/icons/fontawesome/fontawesome-webfont.eot", "commons/css/icons/fontawesome/fontawesome-webfont.svg", "commons/css/icons/fontawesome/fontawesome-webfont.ttf", "commons/css/icons/fontawesome/fontawesome-webfont.woff", "commons/css/icons/fontawesome/fontawesome-webfont.woff2", "commons/css/icons/fontawesome/FontAwesome.otf"};
            return files;
        }

        private static String[] getImgFiles() {
            String path = "commons/img/";
            String[] files = new String[]{"commons/img/logo.png"};
            return files;
        }
    }
}

