/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAIAgent;
import com.box.sdk.BoxAIAgentAsk;
import com.box.sdk.BoxAIAgentExtract;
import com.box.sdk.BoxAIAgentExtractStructured;
import com.box.sdk.BoxAIAgentTextGen;
import com.box.sdk.BoxAIDialogueEntry;
import com.box.sdk.BoxAIExtractField;
import com.box.sdk.BoxAIExtractMetadataTemplate;
import com.box.sdk.BoxAIExtractStructuredResponse;
import com.box.sdk.BoxAIItem;
import com.box.sdk.BoxAIResponse;
import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.box.sdk.http.HttpMethod;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.util.List;

public final class BoxAI {
    public static final URLTemplate SEND_AI_REQUEST_URL = new URLTemplate("ai/ask");
    public static final URLTemplate SEND_AI_TEXT_GEN_REQUEST_URL = new URLTemplate("ai/text_gen");
    public static final URLTemplate AI_AGENT_DEFAULT_CONFIG_URL = new URLTemplate("ai_agent_default");
    public static final URLTemplate EXTRACT_METADATA_FREEFORM_URL = new URLTemplate("ai/extract");
    public static final URLTemplate EXTRACT_METADATA_STRUCTURED_URL = new URLTemplate("ai/extract_structured");

    private BoxAI() {
    }

    public static BoxAIResponse sendAIRequest(BoxAPIConnection api, String prompt, List<BoxAIItem> items, Mode mode) {
        return BoxAI.sendAIRequest(api, prompt, items, mode, null, null, null);
    }

    public static BoxAIResponse sendAIRequest(BoxAPIConnection api, String prompt, List<BoxAIItem> items, Mode mode, List<BoxAIDialogueEntry> dialogueHistory, BoxAIAgentAsk agent, Boolean includeCitations) {
        URL url = SEND_AI_REQUEST_URL.build(api.getBaseURL(), new Object[0]);
        JsonObject requestJSON = new JsonObject();
        requestJSON.add("mode", mode.toString());
        requestJSON.add("prompt", prompt);
        JsonArray itemsJSON = new JsonArray();
        for (BoxAIItem boxAIItem : items) {
            itemsJSON.add((JsonValue)boxAIItem.getJSONObject());
        }
        requestJSON.add("items", (JsonValue)itemsJSON);
        if (dialogueHistory != null) {
            JsonArray dialogueHistoryJSON = new JsonArray();
            for (BoxAIDialogueEntry dialogueEntry : dialogueHistory) {
                dialogueHistoryJSON.add((JsonValue)dialogueEntry.getJSONObject());
            }
            requestJSON.add("dialogue_history", (JsonValue)dialogueHistoryJSON);
        }
        if (agent != null) {
            requestJSON.add("ai_agent", (JsonValue)agent.getJSONObject());
        }
        if (includeCitations != null) {
            requestJSON.add("include_citations", includeCitations.booleanValue());
        }
        BoxJSONRequest req = new BoxJSONRequest(api, url, HttpMethod.POST);
        req.setBody(requestJSON.toString());
        try (BoxJSONResponse boxJSONResponse = req.send();){
            JsonObject responseJSON = Json.parse((String)boxJSONResponse.getJSON()).asObject();
            BoxAIResponse boxAIResponse = new BoxAIResponse(responseJSON);
            return boxAIResponse;
        }
    }

    public static BoxAIResponse sendAITextGenRequest(BoxAPIConnection api, String prompt, List<BoxAIItem> items) {
        return BoxAI.sendAITextGenRequest(api, prompt, items, null);
    }

    public static BoxAIResponse sendAITextGenRequest(BoxAPIConnection api, String prompt, List<BoxAIItem> items, List<BoxAIDialogueEntry> dialogueHistory) {
        return BoxAI.sendAITextGenRequest(api, prompt, items, dialogueHistory, null);
    }

    public static BoxAIResponse sendAITextGenRequest(BoxAPIConnection api, String prompt, List<BoxAIItem> items, List<BoxAIDialogueEntry> dialogueHistory, BoxAIAgentTextGen agent) {
        URL url = SEND_AI_TEXT_GEN_REQUEST_URL.build(api.getBaseURL(), new Object[0]);
        JsonObject requestJSON = new JsonObject();
        requestJSON.add("prompt", prompt);
        JsonArray itemsJSON = new JsonArray();
        for (BoxAIItem boxAIItem : items) {
            itemsJSON.add((JsonValue)boxAIItem.getJSONObject());
        }
        requestJSON.add("items", (JsonValue)itemsJSON);
        if (dialogueHistory != null) {
            JsonArray dialogueHistoryJSON = new JsonArray();
            for (BoxAIDialogueEntry dialogueEntry : dialogueHistory) {
                dialogueHistoryJSON.add((JsonValue)dialogueEntry.getJSONObject());
            }
            requestJSON.add("dialogue_history", (JsonValue)dialogueHistoryJSON);
        }
        if (agent != null) {
            requestJSON.add("ai_agent", (JsonValue)agent.getJSONObject());
        }
        BoxJSONRequest req = new BoxJSONRequest(api, url, HttpMethod.POST);
        req.setBody(requestJSON.toString());
        try (BoxJSONResponse boxJSONResponse = req.send();){
            JsonObject responseJSON = Json.parse((String)boxJSONResponse.getJSON()).asObject();
            BoxAIResponse boxAIResponse = new BoxAIResponse(responseJSON);
            return boxAIResponse;
        }
    }

    public static BoxAIAgent getAiAgentDefaultConfig(BoxAPIConnection api, BoxAIAgent.Mode mode) {
        return BoxAI.getAiAgentDefaultConfig(api, mode, null, null);
    }

    public static BoxAIAgent getAiAgentDefaultConfig(BoxAPIConnection api, BoxAIAgent.Mode mode, String language, String model) {
        QueryStringBuilder builder = new QueryStringBuilder();
        builder.appendParam("mode", mode.toString());
        if (language != null) {
            builder.appendParam("language", language);
        }
        if (model != null) {
            builder.appendParam("model", model);
        }
        URL url = AI_AGENT_DEFAULT_CONFIG_URL.buildWithQuery(api.getBaseURL(), builder.toString(), new Object[0]);
        BoxAPIRequest req = new BoxAPIRequest(api, url, HttpMethod.GET);
        try (BoxJSONResponse response = (BoxJSONResponse)req.send();){
            JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
            BoxAIAgent boxAIAgent = BoxAIAgent.parse(responseJSON);
            return boxAIAgent;
        }
    }

    public static BoxAIResponse extractMetadataFreeform(BoxAPIConnection api, String prompt, List<BoxAIItem> items) {
        return BoxAI.extractMetadataFreeform(api, prompt, items, null);
    }

    public static BoxAIResponse extractMetadataFreeform(BoxAPIConnection api, String prompt, List<BoxAIItem> items, BoxAIAgentExtract agent) {
        URL url = EXTRACT_METADATA_FREEFORM_URL.build(api.getBaseURL(), new Object[0]);
        JsonObject requestJSON = new JsonObject();
        JsonArray itemsJSON = new JsonArray();
        for (BoxAIItem item : items) {
            itemsJSON.add((JsonValue)item.getJSONObject());
        }
        requestJSON.add("items", (JsonValue)itemsJSON);
        requestJSON.add("prompt", prompt);
        if (agent != null) {
            requestJSON.add("ai_agent", (JsonValue)agent.getJSONObject());
        }
        BoxJSONRequest req = new BoxJSONRequest(api, url, HttpMethod.POST);
        req.setBody(requestJSON.toString());
        try (BoxJSONResponse response = req.send();){
            JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
            BoxAIResponse boxAIResponse = new BoxAIResponse(responseJSON);
            return boxAIResponse;
        }
    }

    public static BoxAIExtractStructuredResponse extractMetadataStructured(BoxAPIConnection api, List<BoxAIItem> items, BoxAIExtractMetadataTemplate template) {
        return BoxAI.extractMetadataStructured(api, items, template, null, null);
    }

    public static BoxAIExtractStructuredResponse extractMetadataStructured(BoxAPIConnection api, List<BoxAIItem> items, BoxAIExtractMetadataTemplate template, BoxAIAgentExtractStructured agent) {
        return BoxAI.extractMetadataStructured(api, items, template, null, agent);
    }

    public static BoxAIExtractStructuredResponse extractMetadataStructured(BoxAPIConnection api, List<BoxAIItem> items, List<BoxAIExtractField> fields) {
        return BoxAI.extractMetadataStructured(api, items, null, fields, null);
    }

    public static BoxAIExtractStructuredResponse extractMetadataStructured(BoxAPIConnection api, List<BoxAIItem> items, List<BoxAIExtractField> fields, BoxAIAgentExtractStructured agent) {
        return BoxAI.extractMetadataStructured(api, items, null, fields, agent);
    }

    private static BoxAIExtractStructuredResponse extractMetadataStructured(BoxAPIConnection api, List<BoxAIItem> items, BoxAIExtractMetadataTemplate template, List<BoxAIExtractField> fields, BoxAIAgentExtractStructured agent) {
        URL url = EXTRACT_METADATA_STRUCTURED_URL.build(api.getBaseURL(), new Object[0]);
        JsonObject requestJSON = new JsonObject();
        JsonArray itemsJSON = new JsonArray();
        for (BoxAIItem boxAIItem : items) {
            itemsJSON.add((JsonValue)boxAIItem.getJSONObject());
        }
        requestJSON.add("items", (JsonValue)itemsJSON);
        if (template != null) {
            requestJSON.add("metadata_template", (JsonValue)template.getJSONObject());
        }
        if (fields != null) {
            JsonArray fieldsJSON = new JsonArray();
            for (BoxAIExtractField field : fields) {
                fieldsJSON.add((JsonValue)field.getJSONObject());
            }
            requestJSON.add("fields", (JsonValue)fieldsJSON);
        }
        if (agent != null) {
            requestJSON.add("ai_agent", (JsonValue)agent.getJSONObject());
        }
        BoxJSONRequest req = new BoxJSONRequest(api, url, HttpMethod.POST);
        req.setBody(requestJSON.toString());
        try (BoxJSONResponse boxJSONResponse = req.send();){
            BoxAIExtractStructuredResponse boxAIExtractStructuredResponse = new BoxAIExtractStructuredResponse(boxJSONResponse.getJSON());
            return boxAIExtractStructuredResponse;
        }
    }

    public static enum Mode {
        MULTIPLE_ITEM_QA("multiple_item_qa"),
        SINGLE_ITEM_QA("single_item_qa");

        private final String mode;

        private Mode(String mode) {
            this.mode = mode;
        }

        static Mode fromJSONValue(String jsonValue) {
            if (jsonValue.equals("multiple_item_qa")) {
                return MULTIPLE_ITEM_QA;
            }
            if (jsonValue.equals("single_item_qa")) {
                return SINGLE_ITEM_QA;
            }
            System.out.print("Invalid AI mode.");
            return null;
        }

        String toJSONValue() {
            return this.mode;
        }

        public String toString() {
            return this.mode;
        }
    }
}

