/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util;

import com.cloudhopper.commons.util.HexUtil;
import com.cloudhopper.commons.util.SubstitutionException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;

public class StringUtil {
    private static final String PRINTABLE = ": ~`!@#$%^&*()-_+=/\\,.[]{}|?<>\"'";
    private static final String SAFE = ":~!@#$%^&*()-_+=/\\,.[]{}|?<>";
    private static final String[][] XML_CHARS = new String[][]{{"&", "&amp;"}, {"<", "&lt;"}, {">", "&gt;"}, {"\"", "&quot;"}, {"'", "&apos;"}, {"\n", "&#10;"}, {"\r", "&#13;"}};
    public static char[] HEX_TABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String substituteWithEnvironment(String string0) throws SubstitutionException {
        Properties envProps = new Properties();
        envProps.putAll(System.getenv());
        return StringUtil.substituteWithProperties(string0, "$ENV{", "}", envProps);
    }

    public static String substituteWithProperties(String string0, String startStr, String endStr, Properties properties) throws SubstitutionException {
        if (string0 == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(string0.length());
        int end = -1;
        int pos = string0.indexOf(startStr);
        while (pos >= 0) {
            if (pos > end + 1) {
                result.append(string0.substring(end + 1, pos));
            }
            if ((end = string0.indexOf(endStr, pos + startStr.length())) < 0) {
                throw new SubstitutionException("End of substitution pattern '" + endStr + "' not found [@position=" + pos + "]");
            }
            String key = string0.substring(pos + startStr.length(), end);
            if (key == null || key.equals("")) {
                throw new SubstitutionException("Property key was empty in string with an occurrence of '" + startStr + endStr + "' [@position=" + pos + "]");
            }
            String value = properties.getProperty(key);
            if (value == null) {
                throw new SubstitutionException("A property value for '" + startStr + key + endStr + "' was not found (property missing?)");
            }
            result.append(value);
            pos = string0.indexOf(startStr, end + 1);
        }
        if (end + 1 < string0.length()) {
            result.append(string0.substring(end + 1));
        }
        return result.toString();
    }

    public static boolean isSafeString(String string0) {
        for (int i = 0; i < string0.length(); ++i) {
            if (StringUtil.isSafeChar(string0.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isSafeChar(char ch) {
        if (ch >= 'a' && ch <= 'z') {
            return true;
        }
        if (ch >= 'A' && ch <= 'Z') {
            return true;
        }
        if (ch >= '0' && ch <= '9') {
            return true;
        }
        for (int i = 0; i < SAFE.length(); ++i) {
            if (ch != SAFE.charAt(i)) continue;
            return true;
        }
        return false;
    }

    public static String capitalize(String string0) {
        if (string0 == null) {
            return null;
        }
        int length = string0.length();
        if (length == 0) {
            return string0;
        }
        if (length == 1) {
            return string0.toUpperCase();
        }
        StringBuilder buf = new StringBuilder(length);
        buf.append(string0.substring(0, 1).toUpperCase());
        buf.append(string0.substring(1));
        return buf.toString();
    }

    public static String uncapitalize(String string0) {
        if (string0 == null) {
            return null;
        }
        int length = string0.length();
        if (length == 0) {
            return string0;
        }
        if (length == 1) {
            return string0.toLowerCase();
        }
        StringBuilder buf = new StringBuilder(length);
        buf.append(string0.substring(0, 1).toLowerCase());
        buf.append(string0.substring(1));
        return buf.toString();
    }

    public static boolean contains(String[] strings, String targetString) {
        return StringUtil.indexOf(strings, targetString) != -1;
    }

    public static int indexOf(String[] strings, String targetString) {
        if (strings == null) {
            return -1;
        }
        for (int i = 0; i < strings.length; ++i) {
            if (!(strings[i] == null ? targetString == null : targetString != null && strings[i].equals(targetString))) continue;
            return i;
        }
        return -1;
    }

    public static String stripQuotes(String string0) {
        if (string0.length() == 0) {
            return string0;
        }
        if (string0.length() > 1 && string0.charAt(0) == '\"' && string0.charAt(string0.length() - 1) == '\"') {
            return string0.substring(1, string0.length() - 1);
        }
        if (string0.charAt(0) == '\"') {
            string0 = string0.substring(1);
        } else if (string0.charAt(string0.length() - 1) == '\"') {
            string0 = string0.substring(0, string0.length() - 1);
        }
        return string0;
    }

    public static boolean containsOnlyDigits(String string0) {
        for (int i = 0; i < string0.length(); ++i) {
            if (Character.isDigit(string0.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String[] split(String str, char delim) {
        if (str == null) {
            throw new NullPointerException("str can't be null");
        }
        StringTokenizer st = new StringTokenizer(str, String.valueOf(delim));
        int n = st.countTokens();
        String[] s = new String[n];
        for (int i = 0; i < n; ++i) {
            s[i] = st.nextToken();
        }
        return s;
    }

    public static final String formatForPrint(String input) {
        if (input.length() > 60) {
            StringBuffer tmp = new StringBuffer(input.substring(0, 60));
            tmp.append("&");
            input = tmp.toString();
        }
        return input;
    }

    public static String[] toStringArray(Object[] objArray) {
        int len = objArray.length;
        String[] strArray = new String[len];
        for (int idx = 0; idx < len; ++idx) {
            strArray[idx] = objArray[idx].toString();
        }
        return strArray;
    }

    public static byte[] getAsciiBytes(String input) {
        char[] c = input.toCharArray();
        byte[] b = new byte[c.length];
        for (int i = 0; i < c.length; ++i) {
            b[i] = (byte)(c[i] & 0x7F);
        }
        return b;
    }

    public static String getAsciiString(byte[] input) {
        StringBuffer buf = new StringBuffer(input.length);
        for (byte b : input) {
            buf.append((char)b);
        }
        return buf.toString();
    }

    public static String trimTrailing(String str) {
        int len;
        if (str == null) {
            return null;
        }
        for (len = str.length(); len > 0 && Character.isWhitespace(str.charAt(len - 1)); --len) {
        }
        return str.substring(0, len);
    }

    public static String truncate(String value, int length) {
        if (value != null && value.length() > length) {
            value = value.substring(0, length);
        }
        return value;
    }

    public static String slice(String value, int beginOffset, int endOffset, boolean trim) {
        String retval = value.substring(beginOffset, endOffset + 1);
        if (trim) {
            retval = retval.trim();
        }
        return retval;
    }

    @Deprecated
    public static String toHexString(byte[] bytes) {
        return HexUtil.toHexString(bytes);
    }

    @Deprecated
    public static String toHexString(byte[] bytes, int offset, int length) {
        return HexUtil.toHexString(bytes, offset, length);
    }

    @Deprecated
    public static byte[] toHexByte(String hexString, int offset, int length) {
        return HexUtil.toByteArray(hexString, offset, length);
    }

    @Deprecated
    public static byte[] fromHexString(String hexString) {
        return HexUtil.toByteArray(hexString);
    }

    @Deprecated
    public static byte[] fromHexString(String hexString, int offset, int length) {
        return HexUtil.toByteArray(hexString, offset, length);
    }

    public static boolean isPrintableChar(char ch) {
        if (ch >= 'a' && ch <= 'z') {
            return true;
        }
        if (ch >= 'A' && ch <= 'Z') {
            return true;
        }
        if (ch >= '0' && ch <= '9') {
            return true;
        }
        for (int i = 0; i < PRINTABLE.length(); ++i) {
            if (ch != PRINTABLE.charAt(i)) continue;
            return true;
        }
        return false;
    }

    public static String hexDump(String prefix, byte[] data) {
        StringBuffer str = new StringBuffer(data.length * 3);
        str.append(prefix);
        for (int i = 0; i < data.length; i += 16) {
            int j;
            String offset = Integer.toHexString(i);
            str.append("  ");
            for (int offlen = offset.length(); offlen < 8; ++offlen) {
                str.append("0");
            }
            str.append(offset);
            str.append(":");
            for (j = 0; j < 16 && i + j < data.length; ++j) {
                byte byte_value = data[i + j];
                if (j % 2 == 0) {
                    str.append(" ");
                }
                byte high_nibble = (byte)((byte_value & 0xF0) >>> 4);
                byte low_nibble = (byte)(byte_value & 0xF);
                str.append(HEX_TABLE[high_nibble]);
                str.append(HEX_TABLE[low_nibble]);
            }
            if (i + 16 > data.length) {
                int last_row_byte_count = data.length % 16;
                int num_bytes_short = 16 - last_row_byte_count;
                int num_spaces = num_bytes_short * 2 + (7 - last_row_byte_count / 2);
                for (int v = 0; v < num_spaces; ++v) {
                    str.append(" ");
                }
            }
            str.append("  ");
            for (j = 0; j < 16 && i + j < data.length; ++j) {
                char char_value = (char)data[i + j];
                if (StringUtil.isPrintableChar(char_value)) {
                    str.append(String.valueOf(char_value));
                    continue;
                }
                str.append(".");
            }
            str.append("\n");
        }
        str.deleteCharAt(str.length() - 1);
        return str.toString();
    }

    public static String SQLToUpperCase(String s) {
        return s.toUpperCase(Locale.ENGLISH);
    }

    public static boolean SQLEqualsIgnoreCase(String s1, String s2) {
        if (s2 == null) {
            return false;
        }
        return StringUtil.SQLToUpperCase(s1).equals(StringUtil.SQLToUpperCase(s2));
    }

    public static String normalizeSQLIdentifier(String id) {
        if (id.length() == 0) {
            return id;
        }
        if (id.charAt(0) == '\"' && id.length() >= 3 && id.charAt(id.length() - 1) == '\"') {
            return StringUtil.compressQuotes(id.substring(1, id.length() - 1), "\"\"");
        }
        return StringUtil.SQLToUpperCase(id);
    }

    public static String compressQuotes(String source, String quotes) {
        String result = source;
        int index = result.indexOf(quotes);
        while (index != -1) {
            result = result.substring(0, index + 1) + result.substring(index + 2);
            index = result.indexOf(quotes, index + 1);
        }
        return result;
    }

    static String quoteString(String source, char quote) {
        StringBuffer quoted = new StringBuffer(source.length() + 2);
        quoted.append(quote);
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (c == quote) {
                quoted.append(quote);
            }
            quoted.append(c);
        }
        quoted.append(quote);
        return quoted.toString();
    }

    public static String quoteStringLiteral(String string) {
        return StringUtil.quoteString(string, '\'');
    }

    public static String stringify(int[] raw) {
        if (raw == null) {
            return "null";
        }
        StringBuffer buffer = new StringBuffer();
        int count = raw.length;
        buffer.append("[ ");
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(raw[i]);
        }
        buffer.append(" ]");
        return buffer.toString();
    }

    public static boolean isEmpty(String string0) {
        return string0 == null || string0.length() == 0;
    }

    public static boolean isEqual(String string0, String string1) {
        return StringUtil.isEqual(string0, string1, true);
    }

    public static String toStringWithNullAsEmpty(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    public static String toStringWithNullAsReplaced(Object obj) {
        if (obj == null) {
            return "<NULL>";
        }
        return obj.toString();
    }

    public static String toStringWithNullAsNull(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    public static boolean isEqual(String string0, String string1, boolean caseSensitive) {
        if (string0 == null && string1 == null) {
            return true;
        }
        if (string0 == null && string1 != null) {
            return false;
        }
        if (string0 != null && string1 == null) {
            return false;
        }
        if (caseSensitive) {
            return string0.equals(string1);
        }
        return string0.equalsIgnoreCase(string1);
    }

    public static String readToString(InputStream in) throws IOException {
        int n;
        StringBuilder out = new StringBuilder();
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }

    public static String escapeXml(String value) {
        if (value == null) {
            return null;
        }
        int len = value.length();
        StringBuilder buf = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            boolean entityFound = false;
            for (int j = 0; j < XML_CHARS.length; ++j) {
                if (c != XML_CHARS[j][0].charAt(0)) continue;
                buf.append(XML_CHARS[j][1]);
                entityFound = true;
            }
            if (entityFound) continue;
            buf.append(c);
        }
        return buf.toString();
    }

    public static String removeAllCharsExceptDigits(String str0) {
        if (str0 == null) {
            return null;
        }
        if (str0.length() == 0) {
            return str0;
        }
        StringBuilder buf = new StringBuilder(str0.length());
        int length = str0.length();
        for (int i = 0; i < length; ++i) {
            char c = str0.charAt(i);
            if (!Character.isDigit(c)) continue;
            buf.append(c);
        }
        return buf.toString();
    }
}

