/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.api;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.security.SecureRandom;

public final class Jazzer {
    private static final Class<?> JAZZER_INTERNAL;
    private static final MethodHandle ON_FUZZ_TARGET_READY;
    private static final MethodHandle TRACE_STRCMP;
    private static final MethodHandle TRACE_STRSTR;
    private static final MethodHandle TRACE_MEMCMP;
    private static final MethodHandle TRACE_PC_INDIR;
    public static final int SEED;

    private Jazzer() {
    }

    public static void guideTowardsEquality(String current, String target, int id) {
        if (TRACE_STRCMP == null) {
            return;
        }
        try {
            TRACE_STRCMP.invokeExact(current, target, 1, id);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void guideTowardsEquality(byte[] current, byte[] target, int id) {
        if (TRACE_MEMCMP == null) {
            return;
        }
        try {
            TRACE_MEMCMP.invokeExact(current, target, 1, id);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void guideTowardsContainment(String haystack, String needle, int id) {
        if (TRACE_STRSTR == null) {
            return;
        }
        try {
            TRACE_STRSTR.invokeExact(haystack, needle, id);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void exploreState(byte state, int id) {
        if (TRACE_PC_INDIR == null) {
            return;
        }
        int lowerBits = state & 0x7F | id << 7;
        int upperBits = id >>> 5;
        try {
            TRACE_PC_INDIR.invokeExact(upperBits, lowerBits);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void reportFindingFromHook(Throwable finding) {
        try {
            JAZZER_INTERNAL.getMethod("reportFindingFromHook", Throwable.class).invoke(null, finding);
        }
        catch (IllegalAccessException | NoSuchMethodException | NullPointerException e) {
            Jazzer.rethrowUnchecked(finding);
        }
        catch (InvocationTargetException e) {
            Jazzer.rethrowUnchecked(e.getCause());
        }
    }

    public static void onFuzzTargetReady(Runnable callback) {
        try {
            ON_FUZZ_TARGET_READY.invokeExact(callback);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static int getLibFuzzerSeed() {
        String rawSeed = System.getProperty("jazzer.internal.seed");
        if (rawSeed == null) {
            return new SecureRandom().nextInt();
        }
        return Integer.parseUnsignedInt(rawSeed);
    }

    private static <T extends Throwable> void rethrowUnchecked(Throwable t) throws T {
        throw t;
    }

    static {
        Class<?> jazzerInternal = null;
        MethodHandle onFuzzTargetReady = null;
        MethodHandle traceStrcmp = null;
        MethodHandle traceStrstr = null;
        MethodHandle traceMemcmp = null;
        MethodHandle tracePcIndir = null;
        try {
            jazzerInternal = Class.forName("com.code_intelligence.jazzer.runtime.JazzerInternal");
            MethodType onFuzzTargetReadyType = MethodType.methodType(Void.TYPE, Runnable.class);
            onFuzzTargetReady = MethodHandles.publicLookup().findStatic(jazzerInternal, "registerOnFuzzTargetReadyCallback", onFuzzTargetReadyType);
            Class<?> traceDataFlowNativeCallbacks = Class.forName("com.code_intelligence.jazzer.runtime.TraceDataFlowNativeCallbacks");
            MethodType traceStrcmpType = MethodType.methodType(Void.TYPE, String.class, String.class, Integer.TYPE, Integer.TYPE);
            traceStrcmp = MethodHandles.publicLookup().findStatic(traceDataFlowNativeCallbacks, "traceStrcmp", traceStrcmpType);
            MethodType traceStrstrType = MethodType.methodType(Void.TYPE, String.class, String.class, Integer.TYPE);
            traceStrstr = MethodHandles.publicLookup().findStatic(traceDataFlowNativeCallbacks, "traceStrstr", traceStrstrType);
            MethodType traceMemcmpType = MethodType.methodType(Void.TYPE, byte[].class, byte[].class, Integer.TYPE, Integer.TYPE);
            traceMemcmp = MethodHandles.publicLookup().findStatic(traceDataFlowNativeCallbacks, "traceMemcmp", traceMemcmpType);
            MethodType tracePcIndirType = MethodType.methodType(Void.TYPE, Integer.TYPE, Integer.TYPE);
            tracePcIndir = MethodHandles.publicLookup().findStatic(traceDataFlowNativeCallbacks, "tracePcIndir", tracePcIndirType);
        }
        catch (ClassNotFoundException onFuzzTargetReadyType) {
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            System.err.println("ERROR: Incompatible version of the Jazzer API detected, please update.");
            e.printStackTrace();
            System.exit(1);
        }
        JAZZER_INTERNAL = jazzerInternal;
        ON_FUZZ_TARGET_READY = onFuzzTargetReady;
        TRACE_STRCMP = traceStrcmp;
        TRACE_STRSTR = traceStrstr;
        TRACE_MEMCMP = traceMemcmp;
        TRACE_PC_INDIR = tracePcIndir;
        SEED = Jazzer.getLibFuzzerSeed();
    }
}

