/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.spark.xml.util;

import com.databricks.spark.xml.XmlOptions;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scala.util.control.Exception$;

public final class TypeCast$ {
    public static TypeCast$ MODULE$;

    static {
        new TypeCast$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object castTo(String datum, DataType castType, XmlOptions options, boolean nullable) {
        Object object;
        DataType dataType;
        String string = datum;
        String string2 = options.nullValue();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            if (nullable) return null;
        }
        if (options.treatEmptyValuesAsNulls()) {
            String string3 = datum;
            String string4 = "";
            if (string3 == null) {
                if (string4 == null) return null;
            } else if (string3.equals(string4)) {
                return null;
            }
        }
        if ((dataType = castType) instanceof ByteType) {
            object = BoxesRunTime.boxToByte((byte)new StringOps(Predef$.MODULE$.augmentString(datum)).toByte());
        } else if (dataType instanceof ShortType) {
            object = BoxesRunTime.boxToShort((short)new StringOps(Predef$.MODULE$.augmentString(datum)).toShort());
        } else if (dataType instanceof IntegerType) {
            object = BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(datum)).toInt());
        } else if (dataType instanceof LongType) {
            object = BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(datum)).toLong());
        } else if (dataType instanceof FloatType) {
            object = Try$.MODULE$.apply((Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(datum)).toFloat()).getOrElse((Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> NumberFormat.getInstance(Locale.getDefault()).parse(datum).floatValue());
        } else if (dataType instanceof DoubleType) {
            object = Try$.MODULE$.apply((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(datum)).toDouble()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> NumberFormat.getInstance(Locale.getDefault()).parse(datum).doubleValue());
        } else if (dataType instanceof BooleanType) {
            object = BoxesRunTime.boxToBoolean((boolean)this.parseXmlBoolean(datum));
        } else if (dataType instanceof DecimalType) {
            object = new BigDecimal(datum.replaceAll(",", ""));
        } else if (dataType instanceof TimestampType) {
            object = Timestamp.valueOf(datum);
        } else if (dataType instanceof DateType) {
            object = Date.valueOf(datum);
        } else {
            if (!(dataType instanceof StringType)) throw new IllegalArgumentException(new StringBuilder(18).append("Unsupported type: ").append(castType.typeName()).toString());
            object = datum;
        }
        Byte by = object;
        return by;
    }

    public boolean castTo$default$4() {
        return true;
    }

    private boolean parseXmlBoolean(String s) {
        boolean bl;
        String string = s.toLowerCase();
        if ("true".equals(string)) {
            bl = true;
        } else if ("false".equals(string)) {
            bl = false;
        } else if ("1".equals(string)) {
            bl = true;
        } else if ("0".equals(string)) {
            bl = false;
        } else {
            throw new IllegalArgumentException(new StringBuilder(18).append("For input string: ").append(s).toString());
        }
        return bl;
    }

    public Object convertTo(String datum, DataType dataType, XmlOptions options) {
        Object object;
        String value = datum != null && options.ignoreSurroundingSpaces() ? datum.trim() : datum;
        DataType dataType2 = dataType;
        if (NullType$.MODULE$.equals(dataType2)) {
            object = this.castTo(value, (DataType)StringType$.MODULE$, options, this.castTo$default$4());
        } else if (LongType$.MODULE$.equals(dataType2)) {
            object = BoxesRunTime.boxToLong((long)this.signSafeToLong(value, options));
        } else if (DoubleType$.MODULE$.equals(dataType2)) {
            object = BoxesRunTime.boxToDouble((double)this.signSafeToDouble(value, options));
        } else if (BooleanType$.MODULE$.equals(dataType2)) {
            object = this.castTo(value, (DataType)BooleanType$.MODULE$, options, this.castTo$default$4());
        } else if (StringType$.MODULE$.equals(dataType2)) {
            object = this.castTo(value, (DataType)StringType$.MODULE$, options, this.castTo$default$4());
        } else if (DateType$.MODULE$.equals(dataType2)) {
            object = this.castTo(value, (DataType)DateType$.MODULE$, options, this.castTo$default$4());
        } else if (TimestampType$.MODULE$.equals(dataType2)) {
            object = this.castTo(value, (DataType)TimestampType$.MODULE$, options, this.castTo$default$4());
        } else if (FloatType$.MODULE$.equals(dataType2)) {
            object = BoxesRunTime.boxToFloat((float)this.signSafeToFloat(value, options));
        } else if (ByteType$.MODULE$.equals(dataType2)) {
            object = this.castTo(value, (DataType)ByteType$.MODULE$, options, this.castTo$default$4());
        } else if (ShortType$.MODULE$.equals(dataType2)) {
            object = this.castTo(value, (DataType)ShortType$.MODULE$, options, this.castTo$default$4());
        } else if (IntegerType$.MODULE$.equals(dataType2)) {
            object = BoxesRunTime.boxToInteger((int)this.signSafeToInt(value, options));
        } else if (dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            object = this.castTo(value, (DataType)decimalType, options, this.castTo$default$4());
        } else {
            throw new IllegalArgumentException(new StringBuilder(39).append("Failed to parse a value for data type ").append(dataType).append(".").toString());
        }
        return object;
    }

    public boolean isBoolean(String value) {
        String string = value.toLowerCase();
        boolean bl = "true".equals(string) ? true : "false".equals(string);
        boolean bl2 = bl;
        return bl2;
    }

    public boolean isDouble(String value) {
        String signSafeValue = value.startsWith("+") || value.startsWith("-") ? value.substring(1) : value;
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(signSafeValue)).toDouble()).isDefined();
    }

    public boolean isInteger(String value) {
        String signSafeValue = value.startsWith("+") || value.startsWith("-") ? value.substring(1) : value;
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(signSafeValue)).toInt()).isDefined();
    }

    public boolean isLong(String value) {
        String signSafeValue = value.startsWith("+") || value.startsWith("-") ? value.substring(1) : value;
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(signSafeValue)).toLong()).isDefined();
    }

    public boolean isTimestamp(String value) {
        return Exception$.MODULE$.allCatch().opt((Function0 & Serializable & scala.Serializable)() -> Timestamp.valueOf(value)).isDefined();
    }

    public long signSafeToLong(String value, XmlOptions options) {
        long l;
        if (value.startsWith("+")) {
            String data = value.substring(1);
            l = BoxesRunTime.unboxToLong((Object)this.castTo(data, (DataType)LongType$.MODULE$, options, this.castTo$default$4()));
        } else if (value.startsWith("-")) {
            String data = value.substring(1);
            l = -BoxesRunTime.unboxToLong((Object)this.castTo(data, (DataType)LongType$.MODULE$, options, this.castTo$default$4()));
        } else {
            String data = value;
            l = BoxesRunTime.unboxToLong((Object)this.castTo(data, (DataType)LongType$.MODULE$, options, this.castTo$default$4()));
        }
        return l;
    }

    public double signSafeToDouble(String value, XmlOptions options) {
        double d;
        if (value.startsWith("+")) {
            String data = value.substring(1);
            d = BoxesRunTime.unboxToDouble((Object)this.castTo(data, (DataType)DoubleType$.MODULE$, options, this.castTo$default$4()));
        } else if (value.startsWith("-")) {
            String data = value.substring(1);
            d = -BoxesRunTime.unboxToDouble((Object)this.castTo(data, (DataType)DoubleType$.MODULE$, options, this.castTo$default$4()));
        } else {
            String data = value;
            d = BoxesRunTime.unboxToDouble((Object)this.castTo(data, (DataType)DoubleType$.MODULE$, options, this.castTo$default$4()));
        }
        return d;
    }

    public int signSafeToInt(String value, XmlOptions options) {
        int n;
        if (value.startsWith("+")) {
            String data = value.substring(1);
            n = BoxesRunTime.unboxToInt((Object)this.castTo(data, (DataType)IntegerType$.MODULE$, options, this.castTo$default$4()));
        } else if (value.startsWith("-")) {
            String data = value.substring(1);
            n = -BoxesRunTime.unboxToInt((Object)this.castTo(data, (DataType)IntegerType$.MODULE$, options, this.castTo$default$4()));
        } else {
            String data = value;
            n = BoxesRunTime.unboxToInt((Object)this.castTo(data, (DataType)IntegerType$.MODULE$, options, this.castTo$default$4()));
        }
        return n;
    }

    public float signSafeToFloat(String value, XmlOptions options) {
        float f;
        if (value.startsWith("+")) {
            String data = value.substring(1);
            f = BoxesRunTime.unboxToFloat((Object)this.castTo(data, (DataType)FloatType$.MODULE$, options, this.castTo$default$4()));
        } else if (value.startsWith("-")) {
            String data = value.substring(1);
            f = -BoxesRunTime.unboxToFloat((Object)this.castTo(data, (DataType)FloatType$.MODULE$, options, this.castTo$default$4()));
        } else {
            String data = value;
            f = BoxesRunTime.unboxToFloat((Object)this.castTo(data, (DataType)FloatType$.MODULE$, options, this.castTo$default$4()));
        }
        return f;
    }

    private TypeCast$() {
        MODULE$ = this;
    }
}

