/*
 * Decompiled with CFR 0.152.
 */
package com.dbdeploy;

import com.dbdeploy.AppliedChangesProvider;
import com.dbdeploy.AvailableChangeScriptsProvider;
import com.dbdeploy.ChangeScriptApplier;
import com.dbdeploy.PrettyPrinter;
import com.dbdeploy.exceptions.DbDeployException;
import com.dbdeploy.scripts.ChangeScript;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Controller {
    private final AvailableChangeScriptsProvider availableChangeScriptsProvider;
    private final AppliedChangesProvider appliedChangesProvider;
    private final ChangeScriptApplier changeScriptApplier;
    private final ChangeScriptApplier undoScriptApplier;
    private final PrettyPrinter prettyPrinter = new PrettyPrinter();

    public Controller(AvailableChangeScriptsProvider availableChangeScriptsProvider, AppliedChangesProvider appliedChangesProvider, ChangeScriptApplier changeScriptApplier, ChangeScriptApplier undoScriptApplier) {
        this.availableChangeScriptsProvider = availableChangeScriptsProvider;
        this.appliedChangesProvider = appliedChangesProvider;
        this.changeScriptApplier = changeScriptApplier;
        this.undoScriptApplier = undoScriptApplier;
    }

    public void processChangeScripts(Long lastChangeToApply) throws DbDeployException, IOException {
        if (lastChangeToApply != Long.MAX_VALUE) {
            this.info("Only applying changes up and including change script #" + lastChangeToApply);
        }
        List<ChangeScript> scripts = this.availableChangeScriptsProvider.getAvailableChangeScripts();
        List<Long> applied = this.appliedChangesProvider.getAppliedChanges();
        List<ChangeScript> toApply = this.identifyChangesToApply(lastChangeToApply, scripts, applied);
        this.logStatus(scripts, applied, toApply);
        this.changeScriptApplier.apply(Collections.unmodifiableList(toApply));
        if (this.undoScriptApplier != null) {
            this.info("Generating undo scripts...");
            Collections.reverse(toApply);
            this.undoScriptApplier.apply(Collections.unmodifiableList(toApply));
        }
    }

    private void logStatus(List<ChangeScript> scripts, List<Long> applied, List<ChangeScript> toApply) {
        this.info("Changes currently applied to database:\n  " + this.prettyPrinter.format(applied));
        this.info("Scripts available:\n  " + this.prettyPrinter.formatChangeScriptList(scripts));
        this.info("To be applied:\n  " + this.prettyPrinter.formatChangeScriptList(toApply));
    }

    private List<ChangeScript> identifyChangesToApply(Long lastChangeToApply, List<ChangeScript> scripts, List<Long> applied) {
        ArrayList<ChangeScript> result = new ArrayList<ChangeScript>();
        for (ChangeScript script : scripts) {
            if (script.getId() > lastChangeToApply) break;
            if (applied.contains(script.getId())) continue;
            result.add(script);
        }
        return result;
    }

    private void info(String string) {
        System.err.println(string);
    }
}

