/*
 * Decompiled with CFR 0.152.
 */
package com.dbdeploy.scripts;

import com.dbdeploy.exceptions.UnrecognisedFilenameException;
import com.dbdeploy.scripts.ChangeScript;
import com.dbdeploy.scripts.FilenameParser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryScanner {
    private final FilenameParser filenameParser = new FilenameParser();
    private final String encoding;

    public DirectoryScanner(String encoding) {
        this.encoding = encoding;
    }

    public List<ChangeScript> getChangeScriptsForDirectory(File directory) {
        try {
            System.err.println("Reading change scripts from directory " + directory.getCanonicalPath() + "...");
        }
        catch (IOException e1) {
            // empty catch block
        }
        ArrayList<ChangeScript> scripts = new ArrayList<ChangeScript>();
        for (File file : directory.listFiles()) {
            if (!file.isFile()) continue;
            String filename = file.getName();
            try {
                long id = this.filenameParser.extractIdFromFilename(filename);
                scripts.add(new ChangeScript(id, file, this.encoding));
            }
            catch (UnrecognisedFilenameException e) {
                // empty catch block
            }
        }
        return scripts;
    }
}

