/*
 * Decompiled with CFR 0.152.
 */
package com.dbdeploy.database.changelog;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class QueryExecuter {
    private final Connection connection;
    private final String username;

    public QueryExecuter(String connectionString, String username, String password) throws SQLException {
        this.username = username;
        this.connection = DriverManager.getConnection(connectionString, username, password);
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        Statement statement = this.connection.createStatement();
        return statement.executeQuery(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String sql) throws SQLException {
        Statement statement = this.connection.createStatement();
        try {
            statement.execute(sql);
        }
        finally {
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String sql, Object ... params) throws SQLException {
        PreparedStatement statement = this.connection.prepareStatement(sql);
        try {
            for (int i = 0; i < params.length; ++i) {
                Object param = params[i];
                statement.setObject(i + 1, param);
            }
            statement.execute();
        }
        finally {
            statement.close();
        }
    }

    public void close() throws SQLException {
        this.connection.close();
    }

    public void setAutoCommit(boolean autoCommitMode) throws SQLException {
        this.connection.setAutoCommit(autoCommitMode);
    }

    public void commit() throws SQLException {
        this.connection.commit();
    }

    public String getDatabaseUsername() {
        return this.username;
    }
}

