/*
 * Decompiled with CFR 0.152.
 */
package com.dbdeploy.scripts;

import com.dbdeploy.exceptions.UsageException;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ChangeScriptCreator {
    private String changeScriptSuffix = ".sql";
    private String changeScriptTimestampFormat = "yyyyMMddHHmmss";
    private String scriptDescription;
    private File scriptDirectory;
    private DateFormat dateFormatter = new SimpleDateFormat(this.changeScriptTimestampFormat);

    public File go() throws IOException {
        this.validate();
        return this.createScript();
    }

    private void validate() {
        if (this.scriptDirectory == null || !this.scriptDirectory.isDirectory()) {
            throw new UsageException("Script directory must point to a valid directory");
        }
    }

    public File createScript() throws IOException {
        String newScriptFileName = this.getChangeScriptFileName();
        String fullScriptPath = this.scriptDirectory + File.separator + newScriptFileName;
        File newChangeScriptFile = new File(fullScriptPath);
        if (newChangeScriptFile.createNewFile()) {
            return newChangeScriptFile;
        }
        throw new IOException("Unable to create new change script " + fullScriptPath);
    }

    private String getChangeScriptFileName() {
        StringBuilder fileNameBuilder = new StringBuilder();
        fileNameBuilder.append(this.getFileTimestamp());
        if (this.scriptDescription != null && !this.scriptDescription.equals("")) {
            fileNameBuilder.append("_");
            fileNameBuilder.append(this.scriptDescription);
        }
        fileNameBuilder.append(this.changeScriptSuffix);
        return fileNameBuilder.toString();
    }

    private String getFileTimestamp() {
        return this.dateFormatter.format(new Date());
    }

    public void setScriptDescription(String scriptDescription) {
        this.scriptDescription = scriptDescription;
    }

    public void setScriptDirectory(File scriptDirectory) {
        this.scriptDirectory = scriptDirectory;
    }

    public static void main(String[] args) {
        ChangeScriptCreator creator = new ChangeScriptCreator();
        try {
            ChangeScriptCreator.parseArguments(args, creator);
            creator.go();
        }
        catch (UsageException ex) {
            System.err.println("ERROR: " + ex.getMessage());
            System.err.println("Usage: java " + creator.getClass().getName() + " scriptDirectory [scriptName]");
        }
        catch (Exception ex) {
            System.err.println("Failed to create script: " + ex);
            ex.printStackTrace();
            System.exit(2);
        }
        System.exit(0);
    }

    private static void parseArguments(String[] args, ChangeScriptCreator creator) {
        if (args.length >= 1) {
            String scriptDirectoryPath = args[0];
            creator.setScriptDirectory(new File(scriptDirectoryPath));
        }
        if (args.length >= 2) {
            String scriptDescription = args[1];
            creator.setScriptDescription(scriptDescription);
        }
    }
}

