/*
 * Decompiled with CFR 0.152.
 */
package com.dbdeploy.scripts;

import com.dbdeploy.AvailableChangeScriptsProvider;
import com.dbdeploy.exceptions.DuplicateChangeScriptException;
import com.dbdeploy.scripts.ChangeScript;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeScriptRepository
implements AvailableChangeScriptsProvider {
    private final List<ChangeScript> scripts;

    public ChangeScriptRepository(List<ChangeScript> scripts) throws DuplicateChangeScriptException {
        this.scripts = scripts;
        Collections.sort(this.scripts);
        this.checkForDuplicateIds(scripts);
    }

    private void checkForDuplicateIds(List<ChangeScript> scripts) throws DuplicateChangeScriptException {
        long lastId = -1L;
        for (ChangeScript script : scripts) {
            if (script.getId() == lastId) {
                throw new DuplicateChangeScriptException("There is more than one change script with number " + lastId);
            }
            lastId = script.getId();
        }
    }

    public List<ChangeScript> getOrderedListOfDoChangeScripts() {
        return Collections.unmodifiableList(this.scripts);
    }

    @Override
    public List<ChangeScript> getAvailableChangeScripts() {
        return this.getOrderedListOfDoChangeScripts();
    }
}

