/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.glue.jdt;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;

class JdtFlags {
    static final int VISIBILITY_CODE_INVALID = -1;

    JdtFlags() {
    }

    static boolean isStatic(BodyDeclaration bodyDeclaration) {
        if (JdtFlags.isNestedInterfaceOrAnnotation(bodyDeclaration)) {
            return true;
        }
        int nodeType = bodyDeclaration.getNodeType();
        if (nodeType != 31 && nodeType != 82 && JdtFlags.isInterfaceOrAnnotationMember(bodyDeclaration)) {
            return true;
        }
        if (bodyDeclaration instanceof EnumConstantDeclaration) {
            return true;
        }
        if (bodyDeclaration instanceof EnumDeclaration && bodyDeclaration.getParent() instanceof AbstractTypeDeclaration) {
            return true;
        }
        return Modifier.isStatic((int)bodyDeclaration.getModifiers());
    }

    private static boolean isPackageVisible(BodyDeclaration bodyDeclaration) {
        return !JdtFlags.isPrivate(bodyDeclaration) && !JdtFlags.isProtected(bodyDeclaration) && !JdtFlags.isPublic(bodyDeclaration);
    }

    private static boolean isPrivate(BodyDeclaration bodyDeclaration) {
        return Modifier.isPrivate((int)bodyDeclaration.getModifiers());
    }

    private static boolean isProtected(BodyDeclaration bodyDeclaration) {
        return Modifier.isProtected((int)bodyDeclaration.getModifiers());
    }

    private static boolean isPublic(BodyDeclaration bodyDeclaration) {
        if (JdtFlags.isInterfaceOrAnnotationMember(bodyDeclaration)) {
            return true;
        }
        return Modifier.isPublic((int)bodyDeclaration.getModifiers());
    }

    private static boolean isInterfaceOrAnnotationMember(BodyDeclaration bodyDeclaration) {
        return JdtFlags.isInterfaceOrAnnotation(bodyDeclaration.getParent());
    }

    private static boolean isInterfaceOrAnnotation(ASTNode node) {
        boolean isInterface = node instanceof TypeDeclaration && ((TypeDeclaration)node).isInterface();
        boolean isAnnotation = node instanceof AnnotationTypeDeclaration;
        return isInterface || isAnnotation;
    }

    private static boolean isNestedInterfaceOrAnnotation(BodyDeclaration bodyDeclaration) {
        return bodyDeclaration.getParent() instanceof AbstractTypeDeclaration && JdtFlags.isInterfaceOrAnnotation((ASTNode)bodyDeclaration);
    }

    static int getVisibilityCode(BodyDeclaration bodyDeclaration) {
        if (JdtFlags.isPublic(bodyDeclaration)) {
            return 1;
        }
        if (JdtFlags.isProtected(bodyDeclaration)) {
            return 4;
        }
        if (JdtFlags.isPackageVisible(bodyDeclaration)) {
            return 0;
        }
        if (JdtFlags.isPrivate(bodyDeclaration)) {
            return 2;
        }
        Assert.isTrue((boolean)false);
        return -1;
    }
}

