/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.generic;

import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.LineEnding;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PipeStepPair {
    final FormatterStep in;
    final FormatterStep out;

    public static Builder named(String name) {
        return new Builder(name);
    }

    public static String defaultToggleName() {
        return "toggle";
    }

    public static String defaultToggleOff() {
        return "spotless:off";
    }

    public static String defaultToggleOn() {
        return "spotless:on";
    }

    private PipeStepPair(String name, Pattern pattern) {
        StateIn stateIn = new StateIn(pattern);
        StateOut stateOut = new StateOut(stateIn);
        this.in = FormatterStep.create(name + "In", stateIn, state -> x$0 -> state.format(x$0));
        this.out = FormatterStep.create(name + "Out", stateOut, state -> x$0 -> state.format(x$0));
    }

    public FormatterStep in() {
        return this.in;
    }

    public FormatterStep out() {
        return this.out;
    }

    private static String stateOutCompute(StateIn in, StringBuilder builder, String unix) {
        if (in.groups.isEmpty()) {
            return unix;
        }
        builder.setLength(0);
        Matcher matcher = in.regex.matcher(unix);
        int lastEnd = 0;
        int groupIdx = 0;
        while (matcher.find()) {
            builder.append(unix, lastEnd, matcher.start(1));
            builder.append(in.groups.get(groupIdx));
            lastEnd = matcher.end(1);
            ++groupIdx;
        }
        if (groupIdx == in.groups.size()) {
            builder.append(unix, lastEnd, unix.length());
            return builder.toString();
        }
        Matcher openClose = Pattern.compile("\\\\Q([\\s\\S]*?)\\\\E\\Q([\\s\\S]*?)\\E\\\\Q([\\s\\S]*?)\\\\E").matcher(in.regex.pattern());
        Object pattern = openClose.matches() ? openClose.group(1) + " " + openClose.group(2) : in.regex.pattern();
        throw new Error("An intermediate step removed a match of " + (String)pattern);
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    static class StateOut
    implements Serializable {
        private static final long serialVersionUID = -1195263184715054229L;
        final StateIn in;
        final transient StringBuilder builder = new StringBuilder();

        StateOut(StateIn in) {
            this.in = Objects.requireNonNull(in);
        }

        private String format(String unix) {
            return PipeStepPair.stateOutCompute(this.in, this.builder, unix);
        }
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    static class StateIn
    implements Serializable {
        private static final long serialVersionUID = -844178006407733370L;
        final Pattern regex;
        final transient ArrayList<String> groups = new ArrayList();

        public StateIn(Pattern regex) {
            this.regex = Objects.requireNonNull(regex);
        }

        private String format(String unix) throws Exception {
            this.groups.clear();
            Matcher matcher = this.regex.matcher(unix);
            while (matcher.find()) {
                this.groups.add(matcher.group(1));
            }
            return unix;
        }
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    static class StateApplyToBlock
    extends StateIn
    implements Serializable {
        private static final long serialVersionUID = -844178006407733370L;
        final List<FormatterStep> steps;
        final transient StringBuilder builder = new StringBuilder();

        StateApplyToBlock(Pattern regex, Collection<? extends FormatterStep> steps) {
            super(regex);
            this.steps = new ArrayList<FormatterStep>(steps);
        }

        Formatter buildFormatter(Path rootDir) {
            return Formatter.builder().encoding(StandardCharsets.UTF_8).lineEndingsPolicy(LineEnding.UNIX.createPolicy()).steps(this.steps).rootDir(rootDir).build();
        }

        private String format(Formatter formatter, String unix, File file) throws Exception {
            this.groups.clear();
            Matcher matcher = this.regex.matcher(unix);
            while (matcher.find()) {
                this.groups.add(formatter.compute(matcher.group(1), file));
            }
            return PipeStepPair.stateOutCompute(this, this.builder, unix);
        }
    }

    public static class Builder {
        String name;
        Pattern regex;

        private Builder(String name) {
            this.name = Objects.requireNonNull(name);
        }

        public Builder openClose(String open, String close) {
            return this.regex(Pattern.quote(open) + "([\\s\\S]*?)" + Pattern.quote(close));
        }

        public Builder regex(String regex) {
            return this.regex(Pattern.compile(regex));
        }

        public Builder regex(Pattern regex) {
            this.regex = Objects.requireNonNull(regex);
            return this;
        }

        public PipeStepPair buildPair() {
            return new PipeStepPair(this.name, this.regex);
        }

        public FormatterStep buildStepWhichAppliesSubSteps(Path rootPath, Collection<? extends FormatterStep> steps) {
            return FormatterStep.createLazy(this.name, () -> new StateApplyToBlock(this.regex, steps), state -> FormatterFunc.Closeable.of(state.buildFormatter(rootPath), (x$0, x$1, x$2) -> state.format((Formatter)x$0, x$1, x$2)));
        }
    }
}

