/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.kotlin;

import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class KtLintStep {
    private static final String DEFAULT_VERSION = "1.1.1";
    private static final String NAME = "ktlint";
    private static final String MAVEN_COORDINATE_0_DOT = "com.pinterest:ktlint:";
    private static final String MAVEN_COORDINATE_1_DOT = "com.pinterest.ktlint:ktlint-cli:";

    private KtLintStep() {
    }

    public static FormatterStep create(Provisioner provisioner) {
        return KtLintStep.create(KtLintStep.defaultVersion(), provisioner);
    }

    public static FormatterStep create(String version, Provisioner provisioner) {
        return KtLintStep.create(version, provisioner, null, Collections.emptyMap(), Collections.emptyList());
    }

    public static FormatterStep create(String version, Provisioner provisioner, @Nullable FileSignature editorConfig, Map<String, Object> editorConfigOverride, List<String> customRuleSets) {
        Objects.requireNonNull(version, "version");
        Objects.requireNonNull(provisioner, "provisioner");
        return FormatterStep.createLazy(NAME, () -> new State(version, provisioner, editorConfig, editorConfigOverride, customRuleSets), State::createFormat);
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    private static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final JarState jarState;
        private final TreeMap<String, Object> editorConfigOverride;
        private final String version;
        @Nullable
        private final FileSignature editorConfigPath;

        State(String version, Provisioner provisioner, @Nullable FileSignature editorConfigPath, Map<String, Object> editorConfigOverride, List<String> customRuleSets) throws IOException {
            this.version = version;
            this.editorConfigOverride = new TreeMap<String, Object>(editorConfigOverride);
            String ktlintCoordinate = (version.startsWith("0.") ? KtLintStep.MAVEN_COORDINATE_0_DOT : KtLintStep.MAVEN_COORDINATE_1_DOT) + version;
            HashSet<String> mavenCoordinates = new HashSet<String>(customRuleSets);
            mavenCoordinates.add(ktlintCoordinate);
            this.jarState = JarState.from(mavenCoordinates, provisioner);
            this.editorConfigPath = editorConfigPath;
        }

        FormatterFunc createFormat() throws Exception {
            ClassLoader classLoader = this.jarState.getClassLoader();
            Class<?> formatterFunc = classLoader.loadClass("com.diffplug.spotless.glue.ktlint.KtlintFormatterFunc");
            Constructor<?> constructor = formatterFunc.getConstructor(String.class, FileSignature.class, Map.class);
            return (FormatterFunc.NeedsFile)constructor.newInstance(this.version, this.editorConfigPath, this.editorConfigOverride);
        }
    }
}

