/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

class ListableAdapter<T>
implements Iterable<T> {
    private final List<T> delegate;

    private ListableAdapter(Object delegate) {
        Objects.requireNonNull(delegate);
        if (!ListableAdapter.canAdapt(delegate)) {
            throw new IllegalArgumentException("Cannot create ListableAdapter from " + delegate.getClass() + ". Use canAdapt() to check first.");
        }
        if (delegate instanceof List) {
            this.delegate = (List)delegate;
        } else if (delegate.getClass().isArray()) {
            this.delegate = Arrays.asList((Object[])delegate);
        } else {
            throw new IllegalArgumentException("Cannot create IterableAdapter from " + delegate.getClass());
        }
    }

    static <T> Iterable<T> adapt(Object delegate) {
        return new ListableAdapter<T>(delegate);
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    static boolean canAdapt(Object delegate) {
        Objects.requireNonNull(delegate);
        return delegate instanceof List || delegate.getClass().isArray();
    }
}

