/*
 * Decompiled with CFR 0.152.
 */
package com.edb.jdbc;

import com.edb.Driver;
import com.edb.core.ParameterList;
import com.edb.core.Query;
import com.edb.core.v3.SimpleParameterList;
import com.edb.jdbc.BatchResultHandler;
import com.edb.jdbc.BooleanTypeUtil;
import com.edb.jdbc.CallableBatchResultHandler;
import com.edb.jdbc.PgConnection;
import com.edb.jdbc.PgPreparedStatement;
import com.edb.jdbc.TypeInfoCache;
import com.edb.util.GT;
import com.edb.util.PSQLException;
import com.edb.util.PSQLState;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.index.qual.Positive;
import org.checkerframework.checker.nullness.qual.Nullable;

class PgCallableStatement
extends PgPreparedStatement
implements CallableStatement {
    private static final String NAMED_PARAMETER_INDICATOR = "=>";
    public final int DB_SPECIFIC_COMPTABILE_CURSOR = -10;
    private final boolean isFunction;
    private final List<String> namedParameters = new ArrayList<String>();
    private final int namedParameterCount = 0;
    protected @Nullable Object @Nullable [] callResult;
    private int @Nullable [] functionReturnType;
    private int @Nullable [] testReturn;
    private boolean returnTypeSet;
    private int lastIndex = 0;
    private boolean atLeastOneNamedParameter = false;

    PgCallableStatement(PgConnection connection, String sql, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        super(connection, connection.borrowCallableQuery(sql), true, rsType, rsConcurrency, rsHoldability);
        this.isFunction = this.preparedQuery.isFunction;
        this.outParmBeforeFunc = this.preparedQuery.outParmBeforeFunc;
        this.isCallable = this.preparedQuery.isCallable;
        this.parseNamedParameters(sql);
        if (this.isFunction) {
            int inParamCount = this.preparedParameters.getInParameterCount() + 1;
            this.testReturn = new int[inParamCount];
            this.functionReturnType = new int[inParamCount];
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.isFunction) {
            this.executeWithFlags(0);
            return 0;
        }
        return super.executeUpdate();
    }

    @Override
    public @Nullable Object getObject(@Positive int i, @Nullable Map<String, Class<?>> map) throws SQLException {
        return this.getObjectImpl(i, map);
    }

    @Override
    public @Nullable Object getObject(String s, @Nullable Map<String, Class<?>> map) throws SQLException {
        return this.getObjectImpl(s, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeWithFlags(int flags) throws SQLException {
        PgCallableStatement pgCallableStatement = this;
        synchronized (pgCallableStatement) {
            int outParameterCount;
            boolean hasResultSet = super.executeWithFlags(flags);
            if (!this.isFunction || !this.returnTypeSet) {
                return hasResultSet;
            }
            if (!hasResultSet) {
                throw new PSQLException(GT.tr("A CallableStatement was executed with nothing returned.", new Object[0]), PSQLState.NO_DATA);
            }
            this.checkClosed();
            ResultSet rs = this.result.getResultSet();
            if (!rs.next()) {
                throw new PSQLException(GT.tr("A CallableStatement was executed with nothing returned.", new Object[0]), PSQLState.NO_DATA);
            }
            int cols = rs.getMetaData().getColumnCount();
            if (cols != (outParameterCount = this.preparedParameters.getOutParameterCount())) {
                throw new PSQLException(GT.tr("A CallableStatement was executed with an invalid number of parameters", new Object[0]), PSQLState.SYNTAX_ERROR);
            }
            this.lastIndex = 0;
            this.callResult = new Object[this.preparedParameters.getParameterCount() + 1];
            int i = 0;
            int j = 0;
            while (i < cols) {
                while (j < this.functionReturnType.length && this.functionReturnType[j] == 0) {
                    ++j;
                }
                this.callResult[j] = rs.getObject(i + 1);
                int columnType = rs.getMetaData().getColumnType(i + 1);
                String typeName = rs.getMetaData().getColumnTypeName(i + 1);
                String registeredTypeName = null;
                if (this.preparedParameters instanceof SimpleParameterList) {
                    int paramIndex = j + 1;
                    registeredTypeName = this.isFunction ? (--paramIndex > 0 ? ((SimpleParameterList)this.preparedParameters).getOutParameterTypeName(paramIndex) : ((SimpleParameterList)this.preparedParameters).getReturnTypeName()) : ((SimpleParameterList)this.preparedParameters).getOutParameterTypeName(paramIndex);
                }
                if (columnType != 0 && columnType != this.functionReturnType[j]) {
                    if (columnType == 8 && this.functionReturnType[j] == 7) {
                        if (this.callResult[j] != null) {
                            this.callResult[j] = Float.valueOf(((Double)this.callResult[j]).floatValue());
                        }
                    } else if (!(columnType == 2001 && this.functionReturnType[j] == 2006 || columnType == 1111 && this.functionReturnType[j] == 2006 || columnType == 2012 && this.functionReturnType[j] == 1111 || columnType == 2012 && this.functionReturnType[j] == 2006)) {
                        throw new PSQLException(GT.tr("A CallableStatement function was executed and the out parameter {0} was of type {1} however type {2} was registered.", i + 1, "java.sql.Types=" + columnType, "java.sql.Types=" + this.functionReturnType[j]), PSQLState.DATA_TYPE_MISMATCH);
                    }
                }
                if (registeredTypeName != null && typeName != null && !TypeInfoCache.compareTypeNames(registeredTypeName, typeName)) {
                    throw new PSQLException(GT.tr("A CallableStatement function was executed and the return type name was {0} however type name {1} was registered for index {2}.", typeName, registeredTypeName, "" + i), PSQLState.DATA_TYPE_MISMATCH);
                }
                ++i;
                ++j;
            }
            rs.close();
            this.result = null;
        }
        return false;
    }

    public void registerOutParameter(@Positive int parameterIndex, int sqlType, boolean setPreparedParameters) throws SQLException {
        this.checkClosed();
        switch (sqlType) {
            case -6: {
                sqlType = 5;
                break;
            }
            case -1: {
                sqlType = 12;
                break;
            }
            case 3: {
                sqlType = 2;
                break;
            }
            case 6: {
                sqlType = 8;
                break;
            }
            case -4: 
            case -3: {
                sqlType = -2;
                break;
            }
        }
        if (!this.isFunction) {
            throw new PSQLException(GT.tr("This statement does not declare an OUT parameter.  Use '{' ?= call ... '}' to declare one.", new Object[0]), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        this.checkIndex(parameterIndex, false);
        Integer oid = this.connection.getTypeInfo().getOid(new Integer(sqlType));
        if (setPreparedParameters || this.isCallable) {
            this.preparedParameters.registerOutParameter(parameterIndex, oid);
        }
        this.functionReturnType[parameterIndex - 1] = sqlType;
        this.testReturn[parameterIndex - 1] = sqlType;
        if (this.functionReturnType[parameterIndex - 1] == 1 || this.functionReturnType[parameterIndex - 1] == -1) {
            this.testReturn[parameterIndex - 1] = 12;
        } else if (this.functionReturnType[parameterIndex - 1] == 6) {
            this.testReturn[parameterIndex - 1] = 7;
        }
        this.returnTypeSet = true;
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale, boolean setPreparedParameters) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType, setPreparedParameters);
    }

    public void registerOutParameter(int parameterIndex, int sqlType, String typeName, boolean setPreparedParameters) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType, setPreparedParameters);
        if (this.preparedParameters instanceof SimpleParameterList) {
            int pIndex = parameterIndex;
            if (this.isFunction) {
                --pIndex;
            }
            if (pIndex > 0) {
                ((SimpleParameterList)this.preparedParameters).setOutParameterTypeName(pIndex, typeName);
            } else {
                ((SimpleParameterList)this.preparedParameters).setReturnTypeName(typeName);
            }
        } else {
            throw Driver.notImplemented(this.getClass(), "registerOutParameter(int, int, String)");
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (this.lastIndex == 0) {
            throw new PSQLException(GT.tr("wasNull cannot be call before fetching a result.", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
        }
        return this.callResult[this.lastIndex - 1] == null;
    }

    @Override
    public @Nullable String getString(@Positive int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 12, "String");
        return (String)this.callResult[parameterIndex - 1];
    }

    @Override
    public boolean getBoolean(@Positive int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, -7, "Boolean");
        if (this.callResult[parameterIndex - 1] == null) {
            return false;
        }
        return BooleanTypeUtil.castToBoolean(this.callResult[parameterIndex - 1]);
    }

    @Override
    public byte getByte(@Positive int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 5, "Byte");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0;
        }
        return ((Integer)this.callResult[parameterIndex - 1]).byteValue();
    }

    @Override
    public short getShort(@Positive int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 5, "Short");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0;
        }
        return ((Integer)this.callResult[parameterIndex - 1]).shortValue();
    }

    @Override
    public int getInt(@Positive int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 4, "Int");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0;
        }
        return (Integer)this.callResult[parameterIndex - 1];
    }

    @Override
    public long getLong(@Positive int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, -5, "Long");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0L;
        }
        return (Long)this.callResult[parameterIndex - 1];
    }

    @Override
    public float getFloat(@Positive int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 7, "Float");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0.0f;
        }
        return ((Float)this.callResult[parameterIndex - 1]).floatValue();
    }

    @Override
    public double getDouble(@Positive int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 8, "Double");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0.0;
        }
        return (Double)this.callResult[parameterIndex - 1];
    }

    @Override
    public @Nullable BigDecimal getBigDecimal(@Positive int parameterIndex, int scale) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 2, "BigDecimal");
        return (BigDecimal)this.callResult[parameterIndex - 1];
    }

    @Override
    public byte @Nullable [] getBytes(@Positive int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, -3, -2, "Bytes");
        return (byte[])this.callResult[parameterIndex - 1];
    }

    @Override
    public @Nullable Date getDate(@Positive int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 91, "Date");
        return (Date)this.callResult[parameterIndex - 1];
    }

    @Override
    public @Nullable Time getTime(@Positive int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 92, "Time");
        return (Time)this.callResult[parameterIndex - 1];
    }

    @Override
    public @Nullable Timestamp getTimestamp(@Positive int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 93, "Timestamp");
        return (Timestamp)this.callResult[parameterIndex - 1];
    }

    @Override
    public @Nullable Object getObject(@Positive int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex);
        return this.callResult[parameterIndex - 1];
    }

    protected void checkIndex(@Positive int parameterIndex, int type1, int type2, String getName) throws SQLException {
        this.checkIndex(parameterIndex);
        if (type1 != this.testReturn[parameterIndex - 1] && type2 != this.testReturn[parameterIndex - 1]) {
            throw new PSQLException(GT.tr("Parameter of type {0} was registered, but call to get{1} (sqltype={2}) was made.", "java.sql.Types=" + this.testReturn[parameterIndex - 1], getName, "java.sql.Types=" + type1), PSQLState.MOST_SPECIFIC_TYPE_DOES_NOT_MATCH);
        }
    }

    protected void checkIndex(@Positive int parameterIndex, int type, String getName) throws SQLException {
        this.checkIndex(parameterIndex);
        if (type != this.testReturn[parameterIndex - 1]) {
            throw new PSQLException(GT.tr("Parameter of type {0} was registered, but call to get{1} (sqltype={2}) was made.", "java.sql.Types=" + this.testReturn[parameterIndex - 1], getName, "java.sql.Types=" + type), PSQLState.MOST_SPECIFIC_TYPE_DOES_NOT_MATCH);
        }
    }

    private void checkIndex(@Positive int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, true);
    }

    private void checkIndex(int parameterIndex, boolean fetchingData) throws SQLException {
        if (!this.isFunction) {
            throw new PSQLException(GT.tr("A CallableStatement was declared, but no call to registerOutParameter(1, <some type>) was made.", new Object[0]), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        if (fetchingData) {
            if (!this.returnTypeSet) {
                throw new PSQLException(GT.tr("No function outputs were registered.", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
            }
            if (this.callResult == null) {
                throw new PSQLException(GT.tr("Results cannot be retrieved from a CallableStatement before it is executed.", new Object[0]), PSQLState.NO_DATA);
            }
            this.lastIndex = parameterIndex;
        }
    }

    @Override
    protected BatchResultHandler createBatchHandler(Query[] queries, @Nullable ParameterList[] parameterLists) {
        return new CallableBatchResultHandler(this, queries, parameterLists);
    }

    @Override
    public @Nullable Array getArray(int i) throws SQLException {
        this.checkClosed();
        this.checkIndex(i, 2003, "Array");
        return (Array)this.callResult[i - 1];
    }

    @Override
    public @Nullable BigDecimal getBigDecimal(@Positive int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 2, "BigDecimal");
        return (BigDecimal)this.callResult[parameterIndex - 1];
    }

    @Override
    public @Nullable Blob getBlob(int i) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getBlob(int)");
    }

    @Override
    public @Nullable Clob getClob(int i) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getClob(int)");
    }

    public @Nullable Object getObjectImpl(int i, @Nullable Map<String, Class<?>> map) throws SQLException {
        if (map == null || map.isEmpty()) {
            return this.getObject(i);
        }
        throw Driver.notImplemented(this.getClass(), "getObjectImpl(int,Map)");
    }

    @Override
    public @Nullable Ref getRef(int i) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getRef(int)");
    }

    @Override
    public @Nullable Date getDate(int i, @Nullable Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex(i, 91, "Date");
        if (this.callResult[i - 1] == null) {
            return null;
        }
        String value = this.callResult[i - 1].toString();
        return this.getTimestampUtils().toDate(cal, value);
    }

    @Override
    public @Nullable Time getTime(int i, @Nullable Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex(i, 92, "Time");
        if (this.callResult[i - 1] == null) {
            return null;
        }
        String value = this.callResult[i - 1].toString();
        return this.getTimestampUtils().toTime(cal, value);
    }

    @Override
    public @Nullable Timestamp getTimestamp(int i, @Nullable Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex(i, 93, "Timestamp");
        if (this.callResult[i - 1] == null) {
            return null;
        }
        String value = this.callResult[i - 1].toString();
        return this.getTimestampUtils().toTimestamp(cal, value);
    }

    @Override
    public void registerOutParameter(@Positive int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType, typeName, !this.adjustIndex);
    }

    @Override
    public void setObject(String parameterName, @Nullable Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setObject(String parameterName, @Nullable Object x, SQLType targetSqlType) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void registerOutParameter(@Positive int parameterIndex, SQLType sqlType) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter");
    }

    @Override
    public void registerOutParameter(@Positive int parameterIndex, SQLType sqlType, int scale) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter");
    }

    @Override
    public void registerOutParameter(@Positive int parameterIndex, SQLType sqlType, String typeName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter");
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter");
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType, int scale) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter");
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType, String typeName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter");
    }

    @Override
    public @Nullable RowId getRowId(@Positive int parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getRowId(int)");
    }

    @Override
    public @Nullable RowId getRowId(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getRowId(String)");
    }

    @Override
    public void setRowId(String parameterName, @Nullable RowId x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setRowId(parameterIndex, x);
    }

    @Override
    public void setNString(String parameterName, @Nullable String value) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setNString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(String parameterName, @Nullable Reader value, long length) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNCharacterStream(String parameterName, @Nullable Reader value) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void setCharacterStream(String parameterName, @Nullable Reader value, long length) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setCharacterStream(String parameterName, @Nullable Reader value) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setCharacterStream(parameterIndex, value);
    }

    @Override
    public void setBinaryStream(String parameterName, @Nullable InputStream value, long length) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setBinaryStream(parameterIndex, value, length);
    }

    @Override
    public void setBinaryStream(String parameterName, @Nullable InputStream value) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setBinaryStream(parameterIndex, value);
    }

    @Override
    public void setAsciiStream(String parameterName, @Nullable InputStream value, long length) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setAsciiStream(parameterIndex, value, length);
    }

    @Override
    public void setAsciiStream(String parameterName, @Nullable InputStream value) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setAsciiStream(parameterIndex, value);
    }

    @Override
    public void setNClob(String parameterName, @Nullable NClob value) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setNClob(parameterIndex, value);
    }

    @Override
    public void setClob(String parameterName, @Nullable Reader reader, long length) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setClob(String parameterName, @Nullable Reader reader) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setClob(parameterIndex, reader);
    }

    @Override
    public void setBlob(String parameterName, @Nullable InputStream inputStream, long length) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setBlob(parameterIndex, inputStream, length);
    }

    @Override
    public void setBlob(String parameterName, @Nullable InputStream inputStream) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setBlob(parameterIndex, inputStream);
    }

    @Override
    public void setBlob(String parameterName, @Nullable Blob x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setBlob(parameterIndex, x);
    }

    @Override
    public void setClob(String parameterName, @Nullable Clob x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setClob(parameterIndex, x);
    }

    @Override
    public void setNClob(String parameterName, @Nullable Reader reader, long length) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setNClob(String parameterName, @Nullable Reader reader) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setNClob(parameterIndex, reader);
    }

    @Override
    public @Nullable NClob getNClob(@Positive int parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNClob(int)");
    }

    @Override
    public @Nullable NClob getNClob(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNClob(String)");
    }

    @Override
    public void setSQLXML(String parameterName, @Nullable SQLXML xmlObject) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public @Nullable SQLXML getSQLXML(@Positive int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 2009, "SQLXML");
        return (SQLXML)this.callResult[parameterIndex - 1];
    }

    @Override
    public @Nullable SQLXML getSQLXML(String parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getSQLXML(String)");
    }

    @Override
    public String getNString(@Positive int parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNString(int)");
    }

    @Override
    public @Nullable String getNString(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNString(String)");
    }

    @Override
    public @Nullable Reader getNCharacterStream(@Positive int parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNCharacterStream(int)");
    }

    @Override
    public @Nullable Reader getNCharacterStream(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNCharacterStream(String)");
    }

    @Override
    public @Nullable Reader getCharacterStream(@Positive int parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getCharacterStream(int)");
    }

    @Override
    public @Nullable Reader getCharacterStream(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getCharacterStream(String)");
    }

    @Override
    public <T> @Nullable T getObject(@Positive int parameterIndex, Class<T> type) throws SQLException {
        if (type == ResultSet.class) {
            return type.cast(this.getObject(parameterIndex));
        }
        throw new PSQLException(GT.tr("Unsupported type conversion to {1}.", type), PSQLState.INVALID_PARAMETER_VALUE);
    }

    @Override
    public <T> @Nullable T getObject(String parameterName, Class<T> type) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getObject(String, Class<T>)");
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.registerOutParameter(parameterIndex, sqlType, scale);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.registerOutParameter(parameterIndex, sqlType, typeName);
    }

    @Override
    public @Nullable URL getURL(@Positive int parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getURL(String)");
    }

    @Override
    public void setURL(String parameterName, @Nullable URL val) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setURL(parameterIndex, val);
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setBoolean(parameterIndex, x);
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setByte(parameterIndex, x);
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setShort(parameterIndex, x);
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setInt(parameterIndex, x);
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setLong(parameterIndex, x);
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setFloat(parameterIndex, x);
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setDouble(parameterIndex, x);
    }

    @Override
    public void setBigDecimal(String parameterName, @Nullable BigDecimal x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setBigDecimal(parameterIndex, x);
    }

    @Override
    public void setString(String parameterName, @Nullable String x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setString(parameterIndex, x);
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setBytes(parameterIndex, x);
    }

    @Override
    public void setDate(String parameterName, @Nullable Date x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setDate(parameterIndex, x);
    }

    @Override
    public void setTime(String parameterName, @Nullable Time x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setTime(parameterIndex, x);
    }

    @Override
    public void setTimestamp(String parameterName, @Nullable Timestamp x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setTimestamp(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(String parameterName, @Nullable InputStream x, int length) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(String parameterName, @Nullable InputStream x, int length) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setObject(String parameterName, @Nullable Object x, int targetSqlType, int scale) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setObject(parameterIndex, x, targetSqlType, scale);
    }

    @Override
    public void setObject(String parameterName, @Nullable Object x, int targetSqlType) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(String parameterName, @Nullable Object x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(String parameterName, @Nullable Reader reader, int length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setCharacterStream(String,Reader,int)");
    }

    @Override
    public void setDate(String parameterName, @Nullable Date x, @Nullable Calendar cal) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setDate(parameterIndex, x, cal);
    }

    @Override
    public void setTime(String parameterName, @Nullable Time x, @Nullable Calendar cal) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setTime(parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(String parameterName, @Nullable Timestamp x, @Nullable Calendar cal) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setTimestamp(parameterIndex, x, cal);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNull(String,int,String)");
    }

    @Override
    public @Nullable String getString(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getString(parameterIndex);
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getBoolean(parameterIndex);
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getByte(parameterIndex);
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getShort(parameterIndex);
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getInt(parameterIndex);
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getLong(parameterIndex);
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getFloat(parameterIndex);
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getDouble(parameterIndex);
    }

    @Override
    public byte @Nullable [] getBytes(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getBytes(parameterIndex);
    }

    @Override
    public @Nullable Date getDate(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getDate(parameterIndex);
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getTime(parameterIndex);
    }

    @Override
    public @Nullable Timestamp getTimestamp(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getTimestamp(parameterIndex);
    }

    @Override
    public @Nullable Object getObject(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getObject(parameterIndex);
    }

    @Override
    public @Nullable BigDecimal getBigDecimal(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getBigDecimal(parameterIndex);
    }

    public @Nullable Object getObjectImpl(String parameterName, Map map) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getObjectImpl(parameterIndex, map);
    }

    @Override
    public @Nullable Ref getRef(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getRef(parameterIndex);
    }

    @Override
    public @Nullable Blob getBlob(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getBlob(parameterIndex);
    }

    @Override
    public @Nullable Clob getClob(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getClob(parameterIndex);
    }

    @Override
    public @Nullable Array getArray(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getArray(parameterIndex);
    }

    @Override
    public @Nullable Date getDate(String parameterName, @Nullable Calendar cal) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getDate(parameterIndex, cal);
    }

    @Override
    public @Nullable Time getTime(String parameterName, @Nullable Calendar cal) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getTime(parameterIndex, cal);
    }

    @Override
    public @Nullable Timestamp getTimestamp(String parameterName, @Nullable Calendar cal) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getTimestamp(parameterIndex, cal);
    }

    @Override
    public @Nullable URL getURL(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getURL(parameterIndex);
    }

    @Override
    public void registerOutParameter(@Positive int parameterIndex, int sqlType) throws SQLException {
        switch (sqlType) {
            case 16: {
                sqlType = -7;
                break;
            }
            case -10: {
                sqlType = 2012;
                break;
            }
        }
        this.registerOutParameter(parameterIndex, sqlType, !this.adjustIndex);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType);
    }

    private int getNamedParameterIndex(String paramName) throws SQLException {
        if (paramName == null) {
            throw new PSQLException(GT.tr("A CallableStatement function was executed with a named parameter as null.", new Object[0]), PSQLState.INVALID_PARAMETER_TYPE);
        }
        int thisParameterIndex = this.namedParameters.indexOf(paramName);
        if (thisParameterIndex == -1) {
            throw new PSQLException(GT.tr("A CallableStatement has a named parameter undefined in the calling statement.  Parameter: " + paramName, new Object[0]), PSQLState.INVALID_PARAMETER_TYPE);
        }
        if (this.outParmBeforeFunc) {
            ++thisParameterIndex;
            return ++thisParameterIndex;
        }
        return ++thisParameterIndex;
    }

    private void parseNamedParameters(String sql) throws SQLException {
        int closeParen;
        int openParen;
        this.atLeastOneNamedParameter = false;
        String procedureParameters = "";
        int startIndex = sql.toLowerCase().indexOf("call");
        if (startIndex != -1 && (openParen = sql.indexOf(40, startIndex + 4)) != -1 && (closeParen = sql.indexOf(")", openParen)) != -1) {
            procedureParameters = sql.substring(openParen + 1, closeParen);
        }
        if (procedureParameters != "") {
            procedureParameters = procedureParameters.replaceAll("\\s+", "");
            String[] tmpNamedParams = procedureParameters.split("\\?[\\?,]");
            for (int paramIndex = 0; paramIndex < tmpNamedParams.length; ++paramIndex) {
                int paramFoundIndex = tmpNamedParams[paramIndex].indexOf(NAMED_PARAMETER_INDICATOR);
                if (paramFoundIndex > 0) {
                    this.atLeastOneNamedParameter = true;
                    this.namedParameters.add(tmpNamedParams[paramIndex].substring(0, paramFoundIndex));
                    continue;
                }
                this.namedParameters.add("");
            }
        }
    }
}

