/*
 * Decompiled with CFR 0.152.
 */
package com.edb.jms.client;

import com.edb.jms.client.EDBJmsDestination;
import com.edb.jms.client.EDBJmsSession;
import java.util.Date;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageProducer;

public class EDBJmsMessageProducer
implements MessageProducer {
    private final Destination _destination;
    private int _defaultPriority = 4;
    private long _defaultTtl = 0L;
    private int _deliveryMode = 2;
    private boolean _disableTimestamp = false;
    private boolean _disableMessageId = false;
    private EDBJmsSession _session = null;

    public EDBJmsMessageProducer(EDBJmsSession session, Destination destination) {
        if (session == null) {
            throw new IllegalArgumentException("Argument 'session' is null");
        }
        this._session = session;
        this._destination = destination;
    }

    public Destination getDestination() {
        return this._destination;
    }

    public void setDisableMessageID(boolean value) {
        this._disableMessageId = value;
    }

    public boolean getDisableMessageID() {
        return this._disableMessageId;
    }

    public void setDisableMessageTimestamp(boolean value) {
        this._disableTimestamp = value;
    }

    public boolean getDisableMessageTimestamp() {
        return this._disableTimestamp;
    }

    public void setDeliveryMode(int deliveryMode) {
        this._deliveryMode = deliveryMode;
    }

    public int getDeliveryMode() {
        return this._deliveryMode;
    }

    public void setPriority(int priority) {
        this._defaultPriority = priority;
    }

    public int getPriority() {
        return this._defaultPriority;
    }

    public void setTimeToLive(long timeToLive) {
        this._defaultTtl = timeToLive;
    }

    public long getTimeToLive() {
        return this._defaultTtl;
    }

    public void send(Message message) throws JMSException {
        this.send(this.getDestination(), message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send(this.getDestination(), message, deliveryMode, priority, timeToLive);
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.send(destination, message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (!(destination instanceof EDBJmsDestination)) {
            throw new InvalidDestinationException("Invalid destination: " + destination);
        }
        if (message == null) {
            throw new MessageFormatException("Null message");
        }
        message.setJMSDestination(destination);
        message.setJMSTimestamp(new Date().getTime());
        message.setJMSPriority(priority);
        if (timeToLive > 0L) {
            message.setJMSExpiration(System.currentTimeMillis() + timeToLive);
        } else {
            message.setJMSExpiration(0L);
        }
        message.setJMSDeliveryMode(2);
        this._session.sendMessage(message, destination);
    }

    public synchronized void close() throws JMSException {
        if (this._session != null) {
            // empty if block
        }
        this._session = null;
    }

    public void setDeliveryDelay(long arg0) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long getDeliveryDelay() throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void send(Message arg0, CompletionListener arg1) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void send(Message arg0, int arg1, int arg2, long arg3, CompletionListener arg4) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void send(Destination arg0, Message arg1, CompletionListener arg2) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void send(Destination arg0, Message arg1, int arg2, int arg3, long arg4, CompletionListener arg5) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

