/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeClassParameterized;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;

public class EventPropertyDescriptor {
    private String propertyName;
    private EPType propertyType;
    private boolean isRequiresIndex;
    private boolean isRequiresMapkey;
    private boolean isIndexed;
    private boolean isMapped;
    private boolean isFragment;

    public EventPropertyDescriptor(String propertyName, EPType propertyType, boolean requiresIndex, boolean requiresMapkey, boolean indexed, boolean mapped, boolean fragment) {
        if (propertyType == null) {
            throw new IllegalArgumentException("Null property type");
        }
        this.propertyName = propertyName;
        this.propertyType = propertyType;
        this.isRequiresIndex = requiresIndex;
        this.isRequiresMapkey = requiresMapkey;
        this.isIndexed = indexed;
        this.isMapped = mapped;
        this.isFragment = fragment;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Class getPropertyType() {
        return EventTypeUtility.getPropertyTypeAsClass(this.propertyType);
    }

    public EPType getPropertyEPType() {
        return this.propertyType;
    }

    public Class getPropertyComponentType() {
        EPTypeClass typeClass = this.getPropertyComponentEPType();
        return typeClass == null ? null : typeClass.getType();
    }

    public EPTypeClass getPropertyComponentEPType() {
        if (!(this.propertyType instanceof EPTypeClass)) {
            return null;
        }
        EPTypeClass type = (EPTypeClass)this.propertyType;
        if (type.getType().isArray()) {
            return JavaClassHelper.getArrayComponentType(type);
        }
        if (this.propertyType instanceof EPTypeClassParameterized) {
            EPTypeClassParameterized parameterized = (EPTypeClassParameterized)this.propertyType;
            if (JavaClassHelper.isImplementsInterface(parameterized, Collection.class) || JavaClassHelper.isImplementsInterface(parameterized, Queue.class) || JavaClassHelper.isImplementsInterface(parameterized, Iterable.class)) {
                return parameterized.getParameters()[0];
            }
            if (JavaClassHelper.isImplementsInterface(parameterized, Map.class)) {
                return parameterized.getParameters()[1];
            }
        } else if (JavaClassHelper.isImplementsInterface(type, Collection.class) || JavaClassHelper.isImplementsInterface(type, Queue.class) || JavaClassHelper.isImplementsInterface(type, Iterable.class) || JavaClassHelper.isImplementsInterface(type, Map.class)) {
            return EPTypePremade.OBJECT.getEPType();
        }
        return null;
    }

    public boolean isRequiresIndex() {
        return this.isRequiresIndex;
    }

    public boolean isRequiresMapkey() {
        return this.isRequiresMapkey;
    }

    public boolean isIndexed() {
        return this.isIndexed;
    }

    public boolean isMapped() {
        return this.isMapped;
    }

    public boolean isFragment() {
        return this.isFragment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventPropertyDescriptor that = (EventPropertyDescriptor)o;
        if (this.isFragment != that.isFragment) {
            return false;
        }
        if (this.isIndexed != that.isIndexed) {
            return false;
        }
        if (this.isMapped != that.isMapped) {
            return false;
        }
        if (this.isRequiresIndex != that.isRequiresIndex) {
            return false;
        }
        if (this.isRequiresMapkey != that.isRequiresMapkey) {
            return false;
        }
        if (!this.propertyName.equals(that.propertyName)) {
            return false;
        }
        return !(this.propertyType != null ? !this.propertyType.equals(that.propertyType) : that.propertyType != null);
    }

    public int hashCode() {
        int result = this.propertyName.hashCode();
        result = 31 * result + (this.propertyType != null ? this.propertyType.hashCode() : 0);
        result = 31 * result + (this.isRequiresIndex ? 1 : 0);
        result = 31 * result + (this.isRequiresMapkey ? 1 : 0);
        result = 31 * result + (this.isIndexed ? 1 : 0);
        result = 31 * result + (this.isMapped ? 1 : 0);
        result = 31 * result + (this.isFragment ? 1 : 0);
        return result;
    }

    public String toString() {
        return "name " + this.propertyName + " propertyType " + this.propertyType.getTypeName() + " isRequiresIndex " + this.isRequiresIndex + " isRequiresMapkey " + this.isRequiresMapkey + " isIndexed " + this.isIndexed + " isMapped " + this.isMapped + " isFragment " + this.isFragment;
    }
}

