/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.dataflow.util;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowOpForgeInitializeContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.util.EPLValidationUtil;
import com.espertech.esper.common.internal.util.ClassHelperPrint;
import com.espertech.esper.common.internal.util.JavaClassHelper;

public class DataFlowParameterValidation {
    public static ExprNode validate(String name, ExprNode expr, Class expectedReturnType, DataFlowOpForgeInitializeContext context) throws ExprValidationException {
        if (expr == null) {
            return null;
        }
        return DataFlowParameterValidation.validate(name, expr, null, expectedReturnType, context);
    }

    public static ExprNode validate(String name, ExprNode expr, EventType eventType, Class expectedReturnType, DataFlowOpForgeInitializeContext context) throws ExprValidationException {
        if (expr == null) {
            return null;
        }
        ExprNode validated = EPLValidationUtil.validateSimpleGetSubtree(ExprNodeOrigin.DATAFLOWFILTER, expr, eventType, false, context.getStatementRawInfo(), context.getServices());
        DataFlowParameterValidation.validateReturnType(name, validated, expectedReturnType);
        return validated;
    }

    private static void validateReturnType(String name, ExprNode validated, Class expectedReturnType) throws ExprValidationException {
        EPType returnType = validated.getForge().getEvaluationType();
        if (returnType == null || returnType == EPTypeNull.INSTANCE) {
            throw DataFlowParameterValidation.makeValidateReturnTypeEx(name, "null", expectedReturnType);
        }
        EPTypeClass typeClass = (EPTypeClass)returnType;
        if (!JavaClassHelper.isAssignmentCompatible(JavaClassHelper.getBoxedType(typeClass), expectedReturnType)) {
            throw DataFlowParameterValidation.makeValidateReturnTypeEx(name, typeClass.getTypeName(), expectedReturnType);
        }
    }

    private static ExprValidationException makeValidateReturnTypeEx(String name, String received, Class expected) {
        String message = "Failed to validate return type of parameter '" + name + "', expected '" + ClassHelperPrint.getClassNameFullyQualPretty(expected) + "' but received '" + received + "'";
        return new ExprValidationException(message);
    }
}

