/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.json.minimaljson;

import com.espertech.esper.common.client.json.minimaljson.JsonWriter;
import com.espertech.esper.common.client.json.minimaljson.WriterConfig;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;

public class PrettyPrint
extends WriterConfig {
    private final char[] indentChars;

    protected PrettyPrint(char[] indentChars) {
        this.indentChars = indentChars;
    }

    public static PrettyPrint singleLine() {
        return new PrettyPrint(null);
    }

    public static PrettyPrint indentWithSpaces(int number) {
        if (number < 0) {
            throw new IllegalArgumentException("number is negative");
        }
        char[] chars = new char[number];
        Arrays.fill(chars, ' ');
        return new PrettyPrint(chars);
    }

    public static PrettyPrint indentWithTabs() {
        return new PrettyPrint(new char[]{'\t'});
    }

    @Override
    public JsonWriter createWriter(Writer writer) {
        return new PrettyPrintWriter(writer, this.indentChars);
    }

    private static class PrettyPrintWriter
    extends JsonWriter {
        private final char[] indentChars;
        private int indent;

        private PrettyPrintWriter(Writer writer, char[] indentChars) {
            super(writer);
            this.indentChars = indentChars;
        }

        @Override
        public void writeArrayOpen() throws IOException {
            ++this.indent;
            this.writer.write(91);
            this.writeNewLine();
        }

        @Override
        public void writeArrayClose() throws IOException {
            --this.indent;
            this.writeNewLine();
            this.writer.write(93);
        }

        @Override
        public void writeArraySeparator() throws IOException {
            this.writer.write(44);
            if (!this.writeNewLine()) {
                this.writer.write(32);
            }
        }

        @Override
        public void writeObjectOpen() throws IOException {
            ++this.indent;
            this.writer.write(123);
            this.writeNewLine();
        }

        @Override
        public void writeObjectClose() throws IOException {
            --this.indent;
            this.writeNewLine();
            this.writer.write(125);
        }

        @Override
        public void writeMemberSeparator() throws IOException {
            this.writer.write(58);
            this.writer.write(32);
        }

        @Override
        public void writeObjectSeparator() throws IOException {
            this.writer.write(44);
            if (!this.writeNewLine()) {
                this.writer.write(32);
            }
        }

        private boolean writeNewLine() throws IOException {
            if (this.indentChars == null) {
                return false;
            }
            this.writer.write(10);
            for (int i = 0; i < this.indent; ++i) {
                this.writer.write(this.indentChars);
            }
            return true;
        }
    }
}

