/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.scopetest;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.scopetest.ScopeTestHelper;
import com.espertech.esper.common.client.util.SafeIterator;
import com.espertech.esper.common.internal.collection.UniformPair;
import com.espertech.esper.common.internal.util.CollectionUtil;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPAssertionUtil {
    private static final Logger log = LoggerFactory.getLogger(EPAssertionUtil.class);

    public static void assertEqualsExactOrder(String[][] expected, String[][] actual) {
        if (EPAssertionUtil.compareArraySize(expected, actual)) {
            return;
        }
        for (int i = 0; i < expected.length; ++i) {
            ScopeTestHelper.assertTrue(Arrays.equals(actual[i], expected[i]));
        }
    }

    public static void assertEqualsExactOrder(Object[][] actual, String[] propertyNames, Object[][] expected) {
        if (EPAssertionUtil.compareArraySize(expected, actual)) {
            return;
        }
        for (int i = 0; i < expected.length; ++i) {
            Object[] propertiesThisRow = expected[i];
            for (int j = 0; j < propertiesThisRow.length; ++j) {
                String name = propertyNames[j];
                Object value = propertiesThisRow[j];
                Object eventProp = actual[i][j];
                ScopeTestHelper.assertEquals("Error asserting property named " + name, value, eventProp);
            }
        }
    }

    public static void assertEqualsExactOrder(Collection<Object[]> actual, String[] propertyNames, Object[][] expected) {
        Object[][] arr = (Object[][])actual.toArray((T[])new Object[actual.size()][]);
        EPAssertionUtil.assertEqualsExactOrder(arr, propertyNames, expected);
    }

    public static void assertEqualsExactOrder(EventBean[] expected, Iterator<EventBean> actual) {
        EPAssertionUtil.assertEqualsExactOrder((Object[])expected, actual);
    }

    public static void assertEqualsExactOrderUnderlying(Object[] expected, Iterator<EventBean> actual) {
        ArrayList<Object> underlyingValues = new ArrayList<Object>();
        while (actual.hasNext()) {
            underlyingValues.add(actual.next().getUnderlying());
        }
        try {
            actual.next();
            ScopeTestHelper.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Object[] data = null;
        if (underlyingValues.size() > 0) {
            data = underlyingValues.toArray();
        }
        EPAssertionUtil.assertEqualsExactOrder(expected, data);
    }

    public static void assertEqualsExactOrderUnderlying(Object[] expected, EventBean[] actual) {
        if (EPAssertionUtil.compareArraySize(expected, actual)) {
            return;
        }
        ArrayList<Object> underlying = new ArrayList<Object>();
        for (EventBean theEvent : actual) {
            underlying.add(theEvent.getUnderlying());
        }
        EPAssertionUtil.assertEqualsExactOrder(expected, underlying.toArray());
    }

    public static void assertEqualsExactOrder(Object[][] expected, List<Object[]> actual) {
        if (EPAssertionUtil.compareArrayAndCollSize(expected, actual)) {
            return;
        }
        for (int i = 0; i < expected.length; ++i) {
            Object[] receivedThisRow = actual.get(i);
            Object[] propertiesThisRow = expected[i];
            ScopeTestHelper.assertEquals(receivedThisRow.length, propertiesThisRow.length);
            for (int j = 0; j < propertiesThisRow.length; ++j) {
                Object expectedValue = propertiesThisRow[j];
                Object receivedValue = receivedThisRow[j];
                ScopeTestHelper.assertEquals("Error asserting property", expectedValue, receivedValue);
            }
        }
    }

    public static void assertEqualsExactOrder(Object[] expected, Object[] actual) {
        EPAssertionUtil.assertEqualsExactOrder(null, expected, actual);
    }

    public static void assertEqualsExactOrder(String message, Object[] expected, Object[] actual) {
        if (EPAssertionUtil.compareArraySize(message, expected, actual)) {
            return;
        }
        for (int i = 0; i < expected.length; ++i) {
            Object value = actual[i];
            Object expectedValue = expected[i];
            String text = message != null ? message + ", " : "";
            text = text + "Failed to assert at element " + i;
            EPAssertionUtil.assertEqualsAllowArray(text, expectedValue, value);
        }
    }

    public static void assertEqualsExactOrder(Object[] expected, Collection actual) {
        Object[] actualArray = null;
        if (actual != null) {
            actualArray = actual.toArray();
        }
        EPAssertionUtil.assertEqualsExactOrder(expected, actualArray);
    }

    public static void assertSameExactOrder(Object[] expected, Object[] actual) {
        if (EPAssertionUtil.compareArraySize(expected, actual)) {
            return;
        }
        for (int i = 0; i < expected.length; ++i) {
            ScopeTestHelper.assertSame("at element " + i, expected[i], actual[i]);
        }
    }

    public static void assertEqualsExactOrder(int[] expected, int[] actual) {
        if (EPAssertionUtil.compareArraySize(expected, actual)) {
            return;
        }
        for (int i = 0; i < expected.length; ++i) {
            ScopeTestHelper.assertEquals(expected[i], actual[i]);
        }
    }

    public static void assertEqualsExactOrder(int[] expected, Integer[] actual) {
        if (EPAssertionUtil.compareArraySize(expected, actual)) {
            return;
        }
        for (int i = 0; i < expected.length; ++i) {
            ScopeTestHelper.assertEquals(expected[i], actual[i]);
        }
    }

    public static void assertEqualsExactOrder(short[] expected, short[] actual) {
        if (EPAssertionUtil.compareArraySize(expected, actual)) {
            return;
        }
        for (int i = 0; i < expected.length; ++i) {
            ScopeTestHelper.assertEquals(expected[i], actual[i]);
        }
    }

    public static void assertEqualsExactOrder(long[] expected, long[] actual) {
        if (EPAssertionUtil.compareArraySize(expected, actual)) {
            return;
        }
        for (int i = 0; i < expected.length; ++i) {
            ScopeTestHelper.assertEquals(expected[i], actual[i]);
        }
    }

    public static void assertEqualsExactOrder(String[] expected, String[] actual) {
        if (EPAssertionUtil.compareArraySize(expected, actual)) {
            return;
        }
        for (int i = 0; i < expected.length; ++i) {
            ScopeTestHelper.assertEquals(expected[i], actual[i]);
        }
    }

    public static void assertEqualsExactOrder(boolean[] expected, boolean[] actual) {
        if (EPAssertionUtil.compareArraySize(expected, actual)) {
            return;
        }
        for (int i = 0; i < expected.length; ++i) {
            ScopeTestHelper.assertEquals(expected[i], actual[i]);
        }
    }

    public static void assertEqualsExactOrder(Object[] expected, Iterator actual) {
        ArrayList values = new ArrayList();
        while (actual.hasNext()) {
            values.add(actual.next());
        }
        try {
            actual.next();
            ScopeTestHelper.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Object[] data = null;
        if (values.size() > 0) {
            data = values.toArray();
        }
        EPAssertionUtil.assertEqualsExactOrder(expected, data);
    }

    public static void assertEqualsAnyOrder(int[] expected, Set<Integer> actual) {
        if (EPAssertionUtil.compareArrayAndCollSize(expected, actual)) {
            return;
        }
        for (int anExpected : expected) {
            ScopeTestHelper.assertTrue("not found: " + anExpected, actual.contains(anExpected));
        }
    }

    public static void assertEqualsAnyOrder(int[] expected, int[] actual) {
        if (EPAssertionUtil.compareArraySize(expected, actual)) {
            return;
        }
        HashSet<Integer> intSet = new HashSet<Integer>();
        for (int anActual : actual) {
            intSet.add(anActual);
        }
        EPAssertionUtil.assertEqualsAnyOrder(expected, intSet);
    }

    public static void assertEqualsAnyOrder(Object[] expected, Object[] actual) {
        if (EPAssertionUtil.compareArraySize(expected, actual)) {
            return;
        }
        Object[] received = new Object[actual.length];
        System.arraycopy(actual, 0, received, 0, actual.length);
        int numMatches = 0;
        for (Object expectedObject : expected) {
            boolean found = false;
            for (int i = 0; i < received.length; ++i) {
                boolean result;
                if (received[i] == null || !(result = received[i] instanceof boolean[] && expectedObject instanceof boolean[] ? Arrays.equals((boolean[])received[i], (boolean[])expectedObject) : (received[i] instanceof byte[] && expectedObject instanceof byte[] ? Arrays.equals((byte[])received[i], (byte[])expectedObject) : (received[i] instanceof char[] && expectedObject instanceof char[] ? Arrays.equals((char[])received[i], (char[])expectedObject) : (received[i] instanceof short[] && expectedObject instanceof short[] ? Arrays.equals((short[])received[i], (short[])expectedObject) : (received[i] instanceof int[] && expectedObject instanceof int[] ? Arrays.equals((int[])received[i], (int[])expectedObject) : (received[i] instanceof long[] && expectedObject instanceof long[] ? Arrays.equals((long[])received[i], (long[])expectedObject) : (received[i] instanceof float[] && expectedObject instanceof float[] ? Arrays.equals((float[])received[i], (float[])expectedObject) : (received[i] instanceof double[] && expectedObject instanceof double[] ? Arrays.equals((double[])received[i], (double[])expectedObject) : (received[i] instanceof Object[] && expectedObject instanceof Object[] ? Arrays.deepEquals((Object[])received[i], (Object[])expectedObject) : received[i].equals(expectedObject))))))))))) continue;
                found = true;
                ++numMatches;
                received[i] = null;
                break;
            }
            if (!found) {
                if (expectedObject instanceof Object[]) {
                    log.error(".assertEqualsAnyOrder Not found in received results is expected=" + Arrays.toString((Object[])expectedObject));
                } else {
                    log.error(".assertEqualsAnyOrder Not found in received results is expected=" + expectedObject);
                }
                log.error(".assertEqualsAnyOrder received=" + CollectionUtil.toStringArray(received));
            }
            ScopeTestHelper.assertTrue("Failed to find value " + expectedObject + ", check the error logs", found);
        }
        ScopeTestHelper.assertEquals(numMatches, expected.length);
    }

    public static void assertPropsPerRow(Iterator<EventBean> iterator, SafeIterator<EventBean> safeIterator, String[] propertyNames, Object[][] expected) {
        EPAssertionUtil.assertPropsPerRow(EPAssertionUtil.iteratorToArray(iterator), propertyNames, expected);
        EPAssertionUtil.assertPropsPerRow(EPAssertionUtil.iteratorToArray(safeIterator), propertyNames, expected);
        safeIterator.close();
    }

    public static void assertPropsPerRowAnyOrder(Iterator<EventBean> iterator, SafeIterator<EventBean> safeIterator, String[] propertyNames, Object[][] expected) {
        EPAssertionUtil.assertPropsPerRowAnyOrder(EPAssertionUtil.iteratorToArray(iterator), propertyNames, expected);
        EPAssertionUtil.assertPropsPerRowAnyOrder(EPAssertionUtil.iteratorToArray(safeIterator), propertyNames, expected);
        safeIterator.close();
    }

    public static void assertPropsPerRowAnyOrder(UniformPair<EventBean[]> pair, String[] propertyNames, Object[][] expectedNew, Object[][] expectedOld) {
        EPAssertionUtil.assertPropsPerRowAnyOrder(pair.getFirst(), propertyNames, expectedNew);
        EPAssertionUtil.assertPropsPerRowAnyOrder(pair.getSecond(), propertyNames, expectedOld);
    }

    public static void assertPropsPerRowAnyOrder(SafeIterator<EventBean> safeIterator, String[] propertyNames, Object[][] expected) {
        EPAssertionUtil.assertPropsPerRowAnyOrder(EPAssertionUtil.iteratorToArray(safeIterator), propertyNames, expected);
        safeIterator.close();
    }

    public static void assertPropsPerRowAnyOrder(Iterator<EventBean> iterator, String[] propertyNames, Object[][] expected) {
        EPAssertionUtil.assertPropsPerRowAnyOrder(EPAssertionUtil.iteratorToArray(iterator), propertyNames, expected);
    }

    public static void assertPropsPerRow(Iterator<EventBean> iterator, String[] propertyNames, Object[][] expected) {
        EPAssertionUtil.assertPropsPerRow(EPAssertionUtil.iteratorToArray(iterator), propertyNames, expected);
    }

    public static void assertPropsPerRow(Map[] actual, String[] propertyNames, Object[][] expected) {
        if (EPAssertionUtil.compareArraySize(expected, actual)) {
            return;
        }
        for (int i = 0; i < expected.length; ++i) {
            Object[] propertiesThisRow = expected[i];
            for (int j = 0; j < propertiesThisRow.length; ++j) {
                String name = propertyNames[j];
                Object value = propertiesThisRow[j];
                Object eventProp = actual[i].get(name);
                ScopeTestHelper.assertEquals("Error asserting property named " + name, value, eventProp);
            }
        }
    }

    public static void assertPropsPerRow(EventBean[] received, String[] propertyNames, Object[][] expected) {
        EPAssertionUtil.assertPropsPerRow(received, propertyNames, expected, "");
    }

    public static void assertPropsPerRow(EventBean[] actual, String[] propertyNames, Object[][] expected, String streamName) {
        if (EPAssertionUtil.compareArraySize(expected, actual)) {
            return;
        }
        for (int i = 0; i < expected.length; ++i) {
            Object[] propertiesThisRow = expected[i];
            ScopeTestHelper.assertEquals("Number of properties expected mismatches for row " + i, propertyNames.length, propertiesThisRow.length);
            for (int j = 0; j < propertiesThisRow.length; ++j) {
                String name = propertyNames[j];
                Object value = propertiesThisRow[j];
                Object eventProp = actual[i].get(name);
                StringWriter writer = new StringWriter();
                writer.append("Error asserting property named ");
                writer.append(name);
                writer.append(" for row ");
                writer.append(Integer.toString(i));
                if (streamName != null && streamName.trim().length() != 0) {
                    writer.append(" for stream ");
                    writer.append(streamName);
                }
                EPAssertionUtil.assertEqualsAllowArray(writer.toString(), value, eventProp);
            }
        }
    }

    public static void assertPropsPerRowAnyOrder(EventBean[] actual, String[] propertyNames, Object[][] expected) {
        if (EPAssertionUtil.compareArraySize(expected, actual)) {
            return;
        }
        Object[] expectedArray = new Object[expected.length];
        System.arraycopy(expected, 0, expectedArray, 0, expectedArray.length);
        Object[] receivedArray = new Object[actual.length];
        for (int i = 0; i < actual.length; ++i) {
            Object[] data;
            receivedArray[i] = data = new Object[propertyNames.length];
            for (int j = 0; j < propertyNames.length; ++j) {
                Object eventProp;
                String name = propertyNames[j];
                data[j] = eventProp = actual[i].get(name);
            }
        }
        EPAssertionUtil.assertEqualsAnyOrder(expectedArray, receivedArray);
    }

    public static void assertProps(EventBean received, String[] propertyNames, Object[] expected) {
        if (EPAssertionUtil.compareArraySize(expected, propertyNames)) {
            return;
        }
        for (int j = 0; j < expected.length; ++j) {
            String name = propertyNames[j].trim();
            Object value = expected[j];
            Object eventProp = received.get(name);
            EPAssertionUtil.assertEqualsAllowArray("Failed to assert property '" + name + "'", value, eventProp);
        }
    }

    public static void assertProps(UniformPair<EventBean> received, String[] propertyNames, Object[] expectedInsert, Object[] expectedRemoved) {
        EPAssertionUtil.assertProps(received.getFirst(), propertyNames, expectedInsert);
        EPAssertionUtil.assertProps(received.getSecond(), propertyNames, expectedRemoved);
    }

    public static void assertPropsPerRow(UniformPair<EventBean[]> received, String[] propertyNames, Object[][] expectedInsert, Object[][] expectedRemoved) {
        EPAssertionUtil.assertPropsPerRow(received.getFirst(), propertyNames, expectedInsert);
        EPAssertionUtil.assertPropsPerRow(received.getSecond(), propertyNames, expectedRemoved);
    }

    public static void assertPropsPerRow(UniformPair<EventBean[]> received, String propertyName, Object[] expectedInsert, Object[] expectedRemoved) {
        Object[] propsInsert = EPAssertionUtil.eventsToObjectArr(received.getFirst(), propertyName);
        EPAssertionUtil.assertEqualsExactOrder(expectedInsert, propsInsert);
        Object[] propsRemove = EPAssertionUtil.eventsToObjectArr(received.getSecond(), propertyName);
        EPAssertionUtil.assertEqualsExactOrder(expectedRemoved, propsRemove);
    }

    public static void assertUnderlyingPerRow(UniformPair<EventBean[]> received, Object[] expectedUnderlyingInsert, Object[] expectedUnderlyingRemove) {
        int i;
        EventBean[] newEvents = received.getFirst();
        EventBean[] oldEvents = received.getSecond();
        if (expectedUnderlyingInsert != null) {
            ScopeTestHelper.assertEquals(expectedUnderlyingInsert.length, newEvents.length);
            for (i = 0; i < expectedUnderlyingInsert.length; ++i) {
                ScopeTestHelper.assertSame(expectedUnderlyingInsert[i], newEvents[i].getUnderlying());
            }
        } else {
            ScopeTestHelper.assertNull(newEvents);
        }
        if (expectedUnderlyingRemove != null) {
            ScopeTestHelper.assertEquals(expectedUnderlyingRemove.length, oldEvents.length);
            for (i = 0; i < expectedUnderlyingRemove.length; ++i) {
                ScopeTestHelper.assertSame(expectedUnderlyingRemove[i], oldEvents[i].getUnderlying());
            }
        } else {
            ScopeTestHelper.assertNull(oldEvents);
        }
    }

    public static void assertAllPropsSortedByName(EventBean received, Object[] expected) {
        if (expected == null) {
            if (received == null) {
                return;
            }
        } else {
            ScopeTestHelper.assertNotNull(received);
        }
        if (expected != null) {
            String[] propertyNames = received.getEventType().getPropertyNames();
            Object[] propertyNamesSorted = new String[propertyNames.length];
            System.arraycopy(propertyNames, 0, propertyNamesSorted, 0, propertyNames.length);
            Arrays.sort(propertyNamesSorted);
            for (int j = 0; j < expected.length; ++j) {
                String name = ((String)propertyNamesSorted[j]).trim();
                Object value = expected[j];
                Object eventProp = received.get(name);
                ScopeTestHelper.assertEquals("Error asserting property named '" + name + "'", value, eventProp);
            }
        }
    }

    public static void assertPropsMap(Map received, String[] propertyNames, Object ... expected) {
        if (expected == null) {
            if (received == null) {
                return;
            }
        } else {
            ScopeTestHelper.assertNotNull(received);
            ScopeTestHelper.assertEquals("Mismatch in number of values to compare", expected.length, propertyNames.length);
        }
        if (expected != null) {
            for (int j = 0; j < expected.length; ++j) {
                String name = propertyNames[j].trim();
                Object value = expected[j];
                Object eventProp = received.get(name);
                EPAssertionUtil.assertEqualsAllowArray("Error asserting property named '" + name + "'", value, eventProp);
            }
        }
    }

    public static void assertPropsObjectArray(Object[] received, String[] propertyNames, Object ... expected) {
        if (expected == null) {
            if (received == null) {
                return;
            }
        } else {
            ScopeTestHelper.assertNotNull(received);
        }
        if (expected != null) {
            for (int j = 0; j < expected.length; ++j) {
                String name = propertyNames[j].trim();
                Object value = expected[j];
                Object eventProp = received[j];
                ScopeTestHelper.assertEquals("Error asserting property named '" + name + "'", value, eventProp);
            }
        }
    }

    public static void assertEqualsAnyOrder(EventBean[][] expected, EventBean[][] actual) {
        if (EPAssertionUtil.compareArraySize(expected, actual)) {
            return;
        }
        int numMatches = 0;
        boolean[] foundReceived = new boolean[actual.length];
        for (Object[] objectArray : expected) {
            boolean found = false;
            for (int i = 0; i < actual.length; ++i) {
                boolean match;
                if (foundReceived[i] || !(match = EPAssertionUtil.compareEqualsExactOrder(actual[i], (EventBean[])objectArray))) continue;
                found = true;
                ++numMatches;
                foundReceived[i] = true;
                break;
            }
            if (!found) {
                log.error(".assertEqualsAnyOrder Not found in received results is expected=" + Arrays.toString(objectArray));
                log.error(".assertEqualsAnyOrder received=" + Arrays.toString((Object[])actual));
            }
            ScopeTestHelper.assertTrue(found);
        }
        ScopeTestHelper.assertEquals(numMatches, expected.length);
    }

    public static void assertSameAnyOrder(Object[][] expected, Object[][] actual) {
        if (EPAssertionUtil.compareArraySize(expected, actual)) {
            return;
        }
        int numMatches = 0;
        boolean[] foundReceived = new boolean[actual.length];
        for (Object[] expectedArr : expected) {
            boolean found = false;
            for (int i = 0; i < actual.length; ++i) {
                boolean match;
                if (foundReceived[i] || !(match = EPAssertionUtil.compareRefExactOrder(actual[i], expectedArr))) continue;
                found = true;
                ++numMatches;
                foundReceived[i] = true;
                break;
            }
            if (found) continue;
            log.error(".assertEqualsAnyOrder Not found in received results is expected=" + Arrays.toString(expectedArr));
            for (int j = 0; j < actual.length; ++j) {
                log.error(".assertEqualsAnyOrder                              received (" + j + "):" + Arrays.toString(actual[j]));
            }
            ScopeTestHelper.fail();
        }
        ScopeTestHelper.assertEquals(numMatches, expected.length);
    }

    public static void assertAllBooleanTrue(Object[] objects) {
        for (Object object : objects) {
            ScopeTestHelper.assertTrue((Boolean)object);
        }
    }

    public static void assertTypeEqualsAnyOrder(Class[] classes, Object[] objects) {
        ScopeTestHelper.assertEquals(classes.length, objects.length);
        Object[] resultClasses = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            resultClasses[i] = objects[i].getClass();
        }
        EPAssertionUtil.assertEqualsAnyOrder(resultClasses, classes);
    }

    public static EventBean[] iteratorToArray(Iterator<EventBean> iterator) {
        if (iterator == null) {
            ScopeTestHelper.fail("Null iterator");
        }
        return CollectionUtil.iteratorToArrayEvents(iterator);
    }

    public static Object[] iteratorToArrayUnderlying(Iterator<EventBean> iterator) {
        ArrayList<Object> events = new ArrayList<Object>();
        while (iterator.hasNext()) {
            events.add(iterator.next().getUnderlying());
        }
        return events.toArray();
    }

    public static <T> int iteratorCount(Iterator<T> iterator) {
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    public static void assertPropsPerRow(EventBean[] received, List<Map<String, Object>> expected) {
        if (expected == null && received == null) {
            return;
        }
        if (expected == null || received == null) {
            ScopeTestHelper.fail();
        } else {
            ScopeTestHelper.assertEquals(expected.size(), received.length);
            for (int i = 0; i < expected.size(); ++i) {
                EPAssertionUtil.assertProps(received[i], expected.get(i));
            }
        }
    }

    public static void assertPropsPerRow(Iterator<EventBean> iterator, List<Map<String, Object>> expected) {
        ArrayList<EventBean> values = new ArrayList<EventBean>();
        while (iterator.hasNext()) {
            values.add(iterator.next());
        }
        try {
            iterator.next();
            ScopeTestHelper.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        EventBean[] data = null;
        if (values.size() > 0) {
            data = values.toArray(new EventBean[values.size()]);
        }
        EPAssertionUtil.assertPropsPerRow(data, expected);
    }

    public static Object[] concatenateArray(Object[] srcOne, Object[] srcTwo) {
        Object[] result = new Object[srcOne.length + srcTwo.length];
        System.arraycopy(srcOne, 0, result, 0, srcOne.length);
        System.arraycopy(srcTwo, 0, result, srcOne.length, srcTwo.length);
        return result;
    }

    public static Object[][] concatenateArray2Dim(Object[][] first, Object[][] ... more) {
        int i;
        int len = first.length;
        for (int i2 = 0; i2 < more.length; ++i2) {
            Object[][] next = more[i2];
            len += next.length;
        }
        Object[][] result = new Object[len][];
        int count = 0;
        for (i = 0; i < first.length; ++i) {
            result[count] = first[i];
            ++count;
        }
        for (i = 0; i < more.length; ++i) {
            Object[][] next = more[i];
            for (int j = 0; j < next.length; ++j) {
                result[count] = next[j];
                ++count;
            }
        }
        return result;
    }

    public static Object[] concatenateArray(Object[] ... more) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < more.length; ++i) {
            for (int j = 0; j < more[i].length; ++j) {
                list.add(more[i][j]);
            }
        }
        return list.toArray();
    }

    public static EventBean[] sort(Iterator<EventBean> events, String property) {
        return EPAssertionUtil.sort(EPAssertionUtil.iteratorToArray(events), property);
    }

    public static EventBean[] sort(EventBean[] events, final String property) {
        List<EventBean> list = Arrays.asList(events);
        Collections.sort(list, new Comparator<EventBean>(){

            @Override
            public int compare(EventBean o1, EventBean o2) {
                Comparable val1 = (Comparable)o1.get(property);
                Comparable val2 = (Comparable)o2.get(property);
                return val1.compareTo(val2);
            }
        });
        return list.toArray(new EventBean[list.size()]);
    }

    public static void assertNotContains(String[] stringSet, String ... values) {
        HashSet<String> set = new HashSet<String>(Arrays.asList(stringSet));
        for (String value : values) {
            ScopeTestHelper.assertFalse(set.contains(value));
        }
    }

    public static void assertContains(String[] stringSet, String ... values) {
        HashSet<String> set = new HashSet<String>(Arrays.asList(stringSet));
        for (String value : values) {
            ScopeTestHelper.assertTrue(set.contains(value));
        }
    }

    public static Object[] getUnderlying(EventBean[] events) {
        Object[] arr = new Object[events.length];
        for (int i = 0; i < events.length; ++i) {
            arr[i] = events[i].getUnderlying();
        }
        return arr;
    }

    public static void assertPropsAllValuesSame(EventBean received, String[] propertyNames, Object expected) {
        for (String field : propertyNames) {
            ScopeTestHelper.assertEquals("Field " + field, expected, received.get(field));
        }
    }

    public static Object[] eventsToObjectArr(EventBean[] events, String propertyName) {
        if (events == null) {
            return null;
        }
        Object[] objects = new Object[events.length];
        for (int i = 0; i < events.length; ++i) {
            objects[i] = events[i].get(propertyName);
        }
        return objects;
    }

    public static Object[][] eventsToObjectArr(EventBean[] events, String[] propertyNames) {
        if (events == null) {
            return null;
        }
        Object[][] objects = new Object[events.length][];
        for (int i = 0; i < events.length; ++i) {
            EventBean theEvent = events[i];
            Object[] values = new Object[propertyNames.length];
            for (int j = 0; j < propertyNames.length; ++j) {
                values[j] = theEvent.get(propertyNames[j]);
            }
            objects[i] = values;
        }
        return objects;
    }

    public static Object[] iteratorToObjectArr(Iterator<EventBean> iterator, String propertyName) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return CollectionUtil.OBJECTARRAY_EMPTY;
        }
        return EPAssertionUtil.eventsToObjectArr(EPAssertionUtil.iteratorToArray(iterator), propertyName);
    }

    public static Object[][] iteratorToObjectArr(Iterator<EventBean> iterator, String[] propertyNames) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return CollectionUtil.OBJECTARRAYARRAY_EMPTY;
        }
        return EPAssertionUtil.eventsToObjectArr(EPAssertionUtil.iteratorToArray(iterator), propertyNames);
    }

    public static boolean compareEqualsExactOrder(EventBean[] actual, EventBean[] expected) {
        if (expected == null && actual == null) {
            return true;
        }
        if (expected == null || actual == null) {
            return false;
        }
        if (expected.length != actual.length) {
            return false;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (actual[i] == null && expected[i] == null || actual[i].equals(expected[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean compareRefExactOrder(Object[] actual, Object[] expected) {
        if (expected == null && actual == null) {
            return true;
        }
        if (expected == null || actual == null) {
            return false;
        }
        if (expected.length != actual.length) {
            return false;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            return false;
        }
        return true;
    }

    public static void assertPropsPerRow(Object[] received, String[] propertyNames, Object[][] expected) {
        ScopeTestHelper.assertEquals("Mismatch in number of rows received", expected.length, received.length);
        for (int row = 0; row < received.length; ++row) {
            EPAssertionUtil.assertProps(received[row], propertyNames, expected[row]);
        }
    }

    public static void assertPropsPerRow(List<Object[]> received, String[] propertyNames, Object[][] expected) {
        ScopeTestHelper.assertEquals(received.size(), expected.length);
        for (int row = 0; row < received.size(); ++row) {
            EPAssertionUtil.assertProps(received.get(row), propertyNames, expected[row]);
        }
    }

    public static void assertProps(Object received, String[] propertyNames, Object[] expected) {
        if (received instanceof Map) {
            EPAssertionUtil.assertPropsMap((Map)received, propertyNames, expected);
        } else if (received instanceof Object[]) {
            EPAssertionUtil.assertPropsObjectArray((Object[])received, propertyNames, expected);
        } else if (received instanceof EventBean) {
            EPAssertionUtil.assertProps((EventBean)received, propertyNames, expected);
        } else {
            throw new UnsupportedOperationException("POJO comparison not supported, operation only supports Map, Object-Array amd EventBean");
        }
    }

    public static Object[] toObjectArray(Object array) {
        if (array == null || !array.getClass().isArray()) {
            throw new IllegalArgumentException("Object not an array but type '" + (array == null ? "null" : array.getClass()) + "'");
        }
        int size = Array.getLength(array);
        Object[] val = new Object[size];
        for (int i = 0; i < size; ++i) {
            val[i] = Array.get(array, i);
        }
        return val;
    }

    public static void assertEqualsAllowArray(String message, Object expected, Object actual) {
        if (expected != null && expected.getClass().isArray() && actual != null && actual.getClass().isArray()) {
            Object[] valueArray = EPAssertionUtil.toObjectArray(expected);
            Object[] eventPropArray = EPAssertionUtil.toObjectArray(actual);
            EPAssertionUtil.assertEqualsExactOrder(message, valueArray, eventPropArray);
            Class<?> componentTypeExpected = JavaClassHelper.getArrayComponentTypeInnermost(expected.getClass());
            if (componentTypeExpected != Object.class) {
                Class<?> componentTypeActual = JavaClassHelper.getArrayComponentTypeInnermost(actual.getClass());
                ScopeTestHelper.assertEquals(message + ": component type mismatch " + componentTypeExpected.getName() + " vs " + componentTypeActual.getName(), componentTypeExpected, componentTypeActual);
            }
            return;
        }
        ScopeTestHelper.assertEquals(message, expected, actual);
    }

    public static void assertProps(EventBean received, Map<String, Object> expected) {
        for (Map.Entry<String, Object> entry : expected.entrySet()) {
            Object valueExpected = entry.getValue();
            Object property = received.get(entry.getKey());
            ScopeTestHelper.assertEquals(valueExpected, property);
        }
    }

    private static boolean compareArrayAndCollSize(Object expected, Collection actual) {
        if (expected == null && (actual == null || actual.size() == 0)) {
            return true;
        }
        if (expected == null || actual == null) {
            if (expected == null) {
                ScopeTestHelper.assertNull("Expected is null but actual is not null", actual);
            }
            ScopeTestHelper.assertNull("Actual is null but expected is not null", expected);
        } else {
            int expectedLength = Array.getLength(expected);
            int actualLength = actual.size();
            ScopeTestHelper.assertEquals("Mismatch in the number of expected and actual length", expectedLength, actualLength);
        }
        return false;
    }

    private static boolean compareArraySize(Object expected, Object actual) {
        return EPAssertionUtil.compareArraySize(null, expected, actual);
    }

    private static boolean compareArraySize(String message, Object expected, Object actual) {
        if (expected == null && (actual == null || Array.getLength(actual) == 0)) {
            return true;
        }
        if (expected == null || actual == null) {
            String prefix;
            String string = prefix = message != null ? message + ", " : "";
            if (expected == null) {
                ScopeTestHelper.assertNull(prefix + "Expected is null but actual is not null", actual);
            }
            ScopeTestHelper.assertNull(prefix + "Actual is null but expected is not null", expected);
        } else {
            int expectedLength = Array.getLength(expected);
            int actualLength = Array.getLength(actual);
            String prefix = message != null ? message + ", " : "";
            ScopeTestHelper.assertEquals(prefix + "Mismatch in the number of expected and actual number of values asserted", expectedLength, actualLength);
        }
        return false;
    }

    public static void assertEqualsIgnoreNewline(String expected, String received) {
        String receivedClean;
        String expectedClean = EPAssertionUtil.removeNewline(expected);
        if (!expectedClean.equals(receivedClean = EPAssertionUtil.removeNewline(received))) {
            log.error("Expected: " + expectedClean);
            log.error("Received: " + receivedClean);
            ScopeTestHelper.assertEquals("Mismatch ", expected, received);
        }
    }

    public static void assertMapOfCollection(Map map, String[] keys, String[] expectedList, AssertionCollectionValueString collectionValue) {
        ScopeTestHelper.assertEquals(expectedList.length, keys.length);
        if (keys.length == 0 && map.isEmpty()) {
            return;
        }
        ScopeTestHelper.assertEquals(map.size(), keys.length);
        for (int i = 0; i < keys.length; ++i) {
            Collection value = (Collection)map.get(keys[i]);
            String[] itemsExpected = expectedList[i].split(",");
            ScopeTestHelper.assertEquals(itemsExpected.length, value.size());
            Iterator it = value.iterator();
            for (int j = 0; j < itemsExpected.length; ++j) {
                String received = collectionValue.extractValue(it.next());
                ScopeTestHelper.assertEquals(itemsExpected[j], received);
            }
        }
    }

    public static void assertNameValuePairs(EventBean[] lastData, Object[][] namesAndValues) {
        if (namesAndValues != null) {
            ScopeTestHelper.assertEquals(1, lastData.length);
            EventBean newEvent = lastData[0];
            for (int i = 0; i < namesAndValues.length; ++i) {
                String name = (String)namesAndValues[i][0];
                Object value = namesAndValues[i][1];
                ScopeTestHelper.assertEquals("newEvent property named " + name, value, newEvent.get(name));
            }
        } else {
            ScopeTestHelper.assertNull(lastData);
        }
    }

    private static String removeNewline(String raw) {
        raw = raw.replaceAll("\t", "");
        raw = raw.replaceAll("\n", "");
        raw = raw.replaceAll("\r", "");
        return raw;
    }

    public static interface AssertionCollectionValueString {
        public String extractValue(Object var1);
    }
}

