/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.scopetest;

import java.io.StringWriter;
import java.lang.reflect.Constructor;

public class ScopeTestHelper {
    private static final String JUNIT_ASSERTIONFAILED_ERROR = "junit.framework.AssertionFailedError";

    public static void assertFalse(boolean condition) {
        ScopeTestHelper.assertTrue(!condition);
    }

    public static void assertTrue(boolean condition) {
        ScopeTestHelper.assertTrue(null, condition);
    }

    public static void assertTrue(String message, boolean condition) {
        if (!condition) {
            ScopeTestHelper.fail(message);
        }
    }

    public static void assertFalse(String message, boolean condition) {
        if (condition) {
            ScopeTestHelper.fail(message);
        }
    }

    public static void assertEquals(String message, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        ScopeTestHelper.failNotEquals(message, expected, actual);
    }

    public static void assertEquals(Object expected, Object actual) {
        ScopeTestHelper.assertEquals(null, expected, actual);
    }

    public static void fail() {
        ScopeTestHelper.fail(null);
    }

    public static void assertSame(String message, Object expected, Object actual) {
        if (expected == actual) {
            return;
        }
        ScopeTestHelper.failNotSame(message, expected, actual);
    }

    public static void assertSame(Object expected, Object actual) {
        if (expected == actual) {
            return;
        }
        ScopeTestHelper.failNotSame(null, expected, actual);
    }

    public static void assertNull(String message, Object object) {
        ScopeTestHelper.assertTrue(message, object == null);
    }

    public static void assertNotNull(Object object) {
        ScopeTestHelper.assertTrue(object != null);
    }

    public static void assertNotNull(String message, Object object) {
        ScopeTestHelper.assertTrue(message, object != null);
    }

    public static void assertNull(Object object) {
        ScopeTestHelper.assertTrue(object == null);
    }

    public static void failNotSame(String message, Object expected, Object actual) {
        ScopeTestHelper.fail(ScopeTestHelper.format(message, expected, actual, true));
    }

    public static void failNotEquals(String message, Object expected, Object actual) {
        ScopeTestHelper.fail(ScopeTestHelper.format(message, expected, actual, false));
    }

    public static void fail(String message) {
        Constructor<?> ctor;
        Class<?> junitAssertionFailedError = null;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            junitAssertionFailedError = Class.forName(JUNIT_ASSERTIONFAILED_ERROR, true, cl);
        }
        catch (ClassNotFoundException cl) {
            // empty catch block
        }
        if (junitAssertionFailedError == null) {
            throw new AssertionError((Object)("Failed assertion and no JUnit found in classpath: " + message));
        }
        try {
            ctor = junitAssertionFailedError.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)("Failed to find JUnit method 'fail' method: " + e.getMessage()));
        }
        try {
            throw (AssertionError)ctor.newInstance(message);
        }
        catch (Exception e) {
            throw new AssertionError((Object)("Failed to call ctor of 'junit.framework.AssertionFailedError': " + e.getMessage()));
        }
    }

    private static String format(String message, Object expected, Object actual, boolean isSame) {
        StringWriter buf = new StringWriter();
        if (message != null && !message.isEmpty()) {
            buf.append(message);
            buf.append(' ');
        }
        buf.append("expected");
        if (isSame) {
            buf.append(" same");
        }
        buf.append(":<");
        buf.append(expected == null ? "null" : expected.toString());
        buf.append("> but was:<");
        buf.append(actual == null ? "null" : actual.toString());
        buf.append(">");
        return buf.toString();
    }
}

