/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import com.espertech.esper.common.client.soda.ConstantExpression;
import com.espertech.esper.common.client.soda.Expression;
import com.espertech.esper.common.client.soda.ExpressionBase;
import com.espertech.esper.common.client.soda.ExpressionPrecedenceEnum;
import com.espertech.esper.common.client.soda.PropertyValueExpression;
import java.io.StringWriter;

public class ArrayExpression
extends ExpressionBase {
    private static final long serialVersionUID = 5332982041846659978L;

    public ArrayExpression add(String property) {
        this.getChildren().add(new PropertyValueExpression(property));
        return this;
    }

    public ArrayExpression add(Object object) {
        this.getChildren().add(new ConstantExpression(object));
        return this;
    }

    public ArrayExpression add(Expression expression) {
        this.getChildren().add(expression);
        return this;
    }

    @Override
    public ExpressionPrecedenceEnum getPrecedence() {
        return ExpressionPrecedenceEnum.UNARY;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.write("{");
        boolean isFirst = true;
        for (Expression child : this.getChildren()) {
            if (!isFirst) {
                writer.write(",");
            }
            child.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            isFirst = false;
        }
        writer.write("}");
    }
}

