/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import com.espertech.esper.common.client.soda.CreateIndexColumnType;
import com.espertech.esper.common.client.soda.Expression;
import com.espertech.esper.common.client.soda.ExpressionBase;
import com.espertech.esper.common.client.soda.Expressions;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class CreateIndexColumn
implements Serializable {
    private static final long serialVersionUID = 0L;
    private List<Expression> columns;
    private String type;
    private List<Expression> parameters;

    public CreateIndexColumn() {
    }

    public CreateIndexColumn(String columnName) {
        this(columnName, CreateIndexColumnType.HASH);
    }

    public CreateIndexColumn(String columnName, CreateIndexColumnType type) {
        this.columns = Collections.singletonList(Expressions.property(columnName));
        this.type = type.name();
    }

    public CreateIndexColumn(List<Expression> columns, String type, List<Expression> parameters) {
        this.columns = columns;
        this.type = type;
        this.parameters = parameters;
    }

    public void toEPL(StringWriter writer) {
        if (this.columns.size() > 1) {
            writer.write("(");
        }
        ExpressionBase.toPrecedenceFreeEPL(this.columns, writer);
        if (this.columns.size() > 1) {
            writer.write(")");
        }
        if (this.type != null && !this.type.toLowerCase(Locale.ENGLISH).equals(CreateIndexColumnType.HASH.getNameLower())) {
            writer.write(32);
            writer.write(this.type.toLowerCase(Locale.ENGLISH));
        }
        if (!this.parameters.isEmpty()) {
            writer.write("(");
            ExpressionBase.toPrecedenceFreeEPL(this.parameters, writer);
            writer.write(")");
        }
    }

    public List<Expression> getColumns() {
        return this.columns;
    }

    public void setColumns(List<Expression> columns) {
        this.columns = columns;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public List<Expression> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Expression> parameters) {
        this.parameters = parameters;
    }
}

