/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import com.espertech.esper.common.client.soda.DotExpressionItem;
import com.espertech.esper.common.client.soda.DotExpressionItemCall;
import com.espertech.esper.common.client.soda.DotExpressionItemName;
import com.espertech.esper.common.client.soda.Expression;
import com.espertech.esper.common.client.soda.ExpressionBase;
import com.espertech.esper.common.client.soda.ExpressionPrecedenceEnum;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class DotExpression
extends ExpressionBase {
    private static final long serialVersionUID = -7597133103354244332L;
    private List<DotExpressionItem> chain = new ArrayList<DotExpressionItem>();

    public DotExpression() {
    }

    public DotExpression(Expression innerExpression) {
        this.getChildren().add(innerExpression);
    }

    public void add(DotExpressionItem item) {
        this.chain.add(item);
    }

    public void add(String methodName, List<Expression> parameters) {
        this.chain.add(new DotExpressionItemCall(methodName, parameters));
    }

    public void add(String name, List<Expression> parameters, boolean isProperty) {
        if (parameters.isEmpty() && isProperty) {
            this.chain.add(new DotExpressionItemName(name));
        } else {
            this.chain.add(new DotExpressionItemCall(name, parameters));
        }
    }

    public List<DotExpressionItem> getChain() {
        return this.chain;
    }

    @Override
    public ExpressionPrecedenceEnum getPrecedence() {
        return ExpressionPrecedenceEnum.MINIMUM;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        if (!this.getChildren().isEmpty()) {
            this.getChildren().get(0).toEPL(writer, this.getPrecedence());
        }
        DotExpressionItem.render(this.chain, writer, !this.getChildren().isEmpty());
    }
}

