/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import com.espertech.esper.common.client.soda.Expression;
import com.espertech.esper.common.client.soda.ExpressionPrecedenceEnum;
import com.espertech.esper.common.client.soda.FireAndForgetClause;
import java.io.StringWriter;
import java.util.List;

public class FireAndForgetInsert
implements FireAndForgetClause {
    private static final long serialVersionUID = -3565886245820109541L;
    private boolean useValuesKeyword = true;
    private List<List<Expression>> rows;

    public FireAndForgetInsert(boolean useValuesKeyword) {
        this.useValuesKeyword = useValuesKeyword;
    }

    public FireAndForgetInsert() {
    }

    public boolean isUseValuesKeyword() {
        return this.useValuesKeyword;
    }

    public void setUseValuesKeyword(boolean useValuesKeyword) {
        this.useValuesKeyword = useValuesKeyword;
    }

    public List<List<Expression>> getRows() {
        return this.rows;
    }

    public void setRows(List<List<Expression>> rows) {
        this.rows = rows;
    }

    public void toEPL(StringWriter writer) {
        writer.append("values ");
        String delimiter = "";
        for (List<Expression> row : this.rows) {
            writer.write(delimiter);
            this.renderRow(writer, row);
            delimiter = ", ";
        }
    }

    private void renderRow(StringWriter writer, List<Expression> row) {
        writer.write("(");
        String delimiter = "";
        for (Expression param : row) {
            writer.write(delimiter);
            delimiter = ", ";
            param.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
        }
        writer.write(")");
    }
}

