/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import com.espertech.esper.common.client.soda.ConstantExpression;
import com.espertech.esper.common.client.soda.Expression;
import com.espertech.esper.common.client.soda.ExpressionBase;
import com.espertech.esper.common.client.soda.ExpressionPrecedenceEnum;
import com.espertech.esper.common.client.soda.PropertyValueExpression;
import java.io.StringWriter;

public class InExpression
extends ExpressionBase {
    private boolean notIn;
    private static final long serialVersionUID = -5105764419995579144L;

    public InExpression() {
    }

    public InExpression(boolean isNotIn) {
        this.notIn = isNotIn;
    }

    public InExpression(Expression value, boolean isNotIn, Object ... parameters) {
        this.notIn = isNotIn;
        this.getChildren().add(value);
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i] instanceof Expression) {
                this.getChildren().add((Expression)parameters[i]);
                continue;
            }
            this.getChildren().add(new ConstantExpression(parameters[i]));
        }
    }

    public InExpression(Expression value, boolean isNotIn, Expression[] parameters) {
        this.notIn = isNotIn;
        this.getChildren().add(value);
        for (Expression parameter : parameters) {
            this.getChildren().add(parameter);
        }
    }

    public boolean isNotIn() {
        return this.notIn;
    }

    public boolean getNotIn() {
        return this.notIn;
    }

    public void setNotIn(boolean notIn) {
        this.notIn = notIn;
    }

    public InExpression add(Object object) {
        this.getChildren().add(new ConstantExpression(object));
        return this;
    }

    public InExpression add(Expression expression) {
        this.getChildren().add(expression);
        return this;
    }

    public InExpression add(String propertyName) {
        this.getChildren().add(new PropertyValueExpression(propertyName));
        return this;
    }

    @Override
    public ExpressionPrecedenceEnum getPrecedence() {
        return ExpressionPrecedenceEnum.RELATIONAL_BETWEEN_IN;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        this.getChildren().get(0).toEPL(writer, this.getPrecedence());
        if (this.notIn) {
            writer.write(" not in (");
        } else {
            writer.write(" in (");
        }
        String delimiter = "";
        for (int i = 1; i < this.getChildren().size(); ++i) {
            writer.write(delimiter);
            this.getChildren().get(i).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            delimiter = ",";
        }
        writer.write(41);
    }
}

