/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import com.espertech.esper.common.client.soda.Expression;
import com.espertech.esper.common.client.soda.ExpressionPrecedenceEnum;
import com.espertech.esper.common.client.soda.MatchRecognizeDefine;
import com.espertech.esper.common.client.soda.MatchRecognizeIntervalClause;
import com.espertech.esper.common.client.soda.MatchRecognizeRegEx;
import com.espertech.esper.common.client.soda.MatchRecognizeSkipClause;
import com.espertech.esper.common.client.soda.SelectClauseExpression;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class MatchRecognizeClause
implements Serializable {
    private static final long serialVersionUID = -344174798312697242L;
    private List<Expression> partitionExpressions = new ArrayList<Expression>();
    private List<SelectClauseExpression> measures = new ArrayList<SelectClauseExpression>();
    private boolean all;
    private MatchRecognizeSkipClause skipClause = MatchRecognizeSkipClause.PAST_LAST_ROW;
    private MatchRecognizeRegEx pattern;
    private MatchRecognizeIntervalClause intervalClause;
    private List<MatchRecognizeDefine> defines = new ArrayList<MatchRecognizeDefine>();

    public void toEPL(StringWriter writer) {
        String delimiter;
        writer.write(" match_recognize (");
        if (this.partitionExpressions.size() > 0) {
            delimiter = "";
            writer.write(" partition by ");
            for (Expression expression : this.partitionExpressions) {
                writer.write(delimiter);
                expression.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
                delimiter = ", ";
            }
        }
        delimiter = "";
        writer.write(" measures ");
        for (SelectClauseExpression selectClauseExpression : this.measures) {
            writer.write(delimiter);
            selectClauseExpression.toEPLElement(writer);
            delimiter = ", ";
        }
        if (this.all) {
            writer.write(" all matches");
        }
        if (this.skipClause != MatchRecognizeSkipClause.PAST_LAST_ROW) {
            writer.write(" after match skip " + this.skipClause.getText());
        }
        writer.write(" pattern (");
        this.pattern.writeEPL(writer);
        writer.write(")");
        if (this.intervalClause != null && this.intervalClause.getExpression() != null) {
            writer.write(" interval ");
            this.intervalClause.getExpression().toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            if (this.intervalClause.isOrTerminated()) {
                writer.write(" or terminated");
            }
        }
        delimiter = "";
        if (!this.defines.isEmpty()) {
            writer.write(" define ");
            for (MatchRecognizeDefine matchRecognizeDefine : this.defines) {
                writer.write(delimiter);
                writer.write(matchRecognizeDefine.getName());
                writer.write(" as ");
                matchRecognizeDefine.getExpression().toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
                delimiter = ", ";
            }
        }
        writer.write(")");
    }

    public List<Expression> getPartitionExpressions() {
        return this.partitionExpressions;
    }

    public void setPartitionExpressions(List<Expression> partitionExpressions) {
        this.partitionExpressions = partitionExpressions;
    }

    public List<SelectClauseExpression> getMeasures() {
        return this.measures;
    }

    public void setMeasures(List<SelectClauseExpression> measures) {
        this.measures = measures;
    }

    public boolean isAll() {
        return this.all;
    }

    public void setAll(boolean all) {
        this.all = all;
    }

    public MatchRecognizeSkipClause getSkipClause() {
        return this.skipClause;
    }

    public void setSkipClause(MatchRecognizeSkipClause skipClause) {
        this.skipClause = skipClause;
    }

    public List<MatchRecognizeDefine> getDefines() {
        return this.defines;
    }

    public void setDefines(List<MatchRecognizeDefine> defines) {
        this.defines = defines;
    }

    public MatchRecognizeIntervalClause getIntervalClause() {
        return this.intervalClause;
    }

    public void setIntervalClause(MatchRecognizeIntervalClause intervalClause) {
        this.intervalClause = intervalClause;
    }

    public MatchRecognizeRegEx getPattern() {
        return this.pattern;
    }

    public void setPattern(MatchRecognizeRegEx pattern) {
        this.pattern = pattern;
    }
}

