/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import com.espertech.esper.common.client.soda.ArrayExpression;
import com.espertech.esper.common.client.soda.Expression;
import com.espertech.esper.common.client.soda.ExpressionBase;
import com.espertech.esper.common.client.soda.ExpressionPrecedenceEnum;
import java.io.StringWriter;

public class NewInstanceOperatorExpression
extends ExpressionBase {
    private static final long serialVersionUID = 4725168176516142366L;
    private String className;
    private int numArrayDimensions;

    public NewInstanceOperatorExpression() {
    }

    public NewInstanceOperatorExpression(String className) {
        this.className = className;
    }

    public NewInstanceOperatorExpression(String className, int numArrayDimensions) {
        this.className = className;
        this.numArrayDimensions = numArrayDimensions;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public int getNumArrayDimensions() {
        return this.numArrayDimensions;
    }

    public void setNumArrayDimensions(int numArrayDimensions) {
        this.numArrayDimensions = numArrayDimensions;
    }

    @Override
    public ExpressionPrecedenceEnum getPrecedence() {
        return ExpressionPrecedenceEnum.UNARY;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.write("new ");
        writer.write(this.className);
        if (this.numArrayDimensions == 0) {
            writer.write("(");
            ExpressionBase.toPrecedenceFreeEPL(this.getChildren(), writer);
            writer.write(")");
        } else if (this.getChildren().size() == 1 && this.getChildren().get(0) instanceof ArrayExpression) {
            for (int i = 0; i < this.numArrayDimensions; ++i) {
                writer.write("[]");
            }
            writer.write(" ");
            this.getChildren().get(0).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
        } else {
            for (Expression expression : this.getChildren()) {
                writer.write("[");
                expression.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
                writer.write("]");
            }
            if (this.numArrayDimensions > this.getChildren().size()) {
                writer.write("[]");
            }
        }
    }
}

